/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.create;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;

public class CreateTableOperation
extends DDLOperation<CreateTableDesc> {
    public CreateTableOperation(DDLOperationContext context, CreateTableDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table existingTable;
        Table tbl = ((CreateTableDesc)this.desc).toTable(this.context.getConf());
        LOG.debug("creating table {} on {}", (Object)tbl.getFullyQualifiedName(), (Object)tbl.getDataLocation());
        boolean replDataLocationChanged = false;
        if (((CreateTableDesc)this.desc).getReplicationSpec().isInReplicationScope() && (existingTable = this.context.getDb().getTable(tbl.getDbName(), tbl.getTableName(), false)) != null) {
            if (((CreateTableDesc)this.desc).getReplicationSpec().allowEventReplacementInto(existingTable.getParameters())) {
                ((CreateTableDesc)this.desc).setReplaceMode(true);
                ReplicationSpec.copyLastReplId(existingTable.getParameters(), tbl.getParameters());
                if (existingTable.getTableType().equals((Object)TableType.MANAGED_TABLE) && tbl.getTableType().equals((Object)TableType.EXTERNAL_TABLE) && !existingTable.getDataLocation().equals((Object)tbl.getDataLocation())) {
                    replDataLocationChanged = true;
                }
            } else {
                LOG.debug("DDLTask: Create Table is skipped as table {} is newer than update", (Object)((CreateTableDesc)this.desc).getDbTableName());
                return 0;
            }
        }
        if (((CreateTableDesc)this.desc).getReplaceMode()) {
            this.createTableReplaceMode(tbl, replDataLocationChanged);
        } else {
            if (((CreateTableDesc)this.desc).getReplicationSpec().isInReplicationScope() && !tbl.getParameters().containsKey("repl.last.id")) {
                tbl.getParameters().put("repl.last.id", "0");
            }
            this.createTableNonReplaceMode(tbl);
        }
        DDLUtils.addIfAbsentByName(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK), this.context);
        return 0;
    }

    private void createTableReplaceMode(Table tbl, boolean replDataLocationChanged) throws HiveException {
        ReplicationSpec replicationSpec = ((CreateTableDesc)this.desc).getReplicationSpec();
        Long writeId = 0L;
        EnvironmentContext environmentContext = null;
        if (replicationSpec != null && replicationSpec.isInReplicationScope()) {
            writeId = ((CreateTableDesc)this.desc).getReplWriteId();
            environmentContext = new EnvironmentContext();
            environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        }
        if (replDataLocationChanged) {
            environmentContext = ReplUtils.setReplDataLocationChangedFlag(environmentContext);
        }
        this.context.getDb().alterTable(tbl.getCatName(), tbl.getDbName(), tbl.getTableName(), tbl, false, environmentContext, true, writeId);
    }

    private void createTableNonReplaceMode(Table tbl) throws HiveException {
        if (CollectionUtils.isNotEmpty(((CreateTableDesc)this.desc).getPrimaryKeys()) || CollectionUtils.isNotEmpty(((CreateTableDesc)this.desc).getForeignKeys()) || CollectionUtils.isNotEmpty(((CreateTableDesc)this.desc).getUniqueConstraints()) || CollectionUtils.isNotEmpty(((CreateTableDesc)this.desc).getNotNullConstraints()) || CollectionUtils.isNotEmpty(((CreateTableDesc)this.desc).getDefaultConstraints()) || CollectionUtils.isNotEmpty(((CreateTableDesc)this.desc).getCheckConstraints())) {
            this.context.getDb().createTable(tbl, ((CreateTableDesc)this.desc).getIfNotExists(), ((CreateTableDesc)this.desc).getPrimaryKeys(), ((CreateTableDesc)this.desc).getForeignKeys(), ((CreateTableDesc)this.desc).getUniqueConstraints(), ((CreateTableDesc)this.desc).getNotNullConstraints(), ((CreateTableDesc)this.desc).getDefaultConstraints(), ((CreateTableDesc)this.desc).getCheckConstraints());
        } else {
            this.context.getDb().createTable(tbl, ((CreateTableDesc)this.desc).getIfNotExists());
        }
        if (((CreateTableDesc)this.desc).isCTAS()) {
            Table createdTable = this.context.getDb().getTable(tbl.getDbName(), tbl.getTableName());
            LineageInfo.DataContainer dc = new LineageInfo.DataContainer(createdTable.getTTable());
            this.context.getQueryState().getLineageState().setLineage(createdTable.getPath(), dc, createdTable.getCols());
            if (!createdTable.isPartitioned() && AcidUtils.isTransactionalTable(createdTable)) {
                org.apache.hadoop.hive.metastore.api.Table tTable = createdTable.getTTable();
                Path tabLocation = new Path(tTable.getSd().getLocation());
                ArrayList<FileStatus> newFilesList = new ArrayList<FileStatus>();
                try {
                    Hive.listFilesInsideAcidDirectory(tabLocation, tabLocation.getFileSystem((Configuration)this.context.getConf()), newFilesList);
                }
                catch (IOException e) {
                    LOG.error("Error listing files", (Throwable)e);
                    throw new HiveException(e);
                }
                this.context.getDb().addWriteNotificationLog(createdTable, null, newFilesList, tTable.getWriteId());
            }
        }
    }

    public static boolean doesTableNeedLocation(Table tbl) {
        boolean retval = true;
        if (tbl.getStorageHandler() != null) {
            String sh = tbl.getStorageHandler().toString();
            retval = !"org.apache.hadoop.hive.hbase.HBaseStorageHandler".equals(sh) && !"org.apache.hadoop.hive.druid.DruidStorageHandler".equals(sh) && !"org.apache.hive.storage.jdbc.JdbcStorageHandler".equals(sh) && !"org.apache.hadoop.hive.accumulo.AccumuloStorageHandler".equals(sh);
        }
        return retval;
    }

    public static void makeLocationQualified(Table table, HiveConf conf) throws HiveException {
        StorageDescriptor sd = table.getTTable().getSd();
        Path path = null;
        if (sd.isSetLocation()) {
            path = new Path(sd.getLocation());
        }
        if (path != null) {
            sd.setLocation(Utilities.getQualifiedPath(conf, path));
        }
    }
}

