/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.properties;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.info.show.properties.ShowTablePropertiesDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;

public class ShowTablePropertiesOperation
extends DDLOperation<ShowTablePropertiesDesc> {
    public ShowTablePropertiesOperation(DDLOperationContext context, ShowTablePropertiesDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        String tableName = ((ShowTablePropertiesDesc)this.desc).getTableName();
        Table tbl = this.context.getDb().getTable(tableName, false);
        try {
            if (tbl == null) {
                String errMsg = "Table " + tableName + " does not exist";
                DDLUtils.writeToFile(errMsg, ((ShowTablePropertiesDesc)this.desc).getResFile(), this.context);
                return 0;
            }
            LOG.info("DDLTask: show properties for {}", (Object)tableName);
            StringBuilder builder = new StringBuilder();
            String propertyName = ((ShowTablePropertiesDesc)this.desc).getPropertyName();
            if (propertyName != null) {
                String propertyValue = tbl.getProperty(propertyName);
                if (propertyValue == null) {
                    String errMsg = "Table " + tableName + " does not have property: " + propertyName;
                    builder.append(errMsg);
                } else {
                    builder.append(propertyValue);
                }
            } else {
                TreeMap<String, String> properties = new TreeMap<String, String>(tbl.getParameters());
                for (Map.Entry entry : properties.entrySet()) {
                    DDLUtils.appendNonNull(builder, entry.getKey(), true);
                    DDLUtils.appendNonNull(builder, entry.getValue());
                }
            }
            LOG.info("DDLTask: written data for showing properties of {}", (Object)tableName);
            DDLUtils.writeToFile(builder.toString(), ((ShowTablePropertiesDesc)this.desc).getResFile(), this.context);
        }
        catch (IOException e) {
            LOG.info("show table properties: ", (Throwable)e);
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return 0;
    }
}

