/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.tables;

import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.info.show.tables.ShowTablesDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

@DDLSemanticAnalyzerFactory.DDLType(types={1072})
public class ShowTablesAnalyzer
extends BaseSemanticAnalyzer {
    public ShowTablesAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() > 4) {
            throw new SemanticException(ErrorMsg.INVALID_AST_TREE.getMsg(root.toStringTree()));
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String dbName = SessionState.get().getCurrentDatabase();
        String tableNames = null;
        TableType tableTypeFilter = null;
        boolean isExtended = false;
        for (int i = 0; i < root.getChildCount(); ++i) {
            ASTNode child = (ASTNode)root.getChild(i);
            if (child.getType() == 907) {
                dbName = ShowTablesAnalyzer.unescapeIdentifier(root.getChild(++i).getText());
                this.db.validateDatabaseExists(dbName);
                continue;
            }
            if (child.getType() == 1132) {
                String tableType = ShowTablesAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                if (!"table_type".equalsIgnoreCase(tableType)) {
                    throw new SemanticException("SHOW TABLES statement only allows equality filter on table_type value");
                }
                tableTypeFilter = TableType.valueOf(ShowTablesAnalyzer.unescapeSQLString(child.getChild(1).getText()));
                continue;
            }
            if (child.getType() == 133) {
                isExtended = true;
                continue;
            }
            tableNames = ShowTablesAnalyzer.unescapeSQLString(child.getText());
        }
        this.inputs.add(new ReadEntity(this.getDatabase(dbName)));
        ShowTablesDesc desc = new ShowTablesDesc(this.ctx.getResFile(), dbName, tableNames, tableTypeFilter, isExtended);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask(desc.getSchema()));
    }
}

