/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.tables;

import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.info.show.tables.ShowTablesDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;

public class ShowTablesOperation
extends DDLOperation<ShowTablesDesc> {
    public ShowTablesOperation(DDLOperationContext context, ShowTablesDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        String dbName = ((ShowTablesDesc)this.desc).getDbName();
        String pattern = ((ShowTablesDesc)this.desc).getPattern();
        TableType typeFilter = ((ShowTablesDesc)this.desc).getTypeFilter();
        String resultsFile = ((ShowTablesDesc)this.desc).getResFile();
        boolean isExtended = ((ShowTablesDesc)this.desc).isExtended();
        if (!this.context.getDb().databaseExists(dbName)) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, dbName);
        }
        List<String> tableNames = null;
        ArrayList<Table> tableObjects = null;
        if (isExtended) {
            tableObjects = new ArrayList<Table>();
            tableObjects.addAll(this.context.getDb().getTableObjectsByType(dbName, pattern, typeFilter));
            LOG.debug("Found {} table(s) matching the SHOW EXTENDED TABLES statement.", (Object)tableObjects.size());
        } else {
            tableNames = this.context.getDb().getTablesByType(dbName, pattern, typeFilter);
            LOG.debug("Found {} table(s) matching the SHOW TABLES statement.", (Object)tableNames.size());
        }
        try (DataOutputStream os = DDLUtils.getOutputStream(new Path(resultsFile), this.context);){
            if (tableNames != null) {
                TreeSet<String> sortedSet = new TreeSet<String>(tableNames);
                this.context.getFormatter().showTables(os, sortedSet);
            } else {
                Collections.sort(tableObjects, Comparator.comparing(Table::getTableName));
                if (isExtended) {
                    this.context.getFormatter().showTablesExtended(os, tableObjects);
                } else {
                    this.context.getFormatter().showMaterializedViews(os, tableObjects);
                }
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, "in database" + dbName);
        }
        return 0;
    }
}

