/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.alter;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.partition.alter.AlterTableAlterPartitionDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={784})
public class AlterTableAlterPartitionAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableAlterPartitionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Table table = this.getTable(tableName);
        this.validateAlterTableType(table, AlterTableType.ALTERPARTITION, false);
        this.inputs.add(new ReadEntity(table));
        ASTNode colAst = (ASTNode)command.getChild(0);
        String name = colAst.getChild(0).getText().toLowerCase();
        String type = AlterTableAlterPartitionAnalyzer.getTypeStringFromAST((ASTNode)colAst.getChild(1));
        String comment = colAst.getChildCount() == 3 ? AlterTableAlterPartitionAnalyzer.unescapeSQLString(colAst.getChild(2).getText()) : null;
        FieldSchema newCol = new FieldSchema(AlterTableAlterPartitionAnalyzer.unescapeIdentifier(name), type, comment);
        boolean isDefined = false;
        for (FieldSchema col : table.getTTable().getPartitionKeys()) {
            if (col.getName().compareTo(newCol.getName()) != 0) continue;
            isDefined = true;
        }
        if (!isDefined) {
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(newCol.getName()));
        }
        AlterTableAlterPartitionDesc desc = new AlterTableAlterPartitionDesc(tableName.getNotEmptyDbTable(), newCol);
        if (AcidUtils.isTransactionalTable(table)) {
            this.setAcidDdlDesc(desc);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

