/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.drop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.partition.drop.AlterTableDropPartitionDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;

abstract class AbstractDropPartitionAnalyzer
extends AbstractAlterTableAnalyzer {
    AbstractDropPartitionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        boolean ifExists;
        boolean canGroupExprs = ifExists = command.getFirstChildWithType(922) != null || HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROP_IGNORES_NON_EXISTENT);
        boolean mustPurge = command.getFirstChildWithType(253) != null;
        ReplicationSpec replicationSpec = new ReplicationSpec(command);
        Table table = null;
        try {
            table = this.getTable(tableName);
        }
        catch (SemanticException se) {
            if (replicationSpec.isInReplicationScope() && (se.getCause() instanceof InvalidTableException || se.getMessage().contains(ErrorMsg.INVALID_TABLE.getMsg()))) {
                return;
            }
            throw se;
        }
        Map<Integer, List<ExprNodeGenericFuncDesc>> partitionSpecs = ParseUtils.getFullPartitionSpecs(command, table, this.conf, canGroupExprs);
        if (partitionSpecs.isEmpty()) {
            return;
        }
        this.validateAlterTableType(table, AlterTableType.DROPPARTITION, this.expectView());
        ReadEntity re = new ReadEntity(table);
        re.noLockNeeded();
        this.inputs.add(re);
        this.addTableDropPartsOutputs(table, partitionSpecs.values(), !ifExists);
        AlterTableDropPartitionDesc desc = new AlterTableDropPartitionDesc(tableName, partitionSpecs, mustPurge, replicationSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    protected abstract boolean expectView();

    private void addTableDropPartsOutputs(Table tab, Collection<List<ExprNodeGenericFuncDesc>> partitionSpecs, boolean throwIfNonExistent) throws SemanticException {
        for (List<ExprNodeGenericFuncDesc> specs : partitionSpecs) {
            for (ExprNodeGenericFuncDesc partitionSpec : specs) {
                ArrayList<Partition> parts = new ArrayList<Partition>();
                boolean hasUnknown = false;
                try {
                    hasUnknown = this.db.getPartitionsByExpr(tab, partitionSpec, this.conf, parts);
                }
                catch (Exception e) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partitionSpec.getExprString()), e);
                }
                if (hasUnknown) {
                    throw new SemanticException("Unexpected unknown partitions for " + partitionSpec.getExprString());
                }
                if (parts.isEmpty() && throwIfNonExistent) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partitionSpec.getExprString()));
                }
                for (Partition p : parts) {
                    this.outputs.add(new WriteEntity(p, WriteEntity.WriteType.DDL_EXCLUSIVE));
                }
            }
        }
    }
}

