/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.show;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Show Partitions", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ShowPartitionsDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SCHEMA = "partition#string";
    private final String tabName;
    private final String resFile;
    private final Map<String, String> partSpec;

    public ShowPartitionsDesc(String tabName, Path resFile, Map<String, String> partSpec) {
        this.tabName = tabName;
        this.resFile = resFile.toString();
        this.partSpec = partSpec;
    }

    @Explain(displayName="table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTabName() {
        return this.tabName;
    }

    @Explain(displayName="partSpec", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getPartSpec() {
        return this.partSpec;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }
}

