/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.show;

import java.io.DataOutputStream;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.show.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;

public class ShowPartitionsOperation
extends DDLOperation<ShowPartitionsDesc> {
    public ShowPartitionsOperation(DDLOperationContext context, ShowPartitionsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table tbl = this.context.getDb().getTable(((ShowPartitionsDesc)this.desc).getTabName());
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, ((ShowPartitionsDesc)this.desc).getTabName());
        }
        List<String> parts = null;
        parts = ((ShowPartitionsDesc)this.desc).getPartSpec() != null ? this.context.getDb().getPartitionNames(tbl.getDbName(), tbl.getTableName(), ((ShowPartitionsDesc)this.desc).getPartSpec(), (short)-1) : this.context.getDb().getPartitionNames(tbl.getDbName(), tbl.getTableName(), (short)-1);
        try (DataOutputStream outStream = DDLUtils.getOutputStream(new Path(((ShowPartitionsDesc)this.desc).getResFile()), this.context);){
            this.context.getFormatter().showTablePartitions(outStream, parts);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, "show partitions for table " + ((ShowPartitionsDesc)this.desc).getTabName());
        }
        return 0;
    }
}

