/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.alter.validate;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.alter.validate.AlterResourcePlanValidateDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={818})
public class AlterResourcePlanValidateAnalyzer
extends BaseSemanticAnalyzer {
    public AlterResourcePlanValidateAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() != 1) {
            throw new SemanticException("Incorrect syntax");
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String resourcePlanName = AlterResourcePlanValidateAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        AlterResourcePlanValidateDesc desc = new AlterResourcePlanValidateDesc(resourcePlanName, this.ctx.getResFile());
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("error#string"));
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

