/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show.ShowResourcePlanDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ShowResourcePlanOperation
extends DDLOperation<ShowResourcePlanDesc> {
    public ShowResourcePlanOperation(DDLOperationContext context, ShowResourcePlanDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException, IOException {
        try (DataOutputStream out = DDLUtils.getOutputStream(new Path(((ShowResourcePlanDesc)this.desc).getResFile()), this.context);){
            String resourcePlanName = ((ShowResourcePlanDesc)this.desc).getResourcePlanName();
            if (resourcePlanName != null) {
                this.context.getFormatter().showFullResourcePlan(out, this.context.getDb().getResourcePlan(resourcePlanName));
            } else {
                this.context.getFormatter().showResourcePlans(out, this.context.getDb().getAllResourcePlans());
            }
        }
        return 0;
    }
}

