/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Comparator;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.util.NullOrdering;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

public class KeyWrapperComparator
implements Comparator<KeyWrapper> {
    private final ObjectInspector[] newObjectInspectors;
    private final ObjectInspector[] copyObjectInspectors;
    private final boolean[] columnSortOrderIsDesc;
    private final ObjectInspectorUtils.NullValueOption[] nullSortOrder;

    KeyWrapperComparator(ObjectInspector[] newObjectInspectors, ObjectInspector[] copyObjectInspectors, String columnSortOrder, String nullSortOrder) {
        this.newObjectInspectors = newObjectInspectors;
        this.copyObjectInspectors = copyObjectInspectors;
        this.columnSortOrderIsDesc = new boolean[columnSortOrder.length()];
        this.nullSortOrder = new ObjectInspectorUtils.NullValueOption[nullSortOrder.length()];
        for (int i = 0; i < columnSortOrder.length(); ++i) {
            this.columnSortOrderIsDesc[i] = columnSortOrder.charAt(i) == '-';
            this.nullSortOrder[i] = NullOrdering.fromSign(nullSortOrder.charAt(i)).getNullValueOption();
        }
    }

    @Override
    public int compare(KeyWrapper key1, KeyWrapper key2) {
        return ObjectInspectorUtils.compare(key1.getKeyArray(), key1.isCopy() ? this.copyObjectInspectors : this.newObjectInspectors, key2.getKeyArray(), key2.isCopy() ? this.copyObjectInspectors : this.newObjectInspectors, this.columnSortOrderIsDesc, this.nullSortOrder);
    }
}

