/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.repl.CopyUtils;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.ReplCopyWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplCopyTask
extends Task<ReplCopyWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(ReplCopyTask.class);

    @Override
    public int execute() {
        LOG.debug("ReplCopyTask.execute()");
        FileSystem dstFs = null;
        Path toPath = null;
        try {
            if (((ReplCopyWork)this.work).getFromPaths().length > 1 || ((ReplCopyWork)this.work).getToPaths().length > 1) {
                throw new RuntimeException("Invalid ReplCopyWork: " + ((ReplCopyWork)this.work).getFromPaths() + ", " + ((ReplCopyWork)this.work).getToPaths());
            }
            Path fromPath = ((ReplCopyWork)this.work).getFromPaths()[0];
            toPath = ((ReplCopyWork)this.work).getToPaths()[0];
            this.console.printInfo("Copying data from " + fromPath.toString(), " to " + toPath.toString());
            ReplCopyWork rwork = (ReplCopyWork)this.work;
            FileSystem srcFs = fromPath.getFileSystem((Configuration)this.conf);
            dstFs = toPath.getFileSystem((Configuration)this.conf);
            if (ReplChangeManager.isCMFileUri(fromPath)) {
                String[] result = ReplChangeManager.decodeFileUri(fromPath.toString());
                ReplChangeManager.FileInfo sourceInfo = ReplChangeManager.getFileInfo(new Path(result[0]), result[1], result[2], result[3], this.conf);
                if (FileUtils.copy(sourceInfo.getSrcFs(), sourceInfo.getSourcePath(), dstFs, toPath, false, false, this.conf)) {
                    return 0;
                }
                this.console.printError("Failed to copy: '" + fromPath.toString() + "to: '" + toPath.toString() + "'");
                return 1;
            }
            List<Object> srcFiles = new ArrayList();
            if (rwork.readSrcAsFilesList()) {
                srcFiles = this.filesInFileListing(srcFs, fromPath);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ReplCopyTask _files contains: {}", srcFiles == null ? "null" : Integer.valueOf(srcFiles.size()));
                }
                if (srcFiles == null || srcFiles.isEmpty()) {
                    if (((ReplCopyWork)this.work).isErrorOnSrcEmpty()) {
                        this.console.printError("No _files entry found on source: " + fromPath.toString());
                        return 5;
                    }
                    return 0;
                }
            } else {
                FileStatus[] srcs = LoadSemanticAnalyzer.matchFilesOrDir(srcFs, fromPath);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ReplCopyTasks srcs= {}", srcs == null ? "null" : Integer.valueOf(srcs.length));
                }
                if (srcs == null || srcs.length == 0) {
                    if (((ReplCopyWork)this.work).isErrorOnSrcEmpty()) {
                        this.console.printError("No files matching path: " + fromPath.toString());
                        return 3;
                    }
                    return 0;
                }
                for (FileStatus oneSrc : srcs) {
                    this.console.printInfo("Copying file: " + oneSrc.getPath().toString());
                    LOG.debug("ReplCopyTask :cp:{}=>{}", (Object)oneSrc.getPath(), (Object)toPath);
                    srcFiles.add(new ReplChangeManager.FileInfo(oneSrc.getPath().getFileSystem((Configuration)this.conf), oneSrc.getPath(), null));
                }
            }
            LOG.debug("ReplCopyTask numFiles: {}", (Object)srcFiles.size());
            if (((ReplCopyWork)this.work).getDeleteDestIfExist() && dstFs.exists(toPath)) {
                LOG.debug(" path " + toPath + " is cleaned before renaming");
                this.getHive().cleanUpOneDirectoryForReplace(toPath, dstFs, FileUtils.HIDDEN_FILES_PATH_FILTER, this.conf, ((ReplCopyWork)this.work).getNeedRecycle(), ((ReplCopyWork)this.work).getIsAutoPurge());
            }
            if (!FileUtils.mkdir(dstFs, toPath, this.conf)) {
                this.console.printError("Cannot make target directory: " + toPath.toString());
                return 2;
            }
            CopyUtils copyUtils = new CopyUtils(rwork.distCpDoAsUser(), this.conf, dstFs);
            copyUtils.copyAndVerify(toPath, srcFiles, fromPath, ((ReplCopyWork)this.work).readSrcAsFilesList(), ((ReplCopyWork)this.work).isOverWrite());
            copyUtils.renameFileCopiedFromCmPath(toPath, dstFs, srcFiles);
            return 0;
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            this.setException(e);
            return ReplUtils.handleException(true, e, ((ReplCopyWork)this.work).getDumpDirectory(), ((ReplCopyWork)this.work).getMetricCollector(), this.getName(), this.conf);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<ReplChangeManager.FileInfo> filesInFileListing(FileSystem fs, Path dataPath) throws IOException {
        Path fileListing = new Path(dataPath, "_files");
        LOG.debug("ReplCopyTask filesInFileListing() reading {}", (Object)fileListing.toUri());
        if (!fs.exists(fileListing)) {
            LOG.debug("ReplCopyTask : _files does not exist");
            return null;
        }
        ArrayList<ReplChangeManager.FileInfo> filePaths = new ArrayList<ReplChangeManager.FileInfo>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(fileListing)));){
            String line;
            while ((line = br.readLine()) != null) {
                LOG.debug("ReplCopyTask :_filesReadLine: {}", (Object)line);
                String[] fragments = ReplChangeManager.decodeFileUri(line);
                try {
                    ReplChangeManager.FileInfo f = ReplChangeManager.getFileInfo(new Path(fragments[0]), fragments[1], fragments[2], fragments[3], this.conf);
                    filePaths.add(f);
                }
                catch (MetaException e) {
                    LOG.warn("Cannot find {} in source repo or cmroot", (Object)fragments[0]);
                    throw new IOException(e.getMessage());
                    return filePaths;
                }
            }
        }
    }

    @Override
    public StageType getType() {
        return StageType.COPY;
    }

    @Override
    public String getName() {
        return "REPL_COPY";
    }

    public static Task<?> getLoadCopyTask(ReplicationSpec replicationSpec, Path srcPath, Path dstPath, HiveConf conf, boolean isAutoPurge, boolean needRecycle, boolean readSourceAsFileList, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        return ReplCopyTask.getLoadCopyTask(replicationSpec, srcPath, dstPath, conf, isAutoPurge, needRecycle, readSourceAsFileList, false, true, dumpDirectory, metricCollector);
    }

    private static Task<?> getLoadCopyTask(ReplicationSpec replicationSpec, Path srcPath, Path dstPath, HiveConf conf, boolean isAutoPurge, boolean needRecycle, boolean readSourceAsFileList, boolean overWrite, boolean deleteDestination, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        Task<CopyWork> copyTask = null;
        LOG.debug("ReplCopyTask:getLoadCopyTask: {}=>{}", (Object)srcPath, (Object)dstPath);
        if (replicationSpec != null && replicationSpec.isInReplicationScope()) {
            ReplCopyWork rcwork = new ReplCopyWork(srcPath, dstPath, false, overWrite, dumpDirectory, metricCollector);
            rcwork.setReadSrcAsFilesList(readSourceAsFileList);
            if (replicationSpec.isReplace() && deleteDestination) {
                rcwork.setDeleteDestIfExist(true);
                rcwork.setAutoPurge(isAutoPurge);
                rcwork.setNeedRecycle(needRecycle);
            }
            rcwork.setCheckDuplicateCopy(replicationSpec.needDupCopyCheck() && !replicationSpec.isReplace());
            LOG.debug("ReplCopyTask:\trcwork");
            String distCpDoAsUser = conf.getVar(HiveConf.ConfVars.HIVE_DISTCP_DOAS_USER);
            rcwork.setDistCpDoAsUser(distCpDoAsUser);
            copyTask = TaskFactory.get(rcwork, conf);
        } else {
            LOG.debug("ReplCopyTask:\tcwork");
            copyTask = TaskFactory.get(new CopyWork(srcPath, dstPath, false, dumpDirectory, metricCollector, true), conf);
        }
        return copyTask;
    }

    public static Task<?> getLoadCopyTask(ReplicationSpec replicationSpec, Path srcPath, Path dstPath, HiveConf conf, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        return ReplCopyTask.getLoadCopyTask(replicationSpec, srcPath, dstPath, conf, false, false, true, false, true, dumpDirectory, metricCollector);
    }

    public static Task<?> getLoadCopyTask(ReplicationSpec replicationSpec, Path srcPath, Path dstPath, HiveConf conf, boolean readSourceAsFileList, boolean overWrite, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        return ReplCopyTask.getLoadCopyTask(replicationSpec, srcPath, dstPath, conf, false, false, readSourceAsFileList, overWrite, true, dumpDirectory, metricCollector);
    }

    public static Task<?> getDumpCopyTask(ReplicationSpec replicationSpec, Path srcPath, Path dstPath, HiveConf conf, boolean readSourceAsFileList, boolean overWrite, boolean deleteDestination, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        return ReplCopyTask.getLoadCopyTask(replicationSpec, srcPath, dstPath, conf, false, false, readSourceAsFileList, overWrite, deleteDestination, dumpDirectory, metricCollector);
    }

    public static Task<?> getDumpCopyTask(ReplicationSpec replicationSpec, Path srcPath, Path dstPath, HiveConf conf, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        return ReplCopyTask.getLoadCopyTask(replicationSpec, srcPath, dstPath, conf, false, false, true, false, true, dumpDirectory, metricCollector);
    }
}

