/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;

public class RowSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ColumnInfo> signature = new ArrayList<ColumnInfo>();

    public RowSchema() {
    }

    public RowSchema(RowSchema that) {
        this.signature = new ArrayList<ColumnInfo>(that.signature);
    }

    public RowSchema(List<ColumnInfo> signature) {
        this.signature = signature;
    }

    public void setSignature(List<ColumnInfo> signature) {
        this.signature = signature;
    }

    public List<ColumnInfo> getSignature() {
        return this.signature;
    }

    public ColumnInfo getColumnInfo(String internalName) {
        for (ColumnInfo columnInfo : this.signature) {
            if (!columnInfo.getInternalName().equals(internalName)) continue;
            return columnInfo;
        }
        return null;
    }

    public ColumnInfo getColumnInfo(String tabAlias, String alias) {
        for (ColumnInfo columnInfo : this.signature) {
            if (!(columnInfo.getTabAlias() == null ? tabAlias == null && columnInfo.getAlias() != null && alias != null && columnInfo.getAlias().equals(alias) : tabAlias != null && columnInfo.getTabAlias().equals(tabAlias) && columnInfo.getAlias() != null && alias != null && columnInfo.getAlias().equals(alias))) continue;
            return columnInfo;
        }
        return null;
    }

    public int getPosition(String internalName) {
        int pos = -1;
        for (ColumnInfo var : this.signature) {
            ++pos;
            if (!var.getInternalName().equals(internalName)) continue;
            return pos;
        }
        return -1;
    }

    public Set<String> getTableNames() {
        HashSet<String> tableNames = new HashSet<String>();
        for (ColumnInfo var : this.signature) {
            tableNames.add(var.getTabAlias());
        }
        return tableNames;
    }

    public List<String> getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnInfo var : this.signature) {
            columnNames.add(var.getInternalName());
        }
        return columnNames;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RowSchema) || obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RowSchema dest = (RowSchema)obj;
        if (this.signature == null && dest.getSignature() == null) {
            return true;
        }
        if (this.signature == null && dest.getSignature() != null || this.signature != null && dest.getSignature() == null) {
            return false;
        }
        if (this.signature.size() != dest.getSignature().size()) {
            return false;
        }
        Iterator<ColumnInfo> origIt = this.signature.iterator();
        Iterator<ColumnInfo> destIt = dest.getSignature().iterator();
        while (origIt.hasNext()) {
            ColumnInfo origColumn = origIt.next();
            ColumnInfo destColumn = destIt.next();
            if (origColumn == null && destColumn == null) continue;
            if (origColumn == null && destColumn != null || origColumn != null && destColumn == null) {
                return false;
            }
            if (origColumn.equals(destColumn)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (ColumnInfo col : this.signature) {
            if (sb.length() > 1) {
                sb.append(',');
            }
            sb.append(col.toString());
            sb.append('|');
            sb.append('{');
            sb.append(col.getTabAlias());
            sb.append('}');
            if (col.getAlias() == null) continue;
            sb.append(col.getAlias());
        }
        sb.append(')');
        return sb.toString();
    }
}

