/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.util.JavaDataModel;

public final class MatchTracker {
    private final boolean isPartitioned;
    private final MatchTracker partitionParent;
    private final long[] longMatchFlags;
    private final MatchTracker[] partitions;
    private boolean isFirstMatch;

    private MatchTracker(boolean isPartitioned, MatchTracker partitionParent, int count) {
        this.isPartitioned = isPartitioned;
        this.partitionParent = partitionParent;
        if (!isPartitioned) {
            int longMatchFlagsSize = (count + 64 - 1) / 64;
            this.longMatchFlags = new long[longMatchFlagsSize];
            this.partitions = null;
        } else {
            this.longMatchFlags = null;
            this.partitions = new MatchTracker[count];
        }
    }

    public static MatchTracker create(int logicalHashBucketCount) {
        return new MatchTracker(false, null, logicalHashBucketCount);
    }

    public static MatchTracker createPartitioned(int partitionCount) {
        return new MatchTracker(true, null, partitionCount);
    }

    public boolean getIsPartitioned() {
        return this.isPartitioned;
    }

    public void addPartition(int partitionId, int logicalHashBucketCount) {
        this.partitions[partitionId] = new MatchTracker(false, this, logicalHashBucketCount);
    }

    public void clearPartition(int partitionId) {
        this.partitions[partitionId] = null;
    }

    public MatchTracker getPartition(int partitionId) {
        return this.partitions[partitionId];
    }

    public boolean getIsFirstMatch() {
        return this.isFirstMatch;
    }

    public void trackMatch(int logicalSlotNum) {
        Preconditions.checkState(!this.isPartitioned);
        int longWordIndex = logicalSlotNum / 64;
        long longBitMask = 1L << logicalSlotNum % 64;
        if ((this.longMatchFlags[longWordIndex] & longBitMask) != 0L) {
            this.isFirstMatch = false;
        } else {
            int n = longWordIndex;
            this.longMatchFlags[n] = this.longMatchFlags[n] | longBitMask;
            this.isFirstMatch = true;
        }
        if (this.partitionParent != null) {
            this.partitionParent.isFirstMatch = this.isFirstMatch;
        }
    }

    public void trackPartitionMatch(int partitionId, int logicalSlotNum) {
        this.partitions[partitionId].trackMatch(logicalSlotNum);
    }

    public boolean wasMatched(int logicalSlotNum) {
        int longWordIndex = logicalSlotNum / 64;
        long longBitMask = 1L << logicalSlotNum % 64;
        return (this.longMatchFlags[longWordIndex] & longBitMask) != 0L;
    }

    public boolean wasPartitionMatched(int partitionId, int logicalSlotNum) {
        return this.partitions[partitionId].wasMatched(logicalSlotNum);
    }

    public static int calculateEstimatedMemorySize(int count) {
        int longMatchFlagsSize = (count + 64 - 1) / 64;
        int size = 0;
        JavaDataModel jdm = JavaDataModel.get();
        size = (int)((long)size + jdm.lengthForLongArrayOfSize(longMatchFlagsSize));
        size += jdm.primitive1();
        return size += 2 * jdm.object();
    }
}

