/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileList
implements AutoCloseable,
Iterator<String> {
    private static final Logger LOG = LoggerFactory.getLogger(FileList.class);
    private final Path backingFile;
    private String nextElement = null;
    private String lastReadElement = null;
    private HiveConf conf;
    private volatile boolean abortOperation = false;
    private volatile boolean retryMode;
    private BufferedReader backingFileReader;
    private volatile FSDataOutputStream backingFileWriter;

    public FileList(Path backingFile, HiveConf conf) {
        this.backingFile = backingFile;
        this.conf = conf;
        this.retryMode = false;
    }

    public void add(String entry) throws IOException {
        if (this.conf.getBoolVar(HiveConf.ConfVars.REPL_COPY_FILE_LIST_ITERATOR_RETRY)) {
            this.writeWithRetry(entry);
        } else {
            this.writeEntry(entry);
        }
    }

    private synchronized void writeEntry(String entry) throws IOException {
        if (this.backingFileWriter == null) {
            try {
                Retryable retryable = this.buildRetryable();
                retryable.executeCallable(() -> {
                    if (this.abortOperation) {
                        LOG.debug("Aborting write operation for entry {} to file {}.", (Object)entry, (Object)this.backingFile);
                        return null;
                    }
                    this.backingFileWriter = this.getWriterCreateMode();
                    return null;
                });
            }
            catch (Exception e) {
                this.abortOperation = true;
                throw new IOException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()));
            }
        }
        if (this.abortOperation) {
            LOG.debug("Aborting write operation for entry {} to file {}.", (Object)entry, (Object)this.backingFile);
            return;
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL) && this.runFileListTest()) {
            this.runTestSetup();
        }
        try {
            this.backingFileWriter.writeBytes(this.getEntryWithNewline(entry));
            LOG.info("Writing entry {} to file list backed by {}", (Object)entry, (Object)this.backingFile);
        }
        catch (IOException e) {
            this.abortOperation = true;
            LOG.error("Writing entry {} to file list {} failed.", new Object[]{entry, this.backingFile, e});
            throw e;
        }
    }

    private synchronized void writeWithRetry(String entry) throws IOException {
        Retryable retryable = this.buildRetryable();
        try {
            retryable.executeCallable(() -> {
                if (this.abortOperation) {
                    LOG.debug("Aborting write operation for entry {} to file {}.", (Object)entry, (Object)this.backingFile);
                    return null;
                }
                try {
                    if (this.backingFileWriter == null) {
                        this.backingFileWriter = this.initWriter();
                    }
                    if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL) && this.runFileListTest()) {
                        this.runTestSetup();
                    }
                    this.backingFileWriter.writeBytes(this.getEntryWithNewline(entry));
                    this.backingFileWriter.hflush();
                    LOG.info("Writing entry {} to file list backed by {}", (Object)entry, (Object)this.backingFile);
                }
                catch (IOException e) {
                    LOG.error("Writing entry {} to file list {} failed, attempting retry.", new Object[]{entry, this.backingFile, e});
                    this.retryMode = true;
                    this.close();
                    throw e;
                }
                return null;
            });
        }
        catch (Exception e) {
            this.abortOperation = true;
            throw new IOException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()));
        }
    }

    @VisibleForTesting
    boolean runFileListTest() {
        return false;
    }

    private void runTestSetup() throws IOException {
        throw new IOException("test");
    }

    Retryable buildRetryable() {
        return Retryable.builder().withHiveConf(this.conf).withRetryOnException(IOException.class).build();
    }

    private String getEntryWithNewline(String entry) {
        return new StringWriter().append(entry).append(System.lineSeparator()).toString();
    }

    FSDataOutputStream initWriter() throws IOException {
        if (this.shouldAppend()) {
            return this.getWriterAppendMode();
        }
        return this.getWriterCreateMode();
    }

    private boolean shouldAppend() throws IOException {
        return this.backingFile.getFileSystem((Configuration)this.conf).exists(this.backingFile) && this.retryMode;
    }

    FSDataOutputStream getWriterCreateMode() throws IOException {
        try {
            return this.backingFile.getFileSystem((Configuration)this.conf).create(this.backingFile);
        }
        catch (IOException e) {
            LOG.error("Error creating file {}", (Object)this.backingFile, (Object)e);
            throw e;
        }
    }

    FSDataOutputStream getWriterAppendMode() throws IOException {
        try {
            return this.backingFile.getFileSystem((Configuration)this.conf).append(this.backingFile);
        }
        catch (IOException e) {
            LOG.error("Error opening file {} in append mode", (Object)this.backingFile, (Object)e);
            throw e;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextElement != null && !this.nextElement.equals(this.lastReadElement)) {
            return true;
        }
        try {
            do {
                this.nextElement = this.readNextLine();
                if (this.nextElement == null || this.nextElement.equals(this.lastReadElement)) continue;
                return true;
            } while (this.nextElement != null);
            return false;
        }
        catch (IOException e) {
            this.nextElement = null;
            this.lastReadElement = null;
            this.backingFileReader = null;
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String next() {
        if ((this.nextElement == null || this.nextElement.equals(this.lastReadElement)) && !this.hasNext()) {
            throw new NoSuchElementException("No more element in the list backed by " + this.backingFile);
        }
        this.lastReadElement = this.nextElement;
        this.nextElement = null;
        return this.lastReadElement;
    }

    private String readNextLine() throws IOException {
        try {
            if (this.backingFileReader == null) {
                FileSystem fs = this.backingFile.getFileSystem((Configuration)this.conf);
                if (!fs.exists(this.backingFile)) {
                    return null;
                }
                this.backingFileReader = new BufferedReader(new InputStreamReader((InputStream)fs.open(this.backingFile)));
            }
            String nextElement = this.backingFileReader.readLine();
            return nextElement;
        }
        catch (IOException e) {
            LOG.error("Exception while reading file {}.", (Object)this.backingFile, (Object)e);
            this.close();
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.backingFileReader != null) {
                this.backingFileReader.close();
            }
            if (this.backingFileWriter != null) {
                this.backingFileWriter.close();
            }
            LOG.info("Completed close for File List backed by:{}", (Object)this.backingFile);
        }
        finally {
            this.backingFileReader = null;
            this.backingFileWriter = null;
        }
    }
}

