/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.schq;

import org.apache.hadoop.hive.metastore.api.ScheduledQueryMaintenanceRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryMaintenanceRequestType;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.scheduled.ScheduledQueryExecutionService;
import org.apache.hadoop.hive.ql.scheduled.ScheduledQueryMaintenanceWork;
import org.apache.thrift.TException;

public class ScheduledQueryMaintenanceTask
extends Task<ScheduledQueryMaintenanceWork> {
    private static final long serialVersionUID = 1L;

    @Override
    public String getName() {
        return "SCHEDULED QUERY MAINTENANCE TASK";
    }

    @Override
    public int execute() {
        ScheduledQueryMaintenanceRequest request = this.buildScheduledQueryRequest();
        try {
            Hive.get().getMSC().scheduledQueryMaintenance(request);
            if (((ScheduledQueryMaintenanceWork)this.work).getScheduledQuery().isSetNextExecution() || request.getType() == ScheduledQueryMaintenanceRequestType.CREATE) {
                ScheduledQueryExecutionService.forceScheduleCheck();
            }
        }
        catch (HiveException | TException e) {
            this.setException(e);
            LOG.error("Failed", (Throwable)e);
            return 1;
        }
        return 0;
    }

    private ScheduledQueryMaintenanceRequest buildScheduledQueryRequest() {
        ScheduledQueryMaintenanceRequest req = new ScheduledQueryMaintenanceRequest();
        req.setType(((ScheduledQueryMaintenanceWork)this.work).getType());
        req.setScheduledQuery(((ScheduledQueryMaintenanceWork)this.work).getScheduledQuery());
        return req;
    }

    @Override
    public StageType getType() {
        return StageType.SCHEDULED_QUERY_MAINT;
    }
}

