/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.KillQuery;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.wm.WmContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.TezException;

public interface TezSession {
    public void open() throws IOException, LoginException, URISyntaxException, TezException;

    public void open(boolean var1) throws IOException, LoginException, URISyntaxException, TezException;

    public void open(HiveResources var1) throws LoginException, IOException, URISyntaxException, TezException;

    public void open(String[] var1) throws IOException, LoginException, URISyntaxException, TezException;

    public void beginOpen(String[] var1, SessionState.LogHelper var2) throws IOException, LoginException, URISyntaxException, TezException;

    public void endOpen() throws InterruptedException, CancellationException;

    public boolean reconnect(String var1, long var2) throws IOException, LoginException, URISyntaxException, TezException;

    public TezSession reopen() throws Exception;

    public void destroy() throws Exception;

    public void close(boolean var1) throws Exception;

    public void returnToSessionManager() throws Exception;

    public void ensureLocalResources(Configuration var1, String[] var2) throws IOException, LoginException, URISyntaxException, TezException;

    public HiveResources extractHiveResources();

    public Path replaceHiveResources(HiveResources var1, boolean var2);

    public List<LocalResource> getLocalizedResources();

    public LocalResource getAppJarLr();

    public HiveConf getConf();

    public TezClient getTezClient();

    public boolean isOpen();

    public boolean isOpening();

    public boolean getDoAsEnabled();

    public String getSessionId();

    public String getUser();

    public WmContext getWmContext();

    public void setWmContext(WmContext var1);

    public void setQueueName(String var1);

    public String getQueueName();

    public void setDefault();

    public boolean isDefault();

    public boolean getLegacyLlapMode();

    public void setLegacyLlapMode(boolean var1);

    public void unsetOwnerThread();

    public void setOwnerThread();

    public void setKillQuery(KillQuery var1);

    public boolean killQuery(String var1) throws HiveException;

    public static final class HiveResources {
        public final Path dagResourcesDir;
        public final Map<String, LocalResource> additionalFilesNotFromConf = new HashMap<String, LocalResource>();
        public final Set<LocalResource> localizedResources = new HashSet<LocalResource>();

        public HiveResources(Path dagResourcesDir) {
            this.dagResourcesDir = dagResourcesDir;
        }

        public String toString() {
            return this.dagResourcesDir + "; " + this.additionalFilesNotFromConf.size() + " additional files, " + this.localizedResources.size() + " localized resources";
        }
    }
}

