/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.TezSession;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.UserPoolMapping;
import org.apache.hadoop.hive.ql.exec.tez.WmTezSession;
import org.apache.hadoop.hive.ql.exec.tez.WorkloadManager;
import org.apache.hadoop.hive.ql.wm.WmContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkloadManagerFederation {
    private static final Logger LOG = LoggerFactory.getLogger(WorkloadManagerFederation.class);

    public static TezSession getSession(TezSession session, HiveConf conf, UserPoolMapping.MappingInput input, boolean isUnmanagedLlapMode, WmContext wmContext) throws Exception {
        HashSet<String> desiredCounters = new HashSet<String>();
        WorkloadManager wm = WorkloadManager.getInstance();
        if (wm == null) {
            LOG.debug("Using unmanaged session - WM is not initialized");
            return WorkloadManagerFederation.getUnmanagedSession(session, conf, desiredCounters, isUnmanagedLlapMode, wmContext);
        }
        if (!wm.isManaged(input)) {
            LOG.info("Using unmanaged session - no mapping for " + input);
            return WorkloadManagerFederation.getUnmanagedSession(session, conf, desiredCounters, isUnmanagedLlapMode, wmContext);
        }
        try {
            LOG.info("Getting a WM session for " + input);
            WmTezSession result = wm.getSession(session, input, conf, wmContext);
            result.setWmContext(wmContext);
            wm.updateTriggers(result);
            return result;
        }
        catch (WorkloadManager.NoPoolMappingException ex) {
            LOG.info("NoPoolMappingException thrown. Getting an un-managed session");
            return WorkloadManagerFederation.getUnmanagedSession(session, conf, desiredCounters, isUnmanagedLlapMode, wmContext);
        }
    }

    private static TezSession getUnmanagedSession(TezSession session, HiveConf conf, Set<String> desiredCounters, boolean isWorkLlapNode, WmContext wmContext) throws Exception {
        TezSessionPoolManager pm = TezSessionPoolManager.getInstance();
        session = pm.getSession(session, conf, false, isWorkLlapNode);
        desiredCounters.addAll(pm.getTriggerCounterNames());
        wmContext.setSubscribedCounters(desiredCounters);
        session.setWmContext(wmContext);
        return session;
    }
}

