/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.OverflowUtils;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class DoubleColModuloLongColumnChecked
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum1;
    private final int colNum2;

    public DoubleColModuloLongColumnChecked(int colNum1, int colNum2, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public DoubleColModuloLongColumnChecked() {
        this.colNum1 = -1;
        this.colNum2 = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DoubleColumnVector inputColVector1 = (DoubleColumnVector)batch.cols[this.colNum1];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum2];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        double[] vector1 = inputColVector1.vector;
        long[] vector2 = inputColVector2.vector;
        double[] outputVector = outputColVector.vector;
        NullUtil.propagateNullsColCol(inputColVector1, inputColVector2, outputColVector, sel, n, batch.selectedInUse);
        boolean hasDivBy0 = false;
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            long denom = vector2[0];
            hasDivBy0 = hasDivBy0 || denom == 0L;
            outputVector[0] = vector1[0] % (double)denom;
        } else if (inputColVector1.isRepeating) {
            double vector1Value = vector1[0];
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    long denom = vector2[i];
                    hasDivBy0 = hasDivBy0 || denom == 0L;
                    outputVector[i] = vector1Value % (double)denom;
                }
            } else {
                int i;
                for (i = 0; i != n; ++i) {
                    outputVector[i] = vector1Value % (double)vector2[i];
                }
                for (i = 0; i != n; ++i) {
                    hasDivBy0 = hasDivBy0 || vector2[i] == 0L;
                }
            }
        } else if (inputColVector2.isRepeating) {
            long vector2Value = vector2[0];
            if (vector2Value == 0L) {
                outputColVector.noNulls = false;
                outputColVector.isRepeating = true;
                outputColVector.isNull[0] = true;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1[i] % (double)vector2Value;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] % (double)vector2Value;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                long denom = vector2[i];
                hasDivBy0 = hasDivBy0 || denom == 0L;
                outputVector[i] = vector1[i] % (double)denom;
            }
        } else {
            int i;
            for (i = 0; i != n; ++i) {
                outputVector[i] = vector1[i] % (double)vector2[i];
            }
            for (i = 0; i != n; ++i) {
                hasDivBy0 = hasDivBy0 || vector2[i] == 0L;
            }
        }
        OverflowUtils.accountForOverflowDouble(this.getOutputTypeInfo(), outputColVector, batch.selectedInUse, sel, n);
        if (!hasDivBy0) {
            NullUtil.setNullDataEntriesDouble(outputColVector, batch.selectedInUse, sel, n);
        } else {
            NullUtil.setNullAndDivBy0DataEntriesDouble(outputColVector, batch.selectedInUse, sel, n, inputColVector2);
        }
    }

    @Override
    public boolean supportsCheckedExecution() {
        return true;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("double"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

