/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.filesink;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.LlapOutputFormatService;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.arrow.ArrowWrapperWritable;
import org.apache.hadoop.hive.ql.io.arrow.Serializer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorFileSinkDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.RecordWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorFileSinkArrowOperator
extends TerminalOperator<FileSinkDesc>
implements Serializable,
VectorizationOperator {
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    private VectorFileSinkDesc vectorDesc;
    public static final Logger LOG = LoggerFactory.getLogger((String)VectorFileSinkArrowOperator.class.getName());
    private transient Serializer converter;
    private transient RecordWriter recordWriter;
    private transient boolean wroteData;
    private transient String attemptId;

    public VectorFileSinkArrowOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) {
        this(ctx);
        this.conf = (FileSinkDesc)conf;
        this.vContext = vContext;
        this.vectorDesc = (VectorFileSinkDesc)vectorDesc;
    }

    @VisibleForTesting
    public VectorFileSinkArrowOperator() {
    }

    public VectorFileSinkArrowOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.attemptId = hconf.get("llap.of.id");
        try {
            ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
            ArrayList<String> fieldNames = new ArrayList<String>();
            StructObjectInspector schema = (StructObjectInspector)this.inputObjInspectors[0];
            for (int i = 0; i < schema.getAllStructFieldRefs().size(); ++i) {
                StructField structField = schema.getAllStructFieldRefs().get(i);
                fieldNames.add(structField.getFieldName());
                TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(structField.getFieldObjectInspector());
                typeInfos.add(typeInfo);
            }
            this.converter = new Serializer(hconf, this.attemptId, typeInfos, fieldNames);
        }
        catch (Exception e) {
            LOG.error("Unable to initialize VectorFileSinkArrowOperator");
            throw new RuntimeException(e);
        }
    }

    @Override
    public void process(Object data, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)data;
        try {
            if (this.recordWriter == null) {
                this.recordWriter = LlapOutputFormatService.get().getWriter(this.attemptId);
            }
            ArrowWrapperWritable writable = this.converter.serializeBatch(batch, true);
            this.recordWriter.write(null, (Object)writable);
            this.wroteData = true;
        }
        catch (Exception e) {
            LOG.error("Failed to convert VectorizedRowBatch to Arrow batch");
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        try {
            if (!this.wroteData) {
                ArrowWrapperWritable writable = this.converter.emptyBatch();
                if (this.recordWriter == null) {
                    this.recordWriter = LlapOutputFormatService.get().getWriter(this.attemptId);
                }
                this.recordWriter.write(null, (Object)writable);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to write Arrow stream schema");
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.recordWriter.close(null);
            }
            catch (Exception e) {
                LOG.error("Failed to close Arrow stream");
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }

    @Override
    public OperatorType getType() {
        return OperatorType.FILESINK;
    }
}

