/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashKeyRef;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashSetStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinFastBytesHashSet
extends VectorMapJoinFastBytesHashTable
implements VectorMapJoinBytesHashSet {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastBytesHashSet.class);
    private VectorMapJoinFastBytesHashSetStore hashSetStore;

    @Override
    public VectorMapJoinHashSetResult createHashSetResult() {
        return new VectorMapJoinFastBytesHashSetStore.HashSetResult();
    }

    @Override
    public void add(byte[] keyBytes, int keyStart, int keyLength, BytesWritable currentValue) {
        boolean isNewKey;
        if (this.checkResize()) {
            this.expandAndRehash();
        }
        long hashCode = HashCodeUtil.murmurHash(keyBytes, keyStart, keyLength);
        int intHashCode = (int)hashCode;
        int slot = intHashCode & this.logicalHashBucketMask;
        long probeSlot = slot;
        int i = 0;
        long partialHashCode = VectorMapJoinFastBytesHashKeyRef.extractPartialHashCode(hashCode);
        while (true) {
            long refWord;
            if ((refWord = this.slots[slot]) == 0L) {
                isNewKey = true;
                break;
            }
            if (VectorMapJoinFastBytesHashKeyRef.getPartialHashCodeFromRefWord(refWord) == partialHashCode && VectorMapJoinFastBytesHashKeyRef.equalKey(refWord, keyBytes, keyStart, keyLength, this.writeBuffers, this.unsafeReadPos)) {
                isNewKey = false;
                break;
            }
            ++this.metricPutConflict;
            slot = (int)((probeSlot += (long)(++i)) & (long)this.logicalHashBucketMask);
        }
        if (this.largestNumberOfSteps < i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Probed " + i + " slots (the longest so far) to find space");
            }
            this.largestNumberOfSteps = i;
        }
        if (isNewKey) {
            this.slots[slot] = this.hashSetStore.add(partialHashCode, keyBytes, keyStart, keyLength);
            ++this.keysAssigned;
        }
    }

    @Override
    public JoinUtil.JoinResult contains(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashSetResult hashSetResult) {
        VectorMapJoinFastBytesHashSetStore.HashSetResult fastHashSetResult = (VectorMapJoinFastBytesHashSetStore.HashSetResult)hashSetResult;
        fastHashSetResult.forget();
        long hashCode = HashCodeUtil.murmurHash(keyBytes, keyStart, keyLength);
        this.doHashSetContains(keyBytes, keyStart, keyLength, hashCode, fastHashSetResult);
        return fastHashSetResult.joinResult();
    }

    protected final void doHashSetContains(byte[] keyBytes, int keyStart, int keyLength, long hashCode, VectorMapJoinFastBytesHashSetStore.HashSetResult fastHashSetResult) {
        int intHashCode = (int)hashCode;
        int slot = intHashCode & this.logicalHashBucketMask;
        long probeSlot = slot;
        int i = 0;
        long partialHashCode = VectorMapJoinFastBytesHashKeyRef.extractPartialHashCode(hashCode);
        long refWord;
        while ((refWord = this.slots[slot]) != 0L) {
            if (VectorMapJoinFastBytesHashKeyRef.getPartialHashCodeFromRefWord(refWord) == partialHashCode) {
                fastHashSetResult.setKey(this.hashSetStore, refWord);
                if (fastHashSetResult.equalKey(keyBytes, keyStart, keyLength)) {
                    fastHashSetResult.setContains();
                    return;
                }
            }
            probeSlot += (long)(++i);
            if (i > this.largestNumberOfSteps) {
                return;
            }
            slot = (int)(probeSlot & (long)this.logicalHashBucketMask);
        }
        return;
    }

    public VectorMapJoinFastBytesHashSet(boolean isFullOuter, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount) {
        super(isFullOuter, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount);
        this.hashSetStore = new VectorMapJoinFastBytesHashSetStore(writeBuffersSize);
        this.writeBuffers = this.hashSetStore.getWriteBuffers();
    }

    @Override
    public long getEstimatedMemorySize() {
        long size = super.getEstimatedMemorySize();
        return size += this.hashSetStore.getEstimatedMemorySize();
    }
}

