/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorDenseRank
extends VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorDenseRank.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    private int denseRank;

    public VectorPTFEvaluatorDenseRank(WindowFrameDef windowFrameDef, int outputColumnNum) {
        super(windowFrameDef, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        LongColumnVector longColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        longColVector.isRepeating = true;
        longColVector.isNull[0] = false;
        longColVector.vector[0] = this.denseRank;
    }

    @Override
    public void doLastBatchWork() {
        ++this.denseRank;
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.LONG;
    }

    @Override
    public void resetEvaluator() {
        this.denseRank = 1;
    }
}

