/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorStreamingDoubleSum
extends VectorPTFEvaluatorBase {
    protected boolean isNull;
    protected double sum;

    public VectorPTFEvaluatorStreamingDoubleSum(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState(!batch.selectedInUse);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DoubleColumnVector doubleColVector = (DoubleColumnVector)batch.cols[this.inputColumnNum];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        double[] outputVector = outputColVector.vector;
        if (doubleColVector.isRepeating) {
            if (doubleColVector.noNulls || !doubleColVector.isNull[0]) {
                this.isNull = false;
                double repeatedValue = doubleColVector.vector[0];
                for (int i = 0; i < size; ++i) {
                    this.sum += repeatedValue;
                    outputVector[i] = this.sum;
                }
            } else {
                if (this.isNull) {
                    outputColVector.isNull[0] = true;
                    outputColVector.noNulls = false;
                } else {
                    outputVector[0] = this.sum;
                }
                outputColVector.isRepeating = true;
            }
        } else if (doubleColVector.noNulls) {
            this.isNull = false;
            double[] vector = doubleColVector.vector;
            for (int i = 0; i < size; ++i) {
                this.sum += vector[i];
                outputVector[i] = this.sum;
            }
        } else {
            boolean[] batchIsNull = doubleColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (this.isNull) {
                    outputColVector.isNull[i] = true;
                    outputColVector.noNulls = false;
                } else {
                    outputVector[i] = this.sum;
                }
                if (++i < size) continue;
                return;
            }
            this.isNull = false;
            double[] vector = doubleColVector.vector;
            this.sum += vector[i];
            outputVector[i++] = this.sum;
            while (i < size) {
                if (!batchIsNull[i]) {
                    this.sum += vector[i];
                    outputVector[i] = this.sum;
                } else {
                    outputVector[i] = this.sum;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DOUBLE;
    }

    @Override
    public void resetEvaluator() {
        this.isNull = true;
        this.sum = 0.0;
    }
}

