/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.udf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class VectorUDFArgDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isConstant;
    private int columnNum;
    private transient GenericUDF.DeferredJavaObject constObjVal;
    private ExprNodeConstantDesc constExpr;

    public void setConstant(ExprNodeConstantDesc expr) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
        this.isConstant = true;
        if (expr != null && expr.getTypeInfo().getCategory() == ObjectInspector.Category.PRIMITIVE && (primitiveCategory = ((PrimitiveTypeInfo)expr.getTypeInfo()).getPrimitiveCategory()) == PrimitiveObjectInspector.PrimitiveCategory.VOID) {
            expr = null;
        }
        this.constExpr = expr;
    }

    public void prepareConstant() {
        Object writableValue;
        if (this.constExpr != null) {
            List<Object> constantValue = this.constExpr.getValue();
            TypeInfo typeInfo = this.constExpr.getTypeInfo();
            ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(typeInfo);
            ObjectInspector.Category category = typeInfo.getCategory();
            switch (category) {
                case PRIMITIVE: {
                    PrimitiveObjectInspector.PrimitiveCategory pc = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
                    AbstractPrimitiveJavaObjectInspector primitiveJavaObjectInspector = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(pc);
                    writableValue = primitiveJavaObjectInspector.getPrimitiveWritableObject(constantValue);
                    break;
                }
                case STRUCT: {
                    if (constantValue.getClass().isArray()) {
                        constantValue = Arrays.asList((Object[])constantValue);
                    }
                    StructObjectInspector structObjectInspector = (StructObjectInspector)objectInspector;
                    List<? extends StructField> fields = structObjectInspector.getAllStructFieldRefs();
                    ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
                    ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fields.size());
                    for (StructField structField : fields) {
                        fieldNames.add(structField.getFieldName());
                        fieldObjectInspectors.add(ObjectInspectorUtils.getStandardObjectInspector(structField.getFieldObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
                    }
                    StandardConstantStructObjectInspector constantStructObjectInspector = ObjectInspectorFactory.getStandardConstantStructObjectInspector(fieldNames, fieldObjectInspectors, constantValue);
                    writableValue = constantStructObjectInspector.getWritableConstantValue();
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected category " + (Object)((Object)category));
                }
            }
        } else {
            writableValue = null;
        }
        this.constObjVal = new GenericUDF.DeferredJavaObject(writableValue);
    }

    public void setVariable(int i) {
        this.columnNum = i;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public boolean isVariable() {
        return !this.isConstant;
    }

    public int getColumn() {
        return this.columnNum;
    }

    public GenericUDF.DeferredObject getDeferredJavaObject(int row, VectorizedRowBatch b, int argPosition, VectorExpressionWriter[] writers) {
        if (this.isConstant()) {
            return this.constObjVal;
        }
        ColumnVector cv = b.cols[this.columnNum];
        try {
            Object o = writers[argPosition].writeValue(cv, row);
            return new GenericUDF.DeferredJavaObject(o);
        }
        catch (HiveException e) {
            throw new RuntimeException("Unable to get Java object from VectorizedRowBatch", e);
        }
    }

    public boolean getIsConstant() {
        return this.isConstant;
    }

    public void setIsConstant(boolean isConstant) {
        this.isConstant = isConstant;
    }

    public int getColumnNum() {
        return this.columnNum;
    }

    public void setColumnNum(int columnNum) {
        this.columnNum = columnNum;
    }

    public ExprNodeConstantDesc getConstExpr() {
        return this.constExpr;
    }

    public void setConstExpr(ExprNodeConstantDesc constExpr) {
        this.constExpr = constExpr;
    }
}

