/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public interface AcidInputFormat<KEY extends WritableComparable, VALUE>
extends InputFormat<KEY, VALUE>,
InputFormatChecker {
    public RowReader<VALUE> getReader(InputSplit var1, Options var2) throws IOException;

    public RawReader<VALUE> getRawReader(Configuration var1, boolean var2, int var3, ValidWriteIdList var4, Path var5, Path[] var6, Map<String, String> var7) throws IOException;

    public static interface AcidRecordReader<K, V>
    extends RecordReader<K, V> {
        public RecordIdentifier getRecordIdentifier();
    }

    public static interface RawReader<V>
    extends RecordReader<RecordIdentifier, V> {
        public ObjectInspector getObjectInspector();

        public boolean isDelete(V var1);
    }

    public static interface RowReader<V>
    extends RecordReader<RecordIdentifier, V> {
        public ObjectInspector getObjectInspector();
    }

    public static class Options {
        private final Configuration conf;
        private Reporter reporter;

        public Options(Configuration conf) {
            this.conf = conf;
        }

        public Options reporter(Reporter reporter) {
            this.reporter = reporter;
            return this;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public Reporter getReporter() {
            return this.reporter;
        }
    }

    public static final class DeltaFileMetaData
    implements Writable {
        private static final int HAS_LONG_FILEID_FLAG = 1;
        private static final int HAS_ATTEMPTID_FLAG = 2;
        private static final int HAS_STMTID_FLAG = 4;
        private long modTime;
        private long length;
        private Integer attemptId;
        private Long fileId;
        private Integer stmtId;
        private int bucketId;

        public DeltaFileMetaData() {
        }

        public DeltaFileMetaData(HadoopShims.HdfsFileStatusWithId fileStatus, Integer stmtId, int bucketId) {
            this.modTime = fileStatus.getFileStatus().getModificationTime();
            this.length = fileStatus.getFileStatus().getLen();
            String attempt = AcidUtils.parseAttemptId(fileStatus.getFileStatus().getPath());
            this.attemptId = StringUtils.isEmpty(attempt) ? null : Integer.valueOf(Integer.parseInt(attempt));
            this.fileId = fileStatus.getFileId();
            this.stmtId = stmtId;
            this.bucketId = bucketId;
        }

        public DeltaFileMetaData(long modTime, long length, @Nullable Integer attemptId, @Nullable Long fileId, @Nullable Integer stmtId, int bucketId) {
            this.modTime = modTime;
            this.length = length;
            this.attemptId = attemptId;
            this.fileId = fileId;
            this.stmtId = stmtId;
            this.bucketId = bucketId;
        }

        public Integer getStmtId() {
            return this.stmtId;
        }

        public long getModTime() {
            return this.modTime;
        }

        public long getLength() {
            return this.length;
        }

        public Integer getAttemptId() {
            return this.attemptId;
        }

        public Long getFileId() {
            return this.fileId;
        }

        public int getBucketId() {
            return this.bucketId;
        }

        public void write(DataOutput out) throws IOException {
            int flags = (this.fileId != null ? 1 : 0) | (this.attemptId != null ? 2 : 0) | (this.stmtId != null ? 4 : 0);
            out.writeByte(flags);
            out.writeLong(this.modTime);
            out.writeLong(this.length);
            if (this.attemptId != null) {
                out.writeInt(this.attemptId);
            }
            if (this.fileId != null) {
                out.writeLong(this.fileId);
            }
            if (this.stmtId != null) {
                out.writeInt(this.stmtId);
            }
        }

        public void readFields(DataInput in) throws IOException {
            byte flags = in.readByte();
            boolean hasLongFileId = (1 & flags) != 0;
            boolean hasAttemptId = (2 & flags) != 0;
            boolean hasStmtId = (4 & flags) != 0;
            this.modTime = in.readLong();
            this.length = in.readLong();
            if (hasAttemptId) {
                this.attemptId = in.readInt();
            }
            if (hasLongFileId) {
                this.fileId = in.readLong();
            }
            if (hasStmtId) {
                this.stmtId = in.readInt();
            }
        }

        public Object getFileId(Path deltaFile, int bucketId, Configuration conf) {
            boolean forceSynthetic;
            boolean bl = forceSynthetic = !HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_IO_USE_FILEID_PATH);
            if (this.fileId != null && !forceSynthetic) {
                return this.fileId;
            }
            return new SyntheticFileId(deltaFile, this.length, this.modTime);
        }

        public Path getPath(Path deltaDirectory, int bucketId) {
            return AcidUtils.createBucketFile(deltaDirectory, bucketId, this.attemptId == null ? null : String.valueOf(this.attemptId));
        }
    }

    public static final class DeltaMetaData
    implements Writable {
        private long minWriteId;
        private long maxWriteId;
        private List<Integer> stmtIds;
        private long visibilityTxnId;
        private List<DeltaFileMetaData> deltaFiles;

        public DeltaMetaData() {
            this(0L, 0L, new ArrayList<Integer>(), 0L, new ArrayList<DeltaFileMetaData>());
        }

        public DeltaMetaData(long minWriteId, long maxWriteId, List<Integer> stmtIds, long visibilityTxnId, List<DeltaFileMetaData> deltaFiles) {
            this.minWriteId = minWriteId;
            this.maxWriteId = maxWriteId;
            if (stmtIds == null) {
                throw new IllegalArgumentException("stmtIds == null");
            }
            this.stmtIds = stmtIds;
            this.visibilityTxnId = visibilityTxnId;
            this.deltaFiles = ObjectUtils.defaultIfNull(deltaFiles, new ArrayList());
        }

        public long getMinWriteId() {
            return this.minWriteId;
        }

        public long getMaxWriteId() {
            return this.maxWriteId;
        }

        public List<Integer> getStmtIds() {
            return this.stmtIds;
        }

        public long getVisibilityTxnId() {
            return this.visibilityTxnId;
        }

        public List<DeltaFileMetaData> getDeltaFiles() {
            return this.deltaFiles;
        }

        public List<DeltaFileMetaData> getDeltaFilesForStmtId(Integer stmtId) {
            if (this.stmtIds.size() <= 1 || stmtId == null) {
                return this.deltaFiles;
            }
            return this.deltaFiles.stream().filter(df -> stmtId.equals(df.getStmtId())).collect(Collectors.toList());
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.minWriteId);
            out.writeLong(this.maxWriteId);
            out.writeInt(this.stmtIds.size());
            for (Integer id : this.stmtIds) {
                out.writeInt(id);
            }
            out.writeLong(this.visibilityTxnId);
            out.writeInt(this.deltaFiles.size());
            for (DeltaFileMetaData fileMeta : this.deltaFiles) {
                fileMeta.write(out);
            }
        }

        public void readFields(DataInput in) throws IOException {
            this.minWriteId = in.readLong();
            this.maxWriteId = in.readLong();
            this.stmtIds.clear();
            int numStatements = in.readInt();
            for (int i = 0; i < numStatements; ++i) {
                this.stmtIds.add(in.readInt());
            }
            this.visibilityTxnId = in.readLong();
            this.deltaFiles.clear();
            int numFiles = in.readInt();
            for (int i = 0; i < numFiles; ++i) {
                DeltaFileMetaData file = new DeltaFileMetaData();
                file.readFields(in);
                this.deltaFiles.add(file);
            }
        }

        private String getName() {
            assert (this.stmtIds.isEmpty()) : "use getName(int)";
            return AcidUtils.addVisibilitySuffix(AcidUtils.deleteDeltaSubdir(this.minWriteId, this.maxWriteId), this.visibilityTxnId);
        }

        private String getName(int stmtId) {
            assert (!this.stmtIds.isEmpty()) : "use getName()";
            return AcidUtils.addVisibilitySuffix(AcidUtils.deleteDeltaSubdir(this.minWriteId, this.maxWriteId, stmtId), this.visibilityTxnId);
        }

        public List<Pair<Path, Integer>> getPaths(Path root) {
            if (this.stmtIds.isEmpty()) {
                return Collections.singletonList(new ImmutablePair<Path, Object>(new Path(root, this.getName()), null));
            }
            return this.getStmtIds().stream().map(stmtId -> new ImmutablePair<Path, Integer>(new Path(root, this.getName((int)stmtId)), (Integer)stmtId)).collect(Collectors.toList());
        }

        public String toString() {
            return "Delta(?," + this.minWriteId + "," + this.maxWriteId + "," + this.stmtIds + "," + this.visibilityTxnId + ")";
        }
    }
}

