/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveContextAwareRecordReader;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineHiveRecordReader<K extends WritableComparable, V extends Writable>
extends HiveContextAwareRecordReader<K, V> {
    private Logger LOG = LoggerFactory.getLogger(CombineHiveRecordReader.class);
    private Map<Path, PartitionDesc> pathToPartInfo;

    public CombineHiveRecordReader(InputSplit split, Configuration conf, Reporter reporter, Integer partition, RecordReader preReader) throws IOException {
        super((JobConf)conf);
        CombineHiveInputFormat.CombineHiveInputSplit hsplit = split instanceof CombineHiveInputFormat.CombineHiveInputSplit ? (CombineHiveInputFormat.CombineHiveInputSplit)split : new CombineHiveInputFormat.CombineHiveInputSplit(this.jobConf, (CombineFileSplit)split);
        String inputFormatClassName = hsplit.inputFormatClassName();
        Class inputFormatClass = null;
        try {
            inputFormatClass = JavaUtils.loadClass(inputFormatClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("CombineHiveRecordReader: class not found " + inputFormatClassName);
        }
        InputFormat<WritableComparable, Writable> inputFormat = HiveInputFormat.getInputFormatFromCache(inputFormatClass, this.jobConf);
        if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_IO_ENABLED, LlapProxy.isDaemon())) {
            try {
                if (this.pathToPartInfo == null) {
                    MapWork mrwork = (MapWork)Utilities.getMergeWork((Configuration)this.jobConf);
                    if (mrwork == null) {
                        mrwork = Utilities.getMapWork((Configuration)this.jobConf);
                    }
                    this.pathToPartInfo = mrwork.getPathToPartitionInfo();
                }
                PartitionDesc part = this.extractSinglePartSpec(hsplit);
                inputFormat = HiveInputFormat.wrapForLlap(inputFormat, (Configuration)this.jobConf, part);
            }
            catch (HiveException e) {
                throw new IOException(e);
            }
        }
        FileSplit fsplit = new FileSplit(hsplit.getPaths()[partition], hsplit.getStartOffsets()[partition], hsplit.getLengths()[partition], hsplit.getLocations());
        this.setRecordReader(inputFormat.getRecordReader((InputSplit)fsplit, this.jobConf, reporter));
        this.initIOContext(fsplit, this.jobConf, inputFormatClass, this.recordReader);
        if (preReader != null && preReader instanceof CombineHiveRecordReader && ((CombineHiveRecordReader)preReader).getFooterBuffer() != null && partition != 0 && hsplit.getPaths()[partition - 1].equals((Object)hsplit.getPaths()[partition])) {
            this.setFooterBuffer(((CombineHiveRecordReader)preReader).getFooterBuffer());
        }
    }

    private PartitionDesc extractSinglePartSpec(CombineHiveInputFormat.CombineHiveInputSplit hsplit) throws IOException {
        PartitionDesc part = null;
        HashMap cache = new HashMap();
        for (Path path : hsplit.getPaths()) {
            PartitionDesc otherPart = HiveFileFormatUtils.getFromPathRecursively(this.pathToPartInfo, path, cache);
            this.LOG.debug("Found spec for {} {} from {}", new Object[]{path, otherPart, this.pathToPartInfo});
            if (part == null) {
                part = otherPart;
                continue;
            }
            if (otherPart == part) continue;
            this.LOG.warn("Multiple partitions found; not going to pass a part spec to LLAP IO: {" + part.getPartSpec() + "} and {" + otherPart.getPartSpec() + "}");
            return null;
        }
        return part;
    }

    @Override
    public void doClose() throws IOException {
        this.recordReader.close();
    }

    public K createKey() {
        return (K)((WritableComparable)this.recordReader.createKey());
    }

    public V createValue() {
        return (V)((Writable)this.recordReader.createValue());
    }

    public long getPos() throws IOException {
        return this.recordReader.getPos();
    }

    @Override
    public float getProgress() throws IOException {
        if (this.isSorted) {
            return super.getProgress();
        }
        return this.recordReader.getProgress();
    }

    @Override
    public boolean doNext(K key, V value) throws IOException {
        if (ExecMapper.getDone()) {
            return false;
        }
        return super.doNext(key, value);
    }
}

