/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.timestamp;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import jodd.time.JulianDate;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;

public class NanoTimeUtils {
    static final long NANOS_PER_HOUR = TimeUnit.HOURS.toNanos(1L);
    static final long NANOS_PER_MINUTE = TimeUnit.MINUTES.toNanos(1L);
    static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    static final long NANOS_PER_DAY = TimeUnit.DAYS.toNanos(1L);
    private static final ThreadLocal<Calendar> parquetGMTCalendar = new ThreadLocal();

    private static Calendar getGMTCalendar() {
        if (parquetGMTCalendar.get() == null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.setGregorianChange(new Date(Long.MIN_VALUE));
            parquetGMTCalendar.set(calendar);
        }
        parquetGMTCalendar.get().clear();
        return parquetGMTCalendar.get();
    }

    public static NanoTime getNanoTime(Timestamp ts, ZoneId sourceZone, boolean legacyConversion) {
        ts = TimestampTZUtil.convertTimestampToZone(ts, sourceZone, ZoneOffset.UTC, legacyConversion);
        Calendar calendar = NanoTimeUtils.getGMTCalendar();
        calendar.setTimeInMillis(ts.toEpochMilli());
        int year = calendar.get(1);
        if (calendar.get(0) == 0) {
            year = 1 - year;
        }
        JulianDate jDateTime = JulianDate.of(year, calendar.get(2) + 1, calendar.get(5), 0, 0, 0, 0);
        int days = jDateTime.getJulianDayNumber();
        long hour = calendar.get(11);
        long minute = calendar.get(12);
        long second = calendar.get(13);
        long nanos = ts.getNanos();
        long nanosOfDay = nanos + NANOS_PER_SECOND * second + NANOS_PER_MINUTE * minute + NANOS_PER_HOUR * hour;
        return new NanoTime(days, nanosOfDay);
    }

    public static Timestamp getTimestamp(NanoTime nt, ZoneId targetZone) {
        return NanoTimeUtils.getTimestamp(nt, targetZone, false);
    }

    public static Timestamp getTimestamp(NanoTime nt, ZoneId targetZone, boolean legacyConversion) {
        long nanosOfDay;
        int julianDay = nt.getJulianDay();
        long remainder = nanosOfDay = nt.getTimeOfDayNanos();
        julianDay = (int)((long)julianDay + remainder / NANOS_PER_DAY);
        if ((remainder %= NANOS_PER_DAY) < 0L) {
            remainder += NANOS_PER_DAY;
            --julianDay;
        }
        JulianDate jDateTime = JulianDate.of((double)julianDay);
        Calendar calendar = NanoTimeUtils.getGMTCalendar();
        calendar.set(1, jDateTime.toLocalDateTime().getYear());
        calendar.set(2, jDateTime.toLocalDateTime().getMonth().getValue() - 1);
        calendar.set(5, jDateTime.toLocalDateTime().getDayOfMonth());
        int hour = (int)(remainder / NANOS_PER_HOUR);
        int minutes = (int)((remainder %= NANOS_PER_HOUR) / NANOS_PER_MINUTE);
        int seconds = (int)((remainder %= NANOS_PER_MINUTE) / NANOS_PER_SECOND);
        long nanos = remainder % NANOS_PER_SECOND;
        calendar.set(11, hour);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        Timestamp ts = Timestamp.ofEpochMilli(calendar.getTimeInMillis(), (int)nanos);
        ts = TimestampTZUtil.convertTimestampToZone(ts, ZoneOffset.UTC, targetZone, legacyConversion);
        return ts;
    }
}

