/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log.syslog;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.log.syslog.SyslogParser;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class SyslogSerDe
extends AbstractSerDe {
    private static final String COLUMN_NAMES = "facility,severity,version,ts,hostname,app_name,proc_id,msg_id,structured_data,msg,unmatched";
    private static final String COLUMN_NAME_DELIMITER = String.valueOf(',');
    private static final String COLUMN_TYPES = "string:string:string:timestamp:string:string:string:string:map<string,string>:binary:binary";
    private ObjectInspector inspector;
    private SyslogParser syslogParser;
    private List<Object> EMPTY_ROW;

    @Override
    public void initialize(@Nullable Configuration configuration, Properties properties) throws SerDeException {
        List<String> columnNames = Arrays.asList(COLUMN_NAMES.split(COLUMN_NAME_DELIMITER));
        ArrayList<TypeInfo> columnTypes = TypeInfoUtils.getTypeInfosFromTypeString(COLUMN_TYPES);
        this.EMPTY_ROW = new ArrayList<Object>(columnNames.size());
        for (int i = 0; i < columnNames.size(); ++i) {
            this.EMPTY_ROW.add(null);
        }
        StructTypeInfo typeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(columnNames, columnTypes);
        this.inspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(typeInfo);
        this.syslogParser = new SyslogParser();
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    @Override
    public Writable serialize(Object o, ObjectInspector objectInspector) throws SerDeException {
        throw new SerDeException("Serialization is not supported yet");
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }

    @Override
    public Object deserialize(Writable writable) throws SerDeException {
        Text rowText = (Text)writable;
        if (rowText.getLength() == 0) {
            this.EMPTY_ROW.set(this.EMPTY_ROW.size() - 1, rowText.getBytes());
            return this.EMPTY_ROW;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(rowText.getBytes(), 0, rowText.getLength());
        this.syslogParser.setInputStream(bis);
        try {
            return this.syslogParser.readEvent();
        }
        catch (Exception e) {
            throw new SerDeException("Failed parsing line: " + rowText.toString(), e);
        }
    }

    @Override
    public ObjectInspector getObjectInspector() {
        return this.inspector;
    }
}

