/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class PartitionIterable
implements Iterable<Partition> {
    final Type currType;
    private Collection<Partition> ptnsProvided = null;
    private Hive db = null;
    private Table table = null;
    private Map<String, String> partialPartitionSpec = null;
    private List<String> partitionNames = null;
    private int batchSize;
    private boolean getColStats = false;

    @Override
    public Iterator<Partition> iterator() {
        return new Iterator<Partition>(){
            private boolean initialized = false;
            private Iterator<Partition> ptnsIterator = null;
            private Iterator<String> partitionNamesIter = null;
            private Iterator<Partition> batchIter = null;

            private void initialize() {
                if (!this.initialized) {
                    if (PartitionIterable.this.currType == Type.LIST_PROVIDED) {
                        this.ptnsIterator = PartitionIterable.this.ptnsProvided.iterator();
                    } else {
                        this.partitionNamesIter = PartitionIterable.this.partitionNames.iterator();
                    }
                    this.initialized = true;
                }
            }

            @Override
            public boolean hasNext() {
                this.initialize();
                if (PartitionIterable.this.currType == Type.LIST_PROVIDED) {
                    return this.ptnsIterator.hasNext();
                }
                return this.batchIter != null && this.batchIter.hasNext() || this.partitionNamesIter.hasNext();
            }

            @Override
            public Partition next() {
                this.initialize();
                if (PartitionIterable.this.currType == Type.LIST_PROVIDED) {
                    return this.ptnsIterator.next();
                }
                if (this.batchIter == null || !this.batchIter.hasNext()) {
                    this.getNextBatch();
                }
                return this.batchIter.next();
            }

            private void getNextBatch() {
                ArrayList<String> nameBatch = new ArrayList<String>();
                for (int batchCounter = 0; batchCounter < PartitionIterable.this.batchSize && this.partitionNamesIter.hasNext(); ++batchCounter) {
                    nameBatch.add(this.partitionNamesIter.next());
                }
                try {
                    this.batchIter = PartitionIterable.this.db.getPartitionsByNames(PartitionIterable.this.table, nameBatch, PartitionIterable.this.getColStats).iterator();
                }
                catch (HiveException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new IllegalStateException("PartitionIterable is a read-only iterable and remove() is unsupported");
            }
        };
    }

    public PartitionIterable(Collection<Partition> ptnsProvided) {
        this.currType = Type.LIST_PROVIDED;
        this.ptnsProvided = ptnsProvided;
    }

    public PartitionIterable(Hive db, Table table, Map<String, String> partialPartitionSpec, int batchSize) throws HiveException {
        this(db, table, partialPartitionSpec, batchSize, false);
    }

    public PartitionIterable(Hive db, Table table, Map<String, String> partialPartitionSpec, int batchSize, boolean getColStats) throws HiveException {
        this.currType = Type.LAZY_FETCH_PARTITIONS;
        this.db = db;
        this.table = table;
        this.partialPartitionSpec = partialPartitionSpec;
        this.batchSize = batchSize;
        this.getColStats = getColStats;
        this.partitionNames = this.partialPartitionSpec == null ? db.getPartitionNames(table.getDbName(), table.getTableName(), (short)-1) : db.getPartitionNames(table.getDbName(), table.getTableName(), partialPartitionSpec, (short)-1);
    }

    static enum Type {
        LIST_PROVIDED,
        LAZY_FETCH_PARTITIONS;

    }
}

