/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.events;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountRequest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.messaging.event.filters.DatabaseAndTableFilter;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.thrift.TException;

public class EventUtils {

    public static class NotificationEventIterator
    implements Iterator<NotificationEvent> {
        private NotificationFetcher nfetcher;
        private IMetaStoreClient.NotificationFilter filter;
        private int maxEvents;
        private Iterator<NotificationEvent> batchIter = null;
        private List<NotificationEvent> batch = null;
        private long pos;
        private long maxPos;
        private int eventCount;

        public NotificationEventIterator(NotificationFetcher nfetcher, long eventFrom, int maxEvents, String dbName, String tableName) throws IOException {
            this.init(nfetcher, eventFrom, maxEvents, new DatabaseAndTableFilter(dbName, tableName));
        }

        public NotificationEventIterator(NotificationFetcher nfetcher, long eventFrom, int maxEvents, IMetaStoreClient.NotificationFilter filter) throws IOException {
            this.init(nfetcher, eventFrom, maxEvents, filter);
        }

        private void init(NotificationFetcher nfetcher, long eventFrom, int maxEvents, IMetaStoreClient.NotificationFilter filter) throws IOException {
            this.nfetcher = nfetcher;
            this.filter = filter;
            this.pos = eventFrom;
            this.maxEvents = maxEvents < 1 ? Integer.MAX_VALUE : maxEvents;
            this.eventCount = 0;
            this.maxPos = nfetcher.getCurrentNotificationEventId();
        }

        private void fetchNextBatch() throws IOException {
            this.batch = this.nfetcher.getNextNotificationEvents(this.pos, this.filter);
            int batchSize = this.nfetcher.getBatchSize();
            while ((this.batch == null || this.batch.isEmpty()) && this.pos < this.maxPos) {
                this.pos += (long)batchSize;
                this.batch = this.nfetcher.getNextNotificationEvents(this.pos, this.filter);
            }
            if (this.batch == null) {
                this.batch = new ArrayList<NotificationEvent>();
            }
            this.batchIter = this.batch.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.eventCount >= this.maxEvents) {
                return false;
            }
            if (this.batchIter != null && this.batchIter.hasNext()) {
                return true;
            }
            try {
                this.fetchNextBatch();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return !this.batch.isEmpty();
        }

        @Override
        public NotificationEvent next() {
            ++this.eventCount;
            NotificationEvent ev = this.batchIter.next();
            this.pos = ev.getEventId();
            return ev;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported on NotificationEventIterator");
        }
    }

    public static class MSClientNotificationFetcher
    implements NotificationFetcher {
        private Hive hiveDb = null;
        private Integer batchSize = null;

        public MSClientNotificationFetcher(Hive hiveDb) {
            this.hiveDb = hiveDb;
        }

        @Override
        public int getBatchSize() throws IOException {
            if (this.batchSize == null) {
                try {
                    this.batchSize = Integer.parseInt(this.hiveDb.getMSC().getConfigValue(MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX.toString(), "50"));
                }
                catch (TException e) {
                    throw new IOException(e);
                }
            }
            return this.batchSize;
        }

        @Override
        public long getCurrentNotificationEventId() throws IOException {
            try {
                return this.hiveDb.getMSC().getCurrentNotificationEventId().getEventId();
            }
            catch (TException e) {
                throw new IOException(e);
            }
        }

        @Override
        public long getDbNotificationEventsCount(long fromEventId, String dbName, Long toEventId, int limit) throws IOException {
            try {
                if (limit <= 0) {
                    return 0L;
                }
                NotificationEventsCountRequest rqst = new NotificationEventsCountRequest(fromEventId, dbName);
                if (toEventId != null) {
                    rqst.setToEventId(toEventId);
                }
                rqst.setLimit(limit);
                return this.hiveDb.getMSC().getNotificationEventsCount(rqst).getEventsCount();
            }
            catch (TException e) {
                throw new IOException(e);
            }
        }

        @Override
        public List<NotificationEvent> getNextNotificationEvents(long pos, IMetaStoreClient.NotificationFilter filter) throws IOException {
            try {
                return this.hiveDb.getMSC().getNextNotification(pos, this.getBatchSize(), filter).getEvents();
            }
            catch (TException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    public static interface NotificationFetcher {
        public int getBatchSize() throws IOException;

        public long getCurrentNotificationEventId() throws IOException;

        public long getDbNotificationEventsCount(long var1, String var3, Long var4, int var5) throws IOException;

        public List<NotificationEvent> getNextNotificationEvents(long var1, IMetaStoreClient.NotificationFilter var3) throws IOException;
    }
}

