/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.base.Preconditions;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.PrunerOperatorFactory;
import org.apache.hadoop.hive.ql.optimizer.PrunerUtils;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

public class FixedBucketPruningOptimizer
extends Transform {
    private static final Log LOG = LogFactory.getLog((String)FixedBucketPruningOptimizer.class.getName());
    private final boolean compat;

    public FixedBucketPruningOptimizer(boolean compat) {
        this.compat = compat;
    }

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        FixedBucketPruningOptimizerCtxt opPartWalkerCtx = new FixedBucketPruningOptimizerCtxt(this.compat, pctx);
        PrunerUtils.walkOperatorTree(pctx, opPartWalkerCtx, new BucketBitsetGenerator(), new NoopWalker());
        return pctx;
    }

    public final class FixedBucketPruningOptimizerCtxt
    implements NodeProcessorCtx {
        public final ParseContext pctx;
        private final boolean compat;
        private int numBuckets;
        private PrunedPartitionList partitions;
        private List<String> bucketCols;
        private List<StructField> schema;

        public FixedBucketPruningOptimizerCtxt(boolean compat, ParseContext pctx) {
            this.compat = compat;
            this.pctx = pctx;
        }

        public void setSchema(ArrayList<StructField> fields) {
            this.schema = fields;
        }

        public List<StructField> getSchema() {
            return this.schema;
        }

        public void setBucketCols(List<String> bucketCols) {
            this.bucketCols = bucketCols;
        }

        public List<String> getBucketCols() {
            return this.bucketCols;
        }

        public void setPartitions(PrunedPartitionList partitions) {
            this.partitions = partitions;
        }

        public PrunedPartitionList getPartitions() {
            return this.partitions;
        }

        public int getNumBuckets() {
            return this.numBuckets;
        }

        public void setNumBuckets(int numBuckets) {
            this.numBuckets = numBuckets;
        }

        public boolean isCompat() {
            return this.compat;
        }
    }

    public static class BucketBitsetGenerator
    extends PrunerOperatorFactory.FilterPruner {
        @Override
        protected void generatePredicate(NodeProcessorCtx procCtx, FilterOperator fop, TableScanOperator top) throws SemanticException {
            ExprNodeGenericFuncDesc filter;
            PrunedPartitionList prunedPartList;
            FixedBucketPruningOptimizerCtxt ctxt = (FixedBucketPruningOptimizerCtxt)procCtx;
            Table tbl = ((TableScanDesc)top.getConf()).getTableMetadata();
            int numBuckets = tbl.getNumBuckets();
            if (numBuckets <= 0 || tbl.getBucketCols().size() != 1) {
                return;
            }
            if (tbl.isPartitioned() && (prunedPartList = PartitionPruner.prune(top, ctxt.pctx, ((TableScanDesc)top.getConf()).getAlias())) != null) {
                for (Partition p : prunedPartList.getPartitions()) {
                    if (numBuckets == p.getBucketCount()) continue;
                    return;
                }
            }
            if ((filter = ((TableScanDesc)top.getConf()).getFilterExpr()) == null) {
                return;
            }
            SearchArgument sarg = ConvertAstToSearchArg.create(ctxt.pctx.getConf(), filter);
            if (sarg == null) {
                return;
            }
            String bucketCol = tbl.getBucketCols().get(0);
            StructField bucketField = null;
            for (StructField fs : tbl.getFields()) {
                if (!fs.getFieldName().equals(bucketCol)) continue;
                bucketField = fs;
                break;
            }
            Preconditions.checkArgument(bucketField != null);
            ArrayList<Object> literals = new ArrayList<Object>();
            List<PredicateLeaf> leaves = sarg.getLeaves();
            HashSet<PredicateLeaf> bucketLeaves = new HashSet<PredicateLeaf>();
            for (PredicateLeaf l : leaves) {
                if (!bucketCol.equals(l.getColumnName())) continue;
                switch (l.getOperator()) {
                    case EQUALS: 
                    case IN: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                bucketLeaves.add(l);
            }
            if (bucketLeaves.size() == 0) {
                return;
            }
            ExpressionTree expr = sarg.getExpression();
            if (expr.getOperator() == ExpressionTree.Operator.LEAF) {
                PredicateLeaf l;
                l = leaves.get(expr.getLeaf());
                if (!this.addLiteral(literals, l)) {
                    return;
                }
            } else if (expr.getOperator() == ExpressionTree.Operator.AND) {
                boolean found = false;
                for (ExpressionTree subExpr : expr.getChildren()) {
                    PredicateLeaf l;
                    if (subExpr.getOperator() != ExpressionTree.Operator.LEAF || !bucketLeaves.contains(l = leaves.get(subExpr.getLeaf()))) continue;
                    if (!this.addLiteral(literals, l)) {
                        return;
                    }
                    found = true;
                }
                if (!found) {
                    return;
                }
            } else if (expr.getOperator() == ExpressionTree.Operator.OR) {
                for (ExpressionTree subExpr : expr.getChildren()) {
                    if (subExpr.getOperator() != ExpressionTree.Operator.LEAF) {
                        return;
                    }
                    PredicateLeaf l = leaves.get(subExpr.getLeaf());
                    if (bucketLeaves.contains(l)) {
                        if (this.addLiteral(literals, l)) continue;
                        return;
                    }
                    return;
                }
            } else if (expr.getOperator() == ExpressionTree.Operator.NOT) {
                return;
            }
            BitSet bs = new BitSet(numBuckets);
            bs.clear();
            PrimitiveObjectInspector bucketOI = (PrimitiveObjectInspector)bucketField.getFieldObjectInspector();
            AbstractPrimitiveWritableObjectInspector constOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(bucketOI.getPrimitiveCategory());
            int bucketingVersion = ((TableScanDesc)top.getConf()).getTableMetadata().getBucketingVersion();
            for (Object e : literals) {
                PrimitiveObjectInspector origOI = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(e.getClass());
                ObjectInspectorConverters.Converter conv = ObjectInspectorConverters.getConverter((ObjectInspector)origOI, (ObjectInspector)constOI);
                if (conv == null) {
                    return;
                }
                Object[] convCols = new Object[]{conv.convert(e)};
                int n = bucketingVersion == 2 ? ObjectInspectorUtils.getBucketNumber(convCols, new ObjectInspector[]{constOI}, numBuckets) : ObjectInspectorUtils.getBucketNumberOld(convCols, new ObjectInspector[]{constOI}, numBuckets);
                bs.set(n);
                if (bucketingVersion != 1 || !ctxt.isCompat()) continue;
                int h = ObjectInspectorUtils.getBucketHashCodeOld(convCols, new ObjectInspector[]{constOI});
                n = ObjectInspectorUtils.getBucketNumber(Math.abs(h), numBuckets);
                bs.set(n);
            }
            if (bs.cardinality() < numBuckets) {
                ((TableScanDesc)top.getConf()).setIncludedBuckets(bs);
                ((TableScanDesc)top.getConf()).setNumBuckets(numBuckets);
            }
        }

        private boolean addLiteral(List<Object> literals, PredicateLeaf leaf) {
            switch (leaf.getOperator()) {
                case EQUALS: {
                    return literals.add(this.convertLiteral(leaf.getLiteral()));
                }
                case IN: {
                    return literals.addAll(leaf.getLiteralList().stream().map(l -> this.convertLiteral(l)).collect(Collectors.toList()));
                }
            }
            return false;
        }

        private Object convertLiteral(Object o) {
            if (o instanceof Date) {
                Date sqlDate = (Date)o;
                return org.apache.hadoop.hive.common.type.Date.ofEpochDay(DateWritable.millisToDays(sqlDate.getTime()));
            }
            if (o instanceof Timestamp) {
                Timestamp sqlTimestamp = (Timestamp)o;
                return org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli(sqlTimestamp.getTime(), sqlTimestamp.getNanos());
            }
            return o;
        }
    }

    public class NoopWalker
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }
}

