/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveDefaultCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveOnTezCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveRelMdCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdCollation;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdColumnUniqueness;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdDistinctRowCount;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdDistribution;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdExpressionLineage;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdMemory;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdParallelism;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdPredicates;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdRowCount;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdSelectivity;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdSize;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdUniqueKeys;

public class HiveDefaultRelMetadataProvider {
    private static final JaninoRelMetadataProvider DEFAULT = JaninoRelMetadataProvider.of((RelMetadataProvider)ChainedRelMetadataProvider.of(ImmutableList.of(HiveRelMdDistinctRowCount.SOURCE, new HiveRelMdCost(HiveDefaultCostModel.getCostModel()).getMetadataProvider(), HiveRelMdSelectivity.SOURCE, HiveRelMdRowCount.SOURCE, HiveRelMdUniqueKeys.SOURCE, HiveRelMdColumnUniqueness.SOURCE, HiveRelMdExpressionLineage.SOURCE, HiveRelMdSize.SOURCE, HiveRelMdMemory.SOURCE, HiveRelMdDistribution.SOURCE, HiveRelMdCollation.SOURCE, HiveRelMdPredicates.SOURCE, new RelMetadataProvider[]{JaninoRelMetadataProvider.DEFAULT})));
    private final RelMetadataProvider metadataProvider;

    public HiveDefaultRelMetadataProvider(HiveConf hiveConf, List<Class<? extends RelNode>> nodeClasses) {
        this.metadataProvider = this.init(hiveConf, nodeClasses);
    }

    private RelMetadataProvider init(HiveConf hiveConf, List<Class<? extends RelNode>> nodeClasses) {
        if (HiveConf.getVar(hiveConf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") && HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVE_CBO_EXTENDED_COST_MODEL)) {
            Double maxSplitSize = HiveConf.getLongVar(hiveConf, HiveConf.ConfVars.MAPREDMAXSPLITSIZE);
            JaninoRelMetadataProvider metadataProvider = JaninoRelMetadataProvider.of((RelMetadataProvider)ChainedRelMetadataProvider.of(ImmutableList.of(HiveRelMdDistinctRowCount.SOURCE, new HiveRelMdCost(HiveOnTezCostModel.getCostModel(hiveConf)).getMetadataProvider(), HiveRelMdSelectivity.SOURCE, HiveRelMdRowCount.SOURCE, HiveRelMdUniqueKeys.SOURCE, HiveRelMdColumnUniqueness.SOURCE, HiveRelMdExpressionLineage.SOURCE, HiveRelMdSize.SOURCE, HiveRelMdMemory.SOURCE, new HiveRelMdParallelism(maxSplitSize).getMetadataProvider(), HiveRelMdDistribution.SOURCE, HiveRelMdCollation.SOURCE, new RelMetadataProvider[]{HiveRelMdPredicates.SOURCE, JaninoRelMetadataProvider.DEFAULT})));
            if (nodeClasses != null) {
                metadataProvider.register(nodeClasses);
            }
            return metadataProvider;
        }
        return DEFAULT;
    }

    public RelMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public static void initializeMetadataProviderClass(List<Class<? extends RelNode>> nodeClasses) {
        JaninoRelMetadataProvider.DEFAULT.register(nodeClasses);
        DEFAULT.register(nodeClasses);
    }
}

