/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;

public class HiveValues
extends Values
implements HiveRelNode {
    public HiveValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traits) {
        super(cluster, rowType, tuples, traits);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new HiveValues(this.getCluster(), this.getRowType(), this.tuples, this.getTraitSet());
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    public RelNode copy(List<String> newColumnNames) throws CalciteSemanticException {
        if (newColumnNames.size() != this.getRowType().getFieldCount()) {
            throw new CalciteSemanticException("The number of new column names and columns in the schema does not match!");
        }
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        for (int i = 0; i < this.getRowType().getFieldCount(); ++i) {
            builder.add(newColumnNames.get(i), ((RelDataTypeField)this.getRowType().getFieldList().get(i)).getType());
        }
        return new HiveValues(this.getCluster(), builder.uniquify().build(), this.tuples, this.getTraitSet());
    }
}

