/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.util.ControlFlowException;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.JdbcHiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.HiveJdbcImplementor;

public class HiveJdbcConverter
extends ConverterImpl
implements HiveRelNode {
    private final JdbcConvention convention;
    private final String url;
    private final String user;

    public HiveJdbcConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input, JdbcConvention jc, String url, String user) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
        this.convention = jc;
        this.url = url;
        this.user = user;
    }

    public JdbcConvention getJdbcConvention() {
        return this.convention;
    }

    public SqlDialect getJdbcDialect() {
        return this.convention.dialect;
    }

    public String getConnectionUrl() {
        return this.url;
    }

    public String getConnectionUser() {
        return this.user;
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new HiveJdbcConverter(this.getCluster(), traitSet, (RelNode)HiveJdbcConverter.sole(inputs), this.convention, this.url, this.user);
    }

    public RelNode copy(RelTraitSet traitSet, RelNode input) {
        return new HiveJdbcConverter(this.getCluster(), traitSet, input, this.convention, this.url, this.user);
    }

    public String generateSql() {
        Project topProject;
        SqlDialect dialect = this.getJdbcDialect();
        HiveJdbcImplementor jdbcImplementor = new HiveJdbcImplementor(dialect, (JavaTypeFactory)this.getCluster().getTypeFactory());
        if (this.getInput() instanceof Project) {
            topProject = (Project)this.getInput();
        } else {
            RelNode nodeToTranslate = this.getInput();
            RexBuilder builder = this.getCluster().getRexBuilder();
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>(nodeToTranslate.getRowType().getFieldList().size());
            for (int i = 0; i < nodeToTranslate.getRowType().getFieldCount(); ++i) {
                projects.add(builder.makeInputRef(nodeToTranslate, i));
            }
            topProject = new JdbcRules.JdbcProject(nodeToTranslate.getCluster(), nodeToTranslate.getTraitSet(), nodeToTranslate, projects, nodeToTranslate.getRowType());
        }
        SqlImplementor.Result result = jdbcImplementor.visit(topProject);
        return result.asStatement().toSqlString(dialect).getSql();
    }

    public boolean splittingAllowed() {
        JdbcRelVisitor visitor = new JdbcRelVisitor();
        visitor.go(this.getInput());
        return visitor.splittingAllowed;
    }

    public JdbcHiveTableScan getTableScan() {
        final JdbcHiveTableScan[] tmpJdbcHiveTableScan = new JdbcHiveTableScan[1];
        new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof JdbcHiveTableScan && tmpJdbcHiveTableScan[0] == null) {
                    tmpJdbcHiveTableScan[0] = (JdbcHiveTableScan)node;
                } else {
                    super.visit(node, ordinal, parent);
                }
            }
        }.go((RelNode)this);
        JdbcHiveTableScan jdbcHiveTableScan = tmpJdbcHiveTableScan[0];
        assert (jdbcHiveTableScan != null);
        return jdbcHiveTableScan;
    }

    private static class JdbcRelVisitor
    extends RelVisitor {
        private boolean splittingAllowed = true;

        public void visit(RelNode node, int ordinal, RelNode parent) {
            if (!(node instanceof Project || node instanceof Filter || node instanceof TableScan)) {
                throw new ReturnedValue(false);
            }
            super.visit(node, ordinal, parent);
        }

        public RelNode go(RelNode p) {
            try {
                this.visit(p, 0, null);
            }
            catch (ReturnedValue e) {
                this.splittingAllowed = e.value;
            }
            return p;
        }

        private static class ReturnedValue
        extends ControlFlowException {
            private final boolean value;

            public ReturnedValue(boolean value) {
                this.value = value;
            }
        }
    }
}

