/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelCollation;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;

public class HiveAggregateSortLimitRule
extends RelOptRule {
    private final RelFieldCollation.NullDirection defaultAscNullDirection;

    public HiveAggregateSortLimitRule(boolean nullsLast) {
        super(HiveAggregateSortLimitRule.operand(HiveSortLimit.class, (RelOptRuleOperand)HiveAggregateSortLimitRule.operand(HiveAggregate.class, (RelOptRuleOperandChildren)HiveAggregateSortLimitRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), HiveRelFactories.HIVE_BUILDER, "HiveAggregateSortRule");
        this.defaultAscNullDirection = nullsLast ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
    }

    public void onMatch(RelOptRuleCall call) {
        HiveSortLimit sortLimit = (HiveSortLimit)call.rel(0);
        HiveAggregate aggregate = (HiveAggregate)call.rel(1);
        RelBuilder relBuilder = call.builder();
        if (sortLimit.getFetchExpr() == null && sortLimit.getOffsetExpr() == null) {
            return;
        }
        if (aggregate.getAggCallList().isEmpty()) {
            return;
        }
        if (!sortLimit.getCollation().getFieldCollations().isEmpty()) {
            return;
        }
        ImmutableList.Builder newSortKeyBuilder = ImmutableList.builder();
        Iterator iterator = aggregate.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            RelFieldCollation fieldCollation = new RelFieldCollation(i, RelFieldCollation.Direction.ASCENDING, this.defaultAscNullDirection);
            newSortKeyBuilder.add(fieldCollation);
        }
        HiveRelCollation newCollation = new HiveRelCollation((ImmutableList<RelFieldCollation>)newSortKeyBuilder.build());
        HiveSortLimit newSortLimit = sortLimit.copy(sortLimit.getTraitSet(), aggregate, (RelCollation)newCollation, sortLimit.offset, sortLimit.fetch);
        call.transformTo((RelNode)newSortLimit);
    }
}

