/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.rules.PushProjector;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;

public class HiveProjectJoinTransposeRule
extends RelOptRule {
    public static final HiveProjectJoinTransposeRule INSTANCE = new HiveProjectJoinTransposeRule(HiveRelFactories.HIVE_BUILDER);
    private final PushProjector.ExprCondition preserveExprCondition = expr -> !(expr instanceof RexOver);

    private HiveProjectJoinTransposeRule(RelBuilderFactory relBuilderFactory) {
        super(HiveProjectJoinTransposeRule.operand(Project.class, (RelOptRuleOperand)HiveProjectJoinTransposeRule.operand(Join.class, (RelOptRuleOperand)HiveProjectJoinTransposeRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveProjectJoinTransposeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{HiveProjectJoinTransposeRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveProjectJoinTransposeRule.any())}), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, "HiveProjectJoinTransposeRule");
    }

    public boolean matches(RelOptRuleCall call) {
        RelNode leftInput = call.rel(2);
        RelNode rightInput = call.rel(3);
        return !(leftInput instanceof Project) || !(rightInput instanceof Project);
    }

    public void onMatch(RelOptRuleCall call) {
        Project origProj = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        if (join instanceof SemiJoin) {
            return;
        }
        PushProjector pushProject = new PushProjector(origProj, join.getCondition(), (RelNode)join, this.preserveExprCondition, call.builder());
        if (pushProject.locateAllRefs()) {
            return;
        }
        Project leftProjRel = pushProject.createProjectRefsAndExprs(join.getLeft(), true, false);
        Project rightProjRel = pushProject.createProjectRefsAndExprs(join.getRight(), true, true);
        RexNode newJoinFilter = null;
        int[] adjustments = pushProject.getAdjustments();
        if (join.getCondition() != null) {
            ArrayList projJoinFieldList = new ArrayList();
            projJoinFieldList.addAll(join.getSystemFieldList());
            projJoinFieldList.addAll(leftProjRel.getRowType().getFieldList());
            projJoinFieldList.addAll(rightProjRel.getRowType().getFieldList());
            newJoinFilter = pushProject.convertRefsAndExprs(join.getCondition(), projJoinFieldList, adjustments);
        }
        Join newJoinRel = join.copy(join.getTraitSet(), newJoinFilter, (RelNode)leftProjRel, (RelNode)rightProjRel, join.getJoinType(), join.isSemiJoinDone());
        RelNode topProject = pushProject.createNewProject((RelNode)newJoinRel, adjustments);
        call.transformTo(topProject);
    }
}

