/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableFunctionScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRelDecorrelator;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveUnionSimpleSelectsToInlineTableRule
extends RelOptRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveUnionSimpleSelectsToInlineTableRule.class);
    private RelNode dummyTable;

    public HiveUnionSimpleSelectsToInlineTableRule(RelNode dummyTable) {
        super(HiveUnionSimpleSelectsToInlineTableRule.operand(HiveUnion.class, (RelOptRuleOperandChildren)HiveUnionSimpleSelectsToInlineTableRule.any()));
        this.dummyTable = dummyTable;
    }

    public void onMatch(RelOptRuleCall call) {
        RexBuilder rexBuilder = call.builder().getRexBuilder();
        HiveUnion union = (HiveUnion)call.rel(0);
        if (!union.all) {
            return;
        }
        ArrayList<RelNode> inputs = new ArrayList<RelNode>();
        ArrayList<Project> projects = new ArrayList<Project>();
        ArrayList<HiveTableFunctionScan> inlineTables = new ArrayList<HiveTableFunctionScan>();
        for (Object input : union.getInputs()) {
            if (this.isPlainProject((RelNode)(input = HiveRelDecorrelator.stripHep((RelNode)input)))) {
                projects.add((Project)input);
                continue;
            }
            if (this.isInlineTableOperand((RelNode)input)) {
                inlineTables.add((HiveTableFunctionScan)input);
                continue;
            }
            inputs.add((RelNode)input);
        }
        if (projects.size() + inlineTables.size() <= 1) {
            return;
        }
        RowStorage newRows = new RowStorage();
        for (HiveTableFunctionScan rel : inlineTables) {
            RexCall rex = (RexCall)((RexCall)rel.getCall()).operands.get(0);
            for (RexNode row : rex.operands) {
                if (!(row.getType() instanceof RelRecordType)) {
                    return;
                }
                newRows.addRow(row);
            }
        }
        for (Project proj : projects) {
            RexNode row = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.ROW, proj.getProjects());
            if (!(row.getType() instanceof RelRecordType)) {
                return;
            }
            newRows.addRow(row);
        }
        if (newRows.keySet().size() + inputs.size() == union.getInputs().size()) {
            return;
        }
        if (this.dummyTable == null) {
            LOG.warn("Unexpected; rule would match - but dummyTable is not available");
            return;
        }
        for (RelRecordType type : newRows.keySet()) {
            List rows = (List)newRows.get(type);
            RelDataType arrayType = rexBuilder.getTypeFactory().createArrayType((RelDataType)type, -1L);
            try {
                SqlOperator inlineFn = SqlFunctionConverter.getCalciteFn("inline", Collections.singletonList(arrayType), (RelDataType)type, true, false);
                SqlOperator arrayFn = SqlFunctionConverter.getCalciteFn("array", Collections.nCopies(rows.size(), type), arrayType, true, false);
                RexNode expr = rexBuilder.makeCall(arrayFn, rows);
                expr = rexBuilder.makeCall(inlineFn, new RexNode[]{expr});
                RelNode newInlineTable = this.buildTableFunctionScan(expr, union.getCluster());
                inputs.add(newInlineTable);
            }
            catch (CalciteSemanticException e) {
                LOG.debug("Conversion failed with exception", (Throwable)e);
                return;
            }
        }
        if (inputs.size() > 1) {
            HiveUnion newUnion = (HiveUnion)union.copy(union.getTraitSet(), inputs, true);
            call.transformTo((RelNode)newUnion);
        } else {
            call.transformTo((RelNode)inputs.get(0));
        }
    }

    private boolean isPlainProject(RelNode input) {
        if (!((input = HiveRelDecorrelator.stripHep(input)) instanceof Project)) {
            return false;
        }
        if (input.getInputs().size() == 0) {
            return true;
        }
        return this.isDummyTableScan(input.getInput(0));
    }

    private boolean isInlineTableOperand(RelNode input) {
        if (!((input = HiveRelDecorrelator.stripHep(input)) instanceof HiveTableFunctionScan)) {
            return false;
        }
        if (input.getInputs().size() == 0) {
            return true;
        }
        return this.isDummyTableScan(input.getInput(0));
    }

    private boolean isDummyTableScan(RelNode input) {
        if (!((input = HiveRelDecorrelator.stripHep(input)) instanceof HiveTableScan)) {
            return false;
        }
        HiveTableScan ts = (HiveTableScan)input;
        Table table = ((RelOptHiveTable)ts.getTable()).getHiveTableMD();
        return "_dummy_database".equals(table.getDbName());
    }

    private RelNode buildTableFunctionScan(RexNode expr, RelOptCluster cluster) throws CalciteSemanticException {
        return HiveTableFunctionScan.create(cluster, TraitsUtil.getDefaultTraitSet(cluster), ImmutableList.of(this.dummyTable), expr, null, expr.getType(), null);
    }

    static class RowStorage
    extends HashMap<RelRecordType, List<RexNode>> {
        private static final long serialVersionUID = 1L;

        RowStorage() {
        }

        public void addRow(RexNode row) {
            RelRecordType type = (RelRecordType)row.getType();
            ArrayList<RexNode> e = (ArrayList<RexNode>)this.get(type);
            if (e == null) {
                e = new ArrayList<RexNode>();
                this.put(type, e);
            }
            e.add(row);
        }
    }
}

