/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import com.google.common.collect.ImmutableSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.plan.ColStatistics;

public final class EstimateUniqueKeys {
    private EstimateUniqueKeys() {
    }

    private static Set<ImmutableBitSet> getUniqueKeys(HiveFilter rel) {
        return EstimateUniqueKeys.getUniqueKeys(rel.getInput());
    }

    private static Set<ImmutableBitSet> getUniqueKeys(HiveSortLimit rel) {
        return EstimateUniqueKeys.getUniqueKeys(rel.getInput());
    }

    private static Set<ImmutableBitSet> getUniqueKeys(Correlate rel) {
        return EstimateUniqueKeys.getUniqueKeys(rel.getLeft());
    }

    private static Set<ImmutableBitSet> generateKeysUsingStatsEstimation(Project rel, HiveTableScan tScan) {
        HashMap<Integer, Integer> posMap = new HashMap<Integer, Integer>();
        int projectPos = 0;
        int colStatsPos = 0;
        BitSet projectedCols = new BitSet();
        for (RexNode r : rel.getProjects()) {
            if (r instanceof RexInputRef) {
                projectedCols.set(((RexInputRef)r).getIndex());
                posMap.put(colStatsPos, projectPos);
                ++colStatsPos;
            }
            ++projectPos;
        }
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        double numRows = mq.getRowCount((RelNode)tScan);
        List<ColStatistics> colStats = tScan.getColStat(BitSets.toList((BitSet)projectedCols));
        HashSet<ImmutableBitSet> keys = new HashSet<ImmutableBitSet>();
        colStatsPos = 0;
        for (ColStatistics cStat : colStats) {
            boolean isKey = false;
            if (!cStat.isEstimated()) {
                if ((double)cStat.getCountDistint() >= numRows) {
                    isKey = true;
                }
                if (!isKey && cStat.getRange() != null && cStat.getRange().maxValue != null && cStat.getRange().minValue != null) {
                    double r = cStat.getRange().maxValue.doubleValue() - cStat.getRange().minValue.doubleValue() + 1.0;
                    boolean bl = isKey = Math.abs(numRows - r) < 1.0E-5;
                }
                if (isKey) {
                    ImmutableBitSet key = ImmutableBitSet.of((int[])new int[]{(Integer)posMap.get(colStatsPos)});
                    keys.add(key);
                }
            }
            ++colStatsPos;
        }
        return keys;
    }

    private static Set<ImmutableBitSet> getUniqueKeys(HiveProject rel) {
        HiveTableScan tScan = EstimateUniqueKeys.getTableScan(rel.getInput(), false);
        if (tScan != null) {
            return EstimateUniqueKeys.generateKeysUsingStatsEstimation(rel, tScan);
        }
        HashMap<Integer, Integer> mapInToOutPos = new HashMap<Integer, Integer>();
        List projExprs = rel.getProjects();
        HashSet<ImmutableBitSet> projUniqueKeySet = new HashSet<ImmutableBitSet>();
        for (int i = 0; i < projExprs.size(); ++i) {
            RexNode projExpr = (RexNode)projExprs.get(i);
            if (!(projExpr instanceof RexInputRef)) continue;
            mapInToOutPos.put(((RexInputRef)projExpr).getIndex(), i);
        }
        if (mapInToOutPos.isEmpty()) {
            return projUniqueKeySet;
        }
        Set<ImmutableBitSet> childUniqueKeySet = EstimateUniqueKeys.getUniqueKeys(rel.getInput());
        if (childUniqueKeySet != null) {
            for (ImmutableBitSet colMask : childUniqueKeySet) {
                ImmutableBitSet.Builder tmpMask = ImmutableBitSet.builder();
                boolean completeKeyProjected = true;
                Iterator iterator = colMask.iterator();
                while (iterator.hasNext()) {
                    int bit = (Integer)iterator.next();
                    if (mapInToOutPos.containsKey(bit)) {
                        tmpMask.set(((Integer)mapInToOutPos.get(bit)).intValue());
                        continue;
                    }
                    completeKeyProjected = false;
                    break;
                }
                if (!completeKeyProjected) continue;
                projUniqueKeySet.add(tmpMask.build());
            }
        }
        return projUniqueKeySet;
    }

    private static RelNode getRelNode(RelNode rel) {
        if (rel != null && rel instanceof HepRelVertex) {
            rel = ((HepRelVertex)rel).getCurrentRel();
        } else if (rel != null && rel instanceof RelSubset) {
            rel = (RelNode)Util.first((Object)((RelSubset)rel).getBest(), (Object)((RelSubset)rel).getOriginal());
        }
        return rel;
    }

    private static Set<ImmutableBitSet> getUniqueKeys(HiveJoin rel) {
        RelNode left = EstimateUniqueKeys.getRelNode(rel.getLeft());
        RelNode right = EstimateUniqueKeys.getRelNode(rel.getRight());
        HashSet<ImmutableBitSet> retSet = new HashSet<ImmutableBitSet>();
        Set<ImmutableBitSet> leftSet = EstimateUniqueKeys.getUniqueKeys(left);
        HashSet<ImmutableBitSet> rightSet = null;
        Set<ImmutableBitSet> tmpRightSet = EstimateUniqueKeys.getUniqueKeys(right);
        int nFieldsOnLeft = left.getRowType().getFieldCount();
        if (tmpRightSet != null) {
            rightSet = new HashSet<ImmutableBitSet>();
            for (ImmutableBitSet colMask : tmpRightSet) {
                ImmutableBitSet.Builder tmpMask = ImmutableBitSet.builder();
                Iterator iterator = colMask.iterator();
                while (iterator.hasNext()) {
                    int bit = (Integer)iterator.next();
                    tmpMask.set(bit + nFieldsOnLeft);
                }
                rightSet.add(tmpMask.build());
            }
            if (leftSet != null) {
                for (ImmutableBitSet colMaskRight : rightSet) {
                    for (ImmutableBitSet colMaskLeft : leftSet) {
                        retSet.add(colMaskLeft.union(colMaskRight));
                    }
                }
            }
        }
        JoinInfo joinInfo = rel.analyzeCondition();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        Boolean leftUnique = mq.areColumnsUnique(left, joinInfo.leftSet());
        Boolean rightUnique = mq.areColumnsUnique(right, joinInfo.rightSet());
        if (rightUnique != null && rightUnique.booleanValue() && leftSet != null && !rel.getJoinType().generatesNullsOnLeft()) {
            retSet.addAll(leftSet);
        }
        if (leftUnique != null && leftUnique.booleanValue() && rightSet != null && !rel.getJoinType().generatesNullsOnRight()) {
            retSet.addAll(rightSet);
        }
        return retSet;
    }

    private static Set<ImmutableBitSet> getUniqueKeys(HiveSemiJoin rel) {
        return EstimateUniqueKeys.getUniqueKeys(rel.getLeft());
    }

    private static Set<ImmutableBitSet> getUniqueKeys(HiveAggregate rel) {
        return ImmutableSet.of(rel.getGroupSet());
    }

    private static Set<ImmutableBitSet> getUniqueKeys(SetOp rel) {
        if (!rel.all) {
            return ImmutableSet.of(ImmutableBitSet.range((int)rel.getRowType().getFieldCount()));
        }
        return ImmutableSet.of();
    }

    public static Set<ImmutableBitSet> getUniqueKeys(RelNode rel) {
        if ((rel = EstimateUniqueKeys.getRelNode(rel)) instanceof HiveFilter) {
            return EstimateUniqueKeys.getUniqueKeys((HiveFilter)rel);
        }
        if (rel instanceof HiveSortLimit) {
            return EstimateUniqueKeys.getUniqueKeys((HiveSortLimit)rel);
        }
        if (rel instanceof Correlate) {
            return EstimateUniqueKeys.getUniqueKeys((Correlate)rel);
        }
        if (rel instanceof HiveProject) {
            return EstimateUniqueKeys.getUniqueKeys((HiveProject)rel);
        }
        if (rel instanceof HiveJoin) {
            return EstimateUniqueKeys.getUniqueKeys((HiveJoin)rel);
        }
        if (rel instanceof HiveSemiJoin) {
            return EstimateUniqueKeys.getUniqueKeys((HiveSemiJoin)rel);
        }
        if (rel instanceof HiveAggregate) {
            return EstimateUniqueKeys.getUniqueKeys((HiveAggregate)rel);
        }
        if (rel instanceof SetOp) {
            return EstimateUniqueKeys.getUniqueKeys((SetOp)rel);
        }
        return null;
    }

    static HiveTableScan getTableScan(RelNode r, boolean traverseProject) {
        while (r != null && !(r instanceof HiveTableScan)) {
            if (r instanceof HepRelVertex) {
                r = ((HepRelVertex)r).getCurrentRel();
                continue;
            }
            if (r instanceof Filter) {
                r = ((Filter)r).getInput();
                continue;
            }
            if (traverseProject && r instanceof Project) {
                r = ((Project)r).getInput();
                continue;
            }
            r = null;
        }
        return r == null ? null : (HiveTableScan)r;
    }
}

