/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.JoinTypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

public class JoinCondTypeCheckProcFactory
extends TypeCheckProcFactory {
    public static Map<ASTNode, ExprNodeDesc> genExprNode(ASTNode expr, TypeCheckCtx tcCtx) throws SemanticException {
        return TypeCheckProcFactory.genExprNode(expr, tcCtx, new JoinCondTypeCheckProcFactory());
    }

    @Override
    public TypeCheckProcFactory.ColumnExprProcessor getColumnExprProcessor() {
        return new JoinCondColumnExprProcessor();
    }

    @Override
    public TypeCheckProcFactory.DefaultExprProcessor getDefaultExprProcessor() {
        return new JoinCondDefaultExprProcessor();
    }

    public static class JoinCondDefaultExprProcessor
    extends TypeCheckProcFactory.DefaultExprProcessor {
        @Override
        protected List<String> getReferenceableColumnAliases(TypeCheckCtx ctx) {
            JoinTypeCheckCtx jCtx = (JoinTypeCheckCtx)ctx;
            ArrayList<String> possibleColumnNames = new ArrayList<String>();
            for (RowResolver rr : jCtx.getInputRRList()) {
                possibleColumnNames.addAll(rr.getReferenceableColumnAliases(null, -1));
            }
            return possibleColumnNames;
        }

        @Override
        protected ExprNodeColumnDesc processQualifiedColRef(TypeCheckCtx ctx, ASTNode expr, Object ... nodeOutputs) throws SemanticException {
            String tableAlias = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText());
            ColumnInfo colInfo = JoinCondDefaultExprProcessor.getColInfo((JoinTypeCheckCtx)ctx, tableAlias, ((ExprNodeConstantDesc)nodeOutputs[1]).getValue().toString(), expr);
            if (colInfo == null) {
                ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr.getChild(1)), expr);
                return null;
            }
            return new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), tableAlias, colInfo.getIsVirtualCol());
        }

        private static ColumnInfo getColInfo(JoinTypeCheckCtx ctx, String tabName, String colAlias, ASTNode expr) throws SemanticException {
            ColumnInfo cInfoToRet = null;
            for (RowResolver rr : ctx.getInputRRList()) {
                ColumnInfo tmp = rr.get(tabName, colAlias);
                if (tmp == null) continue;
                if (cInfoToRet != null) {
                    throw new SemanticException(ErrorMsg.AMBIGUOUS_TABLE_OR_COLUMN.getMsg(expr));
                }
                cInfoToRet = tmp;
            }
            return cInfoToRet;
        }
    }

    public static class JoinCondColumnExprProcessor
    extends TypeCheckProcFactory.ColumnExprProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ASTNode parent;
            JoinTypeCheckCtx ctx = (JoinTypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ASTNode expr = (ASTNode)nd;
            ASTNode aSTNode = parent = stack.size() > 1 ? (ASTNode)stack.get(stack.size() - 2) : null;
            if (expr.getType() != 1130) {
                ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr), expr);
                return null;
            }
            assert (expr.getChildCount() == 1);
            String tableOrCol = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText());
            boolean qualifiedAccess = parent != null && parent.getType() == 16;
            ColumnInfo colInfo = null;
            if (!qualifiedAccess) {
                colInfo = JoinCondColumnExprProcessor.getColInfo(ctx, null, tableOrCol, expr);
                return new ExprNodeColumnDesc(colInfo);
            }
            if (JoinCondColumnExprProcessor.hasTableAlias(ctx, tableOrCol, expr)) {
                return null;
            }
            throw new SemanticException(ErrorMsg.INVALID_TABLE_ALIAS.getMsg(expr));
        }

        private static boolean hasTableAlias(JoinTypeCheckCtx ctx, String tabName, ASTNode expr) throws SemanticException {
            int tblAliasCnt = 0;
            for (RowResolver rr : ctx.getInputRRList()) {
                if (!rr.hasTableAlias(tabName)) continue;
                ++tblAliasCnt;
            }
            if (tblAliasCnt > 1) {
                throw new SemanticException(ErrorMsg.AMBIGUOUS_TABLE_OR_COLUMN.getMsg(expr));
            }
            return tblAliasCnt == 1;
        }

        private static ColumnInfo getColInfo(JoinTypeCheckCtx ctx, String tabName, String colAlias, ASTNode expr) throws SemanticException {
            ColumnInfo cInfoToRet = null;
            for (RowResolver rr : ctx.getInputRRList()) {
                ColumnInfo tmp = rr.get(tabName, colAlias);
                if (tmp == null) continue;
                if (cInfoToRet != null) {
                    throw new SemanticException(ErrorMsg.AMBIGUOUS_TABLE_OR_COLUMN.getMsg(expr));
                }
                cInfoToRet = tmp;
            }
            return cInfoToRet;
        }
    }
}

