/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ExprNodeConverter;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HiveOpConverterUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HiveOpConverterUtils.class);

    private HiveOpConverterUtils() {
        throw new UnsupportedOperationException("HiveOpConverterUtils should not be instantiated!");
    }

    static SelectOperator genReduceSinkAndBacktrackSelect(Operator<?> input, ExprNodeDesc[] keys, int tag, ArrayList<ExprNodeDesc> partitionCols, String order, String nullOrder, int numReducers, AcidUtils.Operation acidOperation, HiveConf hiveConf, List<String> keepColNames) throws SemanticException {
        String tableAlias = null;
        Set<String> tableNames = input.getSchema().getTableNames();
        for (String tableName : tableNames) {
            if (tableName == null) continue;
            if (tableName.length() == 0) {
                if (tableAlias != null) continue;
                tableAlias = tableName;
                continue;
            }
            if (tableAlias == null || tableAlias.length() == 0) {
                tableAlias = tableName;
                continue;
            }
            if (tableName.equals(tableAlias)) continue;
            throw new SemanticException("In CBO return path, genReduceSinkAndBacktrackSelect is expecting only one tableAlias but there is more than one");
        }
        if (tableAlias == null) {
            throw new SemanticException("In CBO return path, genReduceSinkAndBacktrackSelect is expecting only one tableAlias but there is none");
        }
        ReduceSinkOperator rsOp = HiveOpConverterUtils.genReduceSink(input, tableAlias, keys, tag, partitionCols, order, nullOrder, numReducers, acidOperation, hiveConf);
        Map<String, ExprNodeDesc> descriptors = HiveOpConverterUtils.buildBacktrackFromReduceSink(keepColNames, ((ReduceSinkDesc)rsOp.getConf()).getOutputKeyColumnNames(), ((ReduceSinkDesc)rsOp.getConf()).getOutputValueColumnNames(), rsOp.getValueIndex(), input);
        SelectDesc selectDesc = new SelectDesc(new ArrayList<ExprNodeDesc>(descriptors.values()), new ArrayList<String>(descriptors.keySet()));
        ArrayList<ColumnInfo> cinfoLst = HiveOpConverterUtils.createColInfosSubset(input, keepColNames);
        SelectOperator selectOp = (SelectOperator)OperatorFactory.getAndMakeChild(selectDesc, new RowSchema(cinfoLst), (Operator)rsOp, new Operator[0]);
        selectOp.setColumnExprMap(descriptors);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated " + selectOp + " with row schema: [" + selectOp.getSchema() + "]");
        }
        return selectOp;
    }

    static ReduceSinkOperator genReduceSink(Operator<?> input, String tableAlias, ExprNodeDesc[] keys, int tag, ArrayList<ExprNodeDesc> partitionCols, String order, String nullOrder, int numReducers, AcidUtils.Operation acidOperation, HiveConf hiveConf) throws SemanticException {
        Operator dummy = Operator.createDummy();
        dummy.setParentOperators(Arrays.asList(input));
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> reduceKeysBack = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc key : keys) {
            reduceKeys.add(key);
            reduceKeysBack.add(ExprNodeDescUtils.backtrack(key, dummy, input));
        }
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> reduceValuesBack = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        List<ColumnInfo> inputColumns = input.getSchema().getSignature();
        ArrayList<ColumnInfo> outputColumns = new ArrayList<ColumnInfo>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        int[] index = new int[inputColumns.size()];
        for (int i = 0; i < inputColumns.size(); ++i) {
            int vindex;
            int kindex;
            ColumnInfo colInfo = inputColumns.get(i);
            String outputColName = colInfo.getInternalName();
            ExprNodeColumnDesc expr = new ExprNodeColumnDesc(colInfo);
            ExprNodeDesc exprBack = ExprNodeDescUtils.backtrack((ExprNodeDesc)expr, dummy, input);
            int n = kindex = exprBack == null ? -1 : ExprNodeDescUtils.indexOf(exprBack, reduceKeysBack);
            if (kindex >= 0) {
                ColumnInfo newColInfo = new ColumnInfo(colInfo);
                newColInfo.setInternalName((Object)((Object)Utilities.ReduceField.KEY) + ".reducesinkkey" + kindex);
                newColInfo.setAlias(outputColName);
                newColInfo.setTabAlias(tableAlias);
                outputColumns.add(newColInfo);
                index[i] = kindex;
                continue;
            }
            int n2 = vindex = exprBack == null ? -1 : ExprNodeDescUtils.indexOf(exprBack, reduceValuesBack);
            if (vindex >= 0) {
                index[i] = -vindex - 1;
                continue;
            }
            index[i] = -reduceValues.size() - 1;
            reduceValues.add(expr);
            reduceValuesBack.add(exprBack);
            ColumnInfo newColInfo = new ColumnInfo(colInfo);
            newColInfo.setInternalName((Object)((Object)Utilities.ReduceField.VALUE) + "." + outputColName);
            newColInfo.setAlias(outputColName);
            newColInfo.setTabAlias(tableAlias);
            outputColumns.add(newColInfo);
            outputColumnNames.add(outputColName);
        }
        dummy.setParentOperators(null);
        if (reduceKeys.size() == 0) {
            numReducers = 1;
            String error = HiveConf.StrictChecks.checkCartesian(hiveConf);
            if (error != null) {
                throw new SemanticException(error);
            }
        }
        ReduceSinkDesc rsDesc = order.isEmpty() ? PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, false, tag, reduceKeys.size(), numReducers, acidOperation) : PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, false, tag, partitionCols, order, nullOrder, numReducers, acidOperation, false);
        ReduceSinkOperator rsOp = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(rsDesc, new RowSchema(outputColumns), input, new Operator[0]);
        List<String> keyColNames = rsDesc.getOutputKeyColumnNames();
        for (int i = 0; i < keyColNames.size(); ++i) {
            colExprMap.put((Object)((Object)Utilities.ReduceField.KEY) + "." + keyColNames.get(i), reduceKeys.get(i));
        }
        List<String> valColNames = rsDesc.getOutputValueColumnNames();
        for (int i = 0; i < valColNames.size(); ++i) {
            colExprMap.put((Object)((Object)Utilities.ReduceField.VALUE) + "." + valColNames.get(i), reduceValues.get(i));
        }
        rsOp.setValueIndex(index);
        rsOp.setColumnExprMap(colExprMap);
        rsOp.setInputAliases(input.getSchema().getTableNames().toArray(new String[input.getSchema().getTableNames().size()]));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated " + rsOp + " with row schema: [" + rsOp.getSchema() + "]");
        }
        return rsOp;
    }

    private static Map<String, ExprNodeDesc> buildBacktrackFromReduceSink(List<String> keepColNames, List<String> keyColNames, List<String> valueColNames, int[] index, Operator<?> inputOp) {
        LinkedHashMap<String, ExprNodeDesc> columnDescriptors = new LinkedHashMap<String, ExprNodeDesc>();
        int pos = 0;
        for (int i = 0; i < index.length; ++i) {
            ColumnInfo info = inputOp.getSchema().getSignature().get(i);
            if (pos >= keepColNames.size() || !info.getInternalName().equals(keepColNames.get(pos))) continue;
            String field = index[i] >= 0 ? (Object)((Object)Utilities.ReduceField.KEY) + "." + keyColNames.get(index[i]) : (Object)((Object)Utilities.ReduceField.VALUE) + "." + valueColNames.get(-index[i] - 1);
            ExprNodeColumnDesc desc = new ExprNodeColumnDesc(info.getType(), field, info.getTabAlias(), info.getIsVirtualCol());
            columnDescriptors.put(keepColNames.get(pos), desc);
            ++pos;
        }
        return columnDescriptors;
    }

    static ExprNodeDesc convertToExprNode(RexNode rn, RelNode inputRel, String tabAlias, Set<Integer> vcolsInCalcite) {
        return (ExprNodeDesc)rn.accept((RexVisitor)new ExprNodeConverter(tabAlias, inputRel.getRowType(), vcolsInCalcite, inputRel.getCluster().getTypeFactory(), true));
    }

    static ArrayList<ColumnInfo> createColInfos(Operator<?> input) {
        ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
        for (ColumnInfo ci : input.getSchema().getSignature()) {
            cInfoLst.add(new ColumnInfo(ci));
        }
        return cInfoLst;
    }

    private static ArrayList<ColumnInfo> createColInfosSubset(Operator<?> input, List<String> keepColNames) {
        ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
        int pos = 0;
        for (ColumnInfo ci : input.getSchema().getSignature()) {
            if (pos >= keepColNames.size() || !ci.getInternalName().equals(keepColNames.get(pos))) continue;
            cInfoLst.add(new ColumnInfo(ci));
            ++pos;
        }
        return cInfoLst;
    }
}

