/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableFunctionScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ExprNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveOpConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveRelNodeVisitor;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.UDTFDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

class HiveTableFunctionScanVisitor
extends HiveRelNodeVisitor<HiveTableFunctionScan> {
    HiveTableFunctionScanVisitor(HiveOpConverter hiveOpConverter) {
        super(hiveOpConverter);
    }

    @Override
    HiveOpConverter.OpAttr visit(HiveTableFunctionScan scanRel) throws SemanticException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + scanRel.getId() + ":" + scanRel.getRelTypeName() + " with row type: [" + scanRel.getRowType() + "]");
        }
        RexCall call = (RexCall)scanRel.getCall();
        RowResolver rowResolver = new RowResolver();
        ArrayList fieldNames = new ArrayList(scanRel.getRowType().getFieldNames());
        ArrayList<String> functionFieldNames = new ArrayList<String>();
        ArrayList<ExprNodeDesc> exprCols = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int pos = 0; pos < call.getOperands().size(); ++pos) {
            ExprNodeConverter converter = new ExprNodeConverter("_dummy_table", (String)fieldNames.get(pos), scanRel.getRowType(), scanRel.getRowType(), ((HiveTableScan)scanRel.getInput(0)).getPartOrVirtualCols(), scanRel.getCluster().getTypeFactory(), true);
            ExprNodeDesc exprCol = (ExprNodeDesc)((RexNode)call.getOperands().get(pos)).accept((RexVisitor)converter);
            colExprMap.put(HiveConf.getColumnInternalName(pos), exprCol);
            exprCols.add(exprCol);
            ColumnInfo columnInfo = new ColumnInfo(HiveConf.getColumnInternalName(pos), exprCol.getWritableObjectInspector(), "_dummy_table", false);
            rowResolver.put(columnInfo.getTabAlias(), columnInfo.getAlias(), columnInfo);
            functionFieldNames.add(HiveConf.getColumnInternalName(pos));
        }
        HiveOpConverter.OpAttr inputOpAf = this.hiveOpConverter.dispatch((RelNode)scanRel.getInputs().get(0));
        TableScanOperator op = (TableScanOperator)inputOpAf.inputs.get(0);
        ((TableScanDesc)op.getConf()).setRowLimit(1);
        Operator<SelectDesc> output = OperatorFactory.getAndMakeChild(new SelectDesc(exprCols, functionFieldNames, false), new RowSchema(rowResolver.getRowSchema()), (Operator)op, new Operator[0]);
        output.setColumnExprMap(colExprMap);
        Operator<?> funcOp = this.genUDTFPlan(call, functionFieldNames, output, rowResolver);
        return new HiveOpConverter.OpAttr(null, new HashSet<Integer>(), funcOp);
    }

    private Operator<?> genUDTFPlan(RexCall call, List<String> colAliases, Operator<?> input, RowResolver rowResolver) throws SemanticException {
        LOG.debug("genUDTFPlan, Col aliases: {}", colAliases);
        GenericUDTF genericUDTF = this.createGenericUDTF(call);
        StructObjectInspector rowOI = this.createStructObjectInspector(rowResolver, colAliases);
        StructObjectInspector outputOI = genericUDTF.initialize(rowOI);
        List<ColumnInfo> columnInfos = this.createColumnInfos(outputOI);
        return OperatorFactory.getAndMakeChild(new UDTFDesc(genericUDTF, false), new RowSchema(columnInfos), input, new Operator[0]);
    }

    private GenericUDTF createGenericUDTF(RexCall call) throws SemanticException {
        String functionName = call.getOperator().getName();
        FunctionInfo fi = FunctionRegistry.getFunctionInfo(functionName);
        return fi.getGenericUDTF();
    }

    private StructObjectInspector createStructObjectInspector(RowResolver rowResolver, List<String> colAliases) throws SemanticException {
        List<String> colNames = rowResolver.getColumnInfos().stream().map(ci -> ci.getInternalName()).collect(Collectors.toList());
        List<ObjectInspector> colOIs = rowResolver.getColumnInfos().stream().map(ci -> ci.getObjectInspector()).collect(Collectors.toList());
        return ObjectInspectorFactory.getStandardStructObjectInspector(colNames, colOIs);
    }

    private List<ColumnInfo> createColumnInfos(StructObjectInspector outputOI) {
        ArrayList<ColumnInfo> columnInfos = new ArrayList<ColumnInfo>();
        for (StructField structField : outputOI.getAllStructFieldRefs()) {
            ColumnInfo col = new ColumnInfo(structField.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(structField.getFieldObjectInspector()), null, false);
            col.setAlias(structField.getFieldName());
            columnInfos.add(col);
        }
        return columnInfos;
    }
}

