/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.metainfo.annotation;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.AbstractBucketJoinProc;
import org.apache.hadoop.hive.ql.optimizer.metainfo.annotation.AnnotateOpTraitsProcCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OpTraits;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionDef;

public class OpTraitsRulesProcFactory {
    public static NodeProcessor getTableScanRule() {
        return new TableScanRule();
    }

    public static NodeProcessor getReduceSinkRule() {
        return new ReduceSinkRule();
    }

    public static NodeProcessor getSelectRule() {
        return new SelectRule();
    }

    public static NodeProcessor getDefaultRule() {
        return new DefaultRule();
    }

    public static NodeProcessor getMultiParentRule() {
        return new MultiParentRule();
    }

    public static NodeProcessor getGroupByRule() {
        return new GroupByRule();
    }

    public static NodeProcessor getPTFRule() {
        return new PTFRule();
    }

    public static NodeProcessor getJoinRule() {
        return new JoinRule();
    }

    public static class MultiParentRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator operator = (Operator)nd;
            int numReduceSinks = 0;
            for (Operator<OperatorDesc> parentOp : operator.getParentOperators()) {
                if (parentOp.getOpTraits() == null || parentOp.getOpTraits().getNumReduceSinks() <= numReduceSinks) continue;
                numReduceSinks = parentOp.getOpTraits().getNumReduceSinks();
            }
            OpTraits opTraits = new OpTraits(null, -1, null, numReduceSinks);
            operator.setOpTraits(opTraits);
            return null;
        }
    }

    public static class JoinRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator joinOp = (JoinOperator)nd;
            ArrayList<List<String>> bucketColsList = new ArrayList<List<String>>();
            ArrayList<List<String>> sortColsList = new ArrayList<List<String>>();
            byte pos = 0;
            int numReduceSinks = 0;
            for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
                if (!(parentOp instanceof ReduceSinkOperator)) break;
                ReduceSinkOperator rsOp = (ReduceSinkOperator)parentOp;
                if (rsOp.getOpTraits() == null) {
                    ReduceSinkRule rsRule = new ReduceSinkRule();
                    rsRule.process(rsOp, stack, procCtx, nodeOutputs);
                }
                OpTraits parentOpTraits = rsOp.getOpTraits();
                bucketColsList.add(this.getOutputColNames(joinOp, parentOpTraits.getBucketColNames(), pos));
                sortColsList.add(this.getOutputColNames(joinOp, parentOpTraits.getSortCols(), pos));
                if (parentOpTraits.getNumReduceSinks() > numReduceSinks) {
                    numReduceSinks = parentOpTraits.getNumReduceSinks();
                }
                pos = (byte)(pos + 1);
            }
            joinOp.setOpTraits(new OpTraits(bucketColsList, -1, bucketColsList, numReduceSinks));
            return null;
        }

        private List<String> getOutputColNames(JoinOperator joinOp, List<List<String>> parentColNames, byte pos) {
            if (parentColNames == null) {
                return null;
            }
            ArrayList<String> bucketColNames = new ArrayList<String>();
            List<Object> colNames = parentColNames.size() > 0 ? parentColNames.get(0) : new ArrayList();
            block0: for (String string : colNames) {
                for (ExprNodeDesc exprNode : ((JoinDesc)joinOp.getConf()).getExprs().get(pos)) {
                    if (!(exprNode instanceof ExprNodeColumnDesc) || !((ExprNodeColumnDesc)exprNode).getColumn().equals(string)) continue;
                    for (Map.Entry<String, ExprNodeDesc> entry : joinOp.getColumnExprMap().entrySet()) {
                        if (!entry.getValue().isSame(exprNode)) continue;
                        bucketColNames.add(entry.getKey());
                        continue block0;
                    }
                    continue block0;
                }
            }
            return bucketColNames;
        }
    }

    public static class SelectRule
    implements NodeProcessor {
        public List<List<String>> getConvertedColNames(List<List<String>> parentColNames, SelectOperator selOp, boolean processSortCols) {
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            for (List<String> colNames : parentColNames) {
                ArrayList<String> bucketColNames = new ArrayList<String>();
                boolean found = false;
                for (String colName : colNames) {
                    found = false;
                    for (Map.Entry<String, ExprNodeDesc> entry : selOp.getColumnExprMap().entrySet()) {
                        if (!(entry.getValue() instanceof ExprNodeColumnDesc) || !((ExprNodeColumnDesc)entry.getValue()).getColumn().equals(colName)) continue;
                        bucketColNames.add(entry.getKey());
                        found = true;
                        break;
                    }
                    if (found) continue;
                    break;
                }
                if (!processSortCols && !found) {
                    listBucketCols.add(new ArrayList());
                    continue;
                }
                listBucketCols.add(bucketColNames);
            }
            return listBucketCols;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator selOp = (SelectOperator)nd;
            List<List<String>> parentBucketColNames = selOp.getParentOperators().get(0).getOpTraits().getBucketColNames();
            List<List<String>> listBucketCols = null;
            List<List<String>> listSortCols = null;
            if (selOp.getColumnExprMap() != null) {
                List<List<String>> parentSortColNames;
                if (parentBucketColNames != null) {
                    listBucketCols = this.getConvertedColNames(parentBucketColNames, selOp, false);
                }
                if ((parentSortColNames = selOp.getParentOperators().get(0).getOpTraits().getSortCols()) != null) {
                    listSortCols = this.getConvertedColNames(parentSortColNames, selOp, true);
                }
            }
            int numBuckets = -1;
            int numReduceSinks = 0;
            OpTraits parentOpTraits = selOp.getParentOperators().get(0).getOpTraits();
            if (parentOpTraits != null) {
                if (listBucketCols != null && !listBucketCols.isEmpty() && !listBucketCols.get(0).isEmpty()) {
                    numBuckets = parentOpTraits.getNumBuckets();
                }
                numReduceSinks = parentOpTraits.getNumReduceSinks();
            }
            OpTraits opTraits = new OpTraits(listBucketCols, numBuckets, listSortCols, numReduceSinks);
            selOp.setOpTraits(opTraits);
            return null;
        }
    }

    public static class PTFRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            PTFOperator ptfOp = (PTFOperator)nd;
            ArrayList<String> partitionKeys = new ArrayList<String>();
            PartitionDef partition = ((PTFDesc)ptfOp.getConf()).getFuncDef().getPartition();
            if (partition != null && partition.getExpressions() != null) {
                for (PTFExpressionDef expression : partition.getExpressions()) {
                    ExprNodeDesc exprNode = expression.getExprNode();
                    if (!(exprNode instanceof ExprNodeColumnDesc)) {
                        partitionKeys.clear();
                        break;
                    }
                    partitionKeys.add(exprNode.getExprString());
                }
            }
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            int numReduceSinks = 0;
            OpTraits parentOptraits = ptfOp.getParentOperators().get(0).getOpTraits();
            if (parentOptraits != null) {
                numReduceSinks = parentOptraits.getNumReduceSinks();
            }
            listBucketCols.add(partitionKeys);
            OpTraits opTraits = new OpTraits(listBucketCols, -1, listBucketCols, numReduceSinks);
            ptfOp.setOpTraits(opTraits);
            return null;
        }
    }

    public static class GroupByRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            GroupByOperator gbyOp = (GroupByOperator)nd;
            ArrayList<String> gbyKeys = new ArrayList<String>();
            for (ExprNodeDesc exprDesc : ((GroupByDesc)gbyOp.getConf()).getKeys()) {
                for (Map.Entry<String, ExprNodeDesc> entry : gbyOp.getColumnExprMap().entrySet()) {
                    if (!exprDesc.isSame(entry.getValue())) continue;
                    gbyKeys.add(entry.getKey());
                }
            }
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            int numReduceSinks = 0;
            OpTraits parentOpTraits = gbyOp.getParentOperators().get(0).getOpTraits();
            if (parentOpTraits != null) {
                numReduceSinks = parentOpTraits.getNumReduceSinks();
            }
            listBucketCols.add(gbyKeys);
            OpTraits opTraits = new OpTraits(listBucketCols, -1, listBucketCols, numReduceSinks);
            gbyOp.setOpTraits(opTraits);
            return null;
        }
    }

    public static class TableScanRule
    implements NodeProcessor {
        public boolean checkBucketedTable(Table tbl, ParseContext pGraphContext, PrunedPartitionList prunedParts) throws SemanticException {
            int numBuckets = tbl.getNumBuckets();
            if (numBuckets <= 0) {
                return false;
            }
            if (!HiveConf.getVar(pGraphContext.getConf(), HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                if (tbl.isPartitioned()) {
                    List<Partition> partitions = prunedParts.getNotDeniedPartns();
                    if (!partitions.isEmpty()) {
                        for (Partition p : partitions) {
                            List<String> fileNames = AbstractBucketJoinProc.getBucketFilePathsOfPartition(p.getDataLocation(), pGraphContext);
                            if (fileNames.size() == 0 || fileNames.size() == numBuckets) continue;
                            return false;
                        }
                    }
                } else {
                    List<String> fileNames = AbstractBucketJoinProc.getBucketFilePathsOfPartition(tbl.getDataLocation(), pGraphContext);
                    if (fileNames.size() != 0 && fileNames.size() != numBuckets) {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator ts = (TableScanOperator)nd;
            AnnotateOpTraitsProcCtx opTraitsCtx = (AnnotateOpTraitsProcCtx)procCtx;
            Table table = ((TableScanDesc)ts.getConf()).getTableMetadata();
            PrunedPartitionList prunedPartList = null;
            try {
                prunedPartList = opTraitsCtx.getParseContext().getPrunedPartitions(((TableScanDesc)ts.getConf()).getAlias(), ts);
            }
            catch (HiveException e) {
                prunedPartList = null;
            }
            boolean isBucketed = this.checkBucketedTable(table, opTraitsCtx.getParseContext(), prunedPartList);
            ArrayList<List<String>> bucketColsList = new ArrayList<List<String>>();
            ArrayList<List<String>> sortedColsList = new ArrayList<List<String>>();
            int numBuckets = -1;
            if (isBucketed) {
                bucketColsList.add(table.getBucketCols());
                numBuckets = table.getNumBuckets();
                ArrayList<String> sortCols = new ArrayList<String>();
                for (Order colSortOrder : table.getSortCols()) {
                    sortCols.add(colSortOrder.getCol());
                }
                sortedColsList.add(sortCols);
            }
            OpTraits opTraits = new OpTraits(bucketColsList, numBuckets, sortedColsList, 0);
            ts.setOpTraits(opTraits);
            return null;
        }
    }

    public static class ReduceSinkRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkOperator rs = (ReduceSinkOperator)nd;
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            int numBuckets = -1;
            int numReduceSinks = 1;
            OpTraits parentOpTraits = rs.getParentOperators().get(0).getOpTraits();
            if (parentOpTraits != null) {
                numBuckets = parentOpTraits.getNumBuckets();
                numReduceSinks += parentOpTraits.getNumReduceSinks();
            }
            ArrayList<String> bucketCols = new ArrayList<String>();
            if (parentOpTraits != null && parentOpTraits.getBucketColNames() != null) {
                if (parentOpTraits.getBucketColNames().size() > 0) {
                    for (List list : parentOpTraits.getBucketColNames()) {
                        block1: for (String col : list) {
                            for (Map.Entry<String, ExprNodeDesc> entry : rs.getColumnExprMap().entrySet()) {
                                boolean isKey = false;
                                for (ExprNodeDesc keyDesc : ((ReduceSinkDesc)rs.getConf()).getKeyCols()) {
                                    if (!keyDesc.isSame(entry.getValue())) continue;
                                    isKey = true;
                                    break;
                                }
                                if (!isKey) continue;
                                ArrayListMultimap<Integer, ExprNodeColumnDesc> colMap = ArrayListMultimap.create();
                                boolean found = false;
                                ExprNodeDescUtils.getExprNodeColumnDesc(entry.getValue(), colMap);
                                for (Integer hashCode : colMap.keySet()) {
                                    Collection exprs = colMap.get(hashCode);
                                    for (ExprNodeColumnDesc expr : exprs) {
                                        if (!expr.getColumn().equals(col)) continue;
                                        bucketCols.add(entry.getKey());
                                        found = true;
                                        break;
                                    }
                                    if (!found) continue;
                                    break;
                                }
                                if (!found) continue;
                                continue block1;
                            }
                        }
                    }
                } else {
                    for (ExprNodeDesc exprNodeDesc : ((ReduceSinkDesc)rs.getConf()).getKeyCols()) {
                        for (Map.Entry<String, ExprNodeDesc> entry : rs.getColumnExprMap().entrySet()) {
                            if (!exprNodeDesc.isSame(entry.getValue())) continue;
                            bucketCols.add(entry.getKey());
                        }
                    }
                }
            }
            listBucketCols.add(bucketCols);
            OpTraits opTraits = new OpTraits(listBucketCols, numBuckets, listBucketCols, numReduceSinks);
            rs.setOpTraits(opTraits);
            return null;
        }
    }

    public static class DefaultRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            op.setOpTraits(op.getParentOperators().get(0).getOpTraits());
            return null;
        }
    }
}

