/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.cache.results.CacheUsage;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.table.constraint.ConstraintsUtils;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TableAccessInfo;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.util.DirectionUtils;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.security.alias.AbstractJavaKeyStoreProvider;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSemanticAnalyzer {
    protected static final Logger STATIC_LOG = LoggerFactory.getLogger((String)BaseSemanticAnalyzer.class.getName());
    protected final Hive db;
    protected final HiveConf conf;
    protected final QueryState queryState;
    protected List<Task<?>> rootTasks;
    protected FetchTask fetchTask;
    protected final Logger LOG;
    protected final SessionState.LogHelper console;
    protected CompilationOpContext cContext;
    protected Context ctx;
    protected Map<String, String> idToTableNameMap;
    protected QueryProperties queryProperties;
    ParseContext pCtx = null;
    protected Set<String> userSuppliedFunctions;
    protected Set<FileSinkDesc> acidFileSinks = new HashSet<FileSinkDesc>();
    protected boolean transactionalInQuery;
    protected HiveTxnManager txnManager;
    protected Set<ReadEntity> inputs;
    protected Set<WriteEntity> outputs;
    protected LineageInfo linfo;
    protected TableAccessInfo tableAccessInfo;
    protected ColumnAccessInfo columnAccessInfo;
    protected CacheUsage cacheUsage;
    protected ColumnAccessInfo updateColumnAccessInfo;
    private Boolean autoCommitValue;
    private static final Map<Integer, String> TOKEN_TO_TYPE = new HashMap<Integer, String>();

    public Boolean getAutoCommitValue() {
        return this.autoCommitValue;
    }

    void setAutoCommitValue(Boolean autoCommit) {
        this.autoCommitValue = autoCommit;
    }

    public boolean skipAuthorization() {
        return false;
    }

    public String getCboInfo() {
        return this.ctx.getCboInfo();
    }

    public BaseSemanticAnalyzer(QueryState queryState) throws SemanticException {
        this(queryState, BaseSemanticAnalyzer.createHiveDB(queryState.getConf()));
    }

    public BaseSemanticAnalyzer(QueryState queryState, Hive db) throws SemanticException {
        try {
            this.queryState = queryState;
            this.conf = queryState.getConf();
            this.db = db;
            this.rootTasks = new ArrayList();
            this.LOG = LoggerFactory.getLogger((String)this.getClass().getName());
            this.console = new SessionState.LogHelper(this.LOG);
            this.idToTableNameMap = new HashMap<String, String>();
            this.inputs = new LinkedHashSet<ReadEntity>();
            this.outputs = new LinkedHashSet<WriteEntity>();
            this.txnManager = queryState.getTxnManager();
            this.userSuppliedFunctions = new HashSet<String>();
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    protected static Hive createHiveDB(HiveConf conf) throws SemanticException {
        try {
            return Hive.get(conf);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
    }

    public Map<String, String> getIdToTableNameMap() {
        return this.idToTableNameMap;
    }

    public abstract void analyzeInternal(ASTNode var1) throws SemanticException;

    public void init(boolean clearPartsCache) {
    }

    public void initCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void analyze(ASTNode ast, Context ctx) throws SemanticException {
        this.initCtx(ctx);
        this.init(true);
        this.analyzeInternal(ast);
    }

    public void validate() throws SemanticException {
    }

    public List<Task<? extends Serializable>> getRootTasks() {
        return this.rootTasks;
    }

    public FetchTask getFetchTask() {
        return this.fetchTask;
    }

    public void setFetchTask(FetchTask fetchTask) {
        this.fetchTask = fetchTask;
    }

    protected void reset(boolean clearPartsCache) {
        this.rootTasks = new ArrayList();
    }

    public static String stripQuotes(String val) {
        return PlanUtils.stripQuotes(val);
    }

    public static String charSetString(String charSetName, String charSetString) throws SemanticException {
        try {
            charSetName = charSetName.substring(1);
            if (charSetString.charAt(0) == '\'') {
                return new String(BaseSemanticAnalyzer.unescapeSQLString(charSetString).getBytes(), charSetName);
            }
            assert (charSetString.charAt(0) == '0');
            assert (charSetString.charAt(1) == 'x');
            charSetString = charSetString.substring(2);
            byte[] bArray = new byte[charSetString.length() / 2];
            int j = 0;
            for (int i = 0; i < charSetString.length(); i += 2) {
                int val = Character.digit(charSetString.charAt(i), 16) * 16 + Character.digit(charSetString.charAt(i + 1), 16);
                if (val > 127) {
                    val -= 256;
                }
                bArray[j++] = (byte)val;
            }
            String res = new String(bArray, charSetName);
            return res;
        }
        catch (UnsupportedEncodingException e) {
            throw new SemanticException(e);
        }
    }

    public static String getUnescapedName(ASTNode tableOrColumnNode) throws SemanticException {
        return BaseSemanticAnalyzer.getUnescapedName(tableOrColumnNode, null);
    }

    public static Map.Entry<String, String> getDbTableNamePair(ASTNode tableNameNode) throws SemanticException {
        if (tableNameNode.getType() != 1133 || tableNameNode.getChildCount() != 1 && tableNameNode.getChildCount() != 2) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_NAME.getMsg(tableNameNode));
        }
        if (tableNameNode.getChildCount() == 2) {
            String dbName = BaseSemanticAnalyzer.unescapeIdentifier(tableNameNode.getChild(0).getText());
            String tableName = BaseSemanticAnalyzer.unescapeIdentifier(tableNameNode.getChild(1).getText());
            if (dbName.contains(".") || tableName.contains(".")) {
                throw new SemanticException(ErrorMsg.OBJECTNAME_CONTAINS_DOT.getMsg(tableNameNode));
            }
            return Pair.of(dbName, tableName);
        }
        String tableName = BaseSemanticAnalyzer.unescapeIdentifier(tableNameNode.getChild(0).getText());
        if (tableName.contains(".")) {
            throw new SemanticException(ErrorMsg.OBJECTNAME_CONTAINS_DOT.getMsg(tableNameNode));
        }
        return Pair.of(null, tableName);
    }

    public static String getUnescapedName(ASTNode tableOrColumnNode, String currentDatabase) throws SemanticException {
        int tokenType = tableOrColumnNode.getToken().getType();
        if (tokenType == 1133) {
            Map.Entry<String, String> dbTablePair;
            return TableName.fromString(dbTablePair.getValue(), null, (dbTablePair = BaseSemanticAnalyzer.getDbTableNamePair(tableOrColumnNode)).getKey() == null ? currentDatabase : dbTablePair.getKey()).getNotEmptyDbTable();
        }
        if (tokenType == 395) {
            return BaseSemanticAnalyzer.unescapeSQLString(tableOrColumnNode.getText());
        }
        return BaseSemanticAnalyzer.unescapeIdentifier(tableOrColumnNode.getText());
    }

    public static TableName getQualifiedTableName(ASTNode tabNameNode) throws SemanticException {
        return BaseSemanticAnalyzer.getQualifiedTableName(tabNameNode, null);
    }

    public static TableName getQualifiedTableName(ASTNode tabNameNode, String catalogName) throws SemanticException {
        if (tabNameNode.getType() != 1133 || tabNameNode.getChildCount() != 1 && tabNameNode.getChildCount() != 2) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_NAME.getMsg(tabNameNode));
        }
        if (tabNameNode.getChildCount() == 2) {
            String dbName = BaseSemanticAnalyzer.unescapeIdentifier(tabNameNode.getChild(0).getText());
            String tableName = BaseSemanticAnalyzer.unescapeIdentifier(tabNameNode.getChild(1).getText());
            if (dbName.contains(".") || tableName.contains(".")) {
                throw new SemanticException(ErrorMsg.OBJECTNAME_CONTAINS_DOT.getMsg(tabNameNode));
            }
            return HiveTableName.ofNullable(tableName, dbName);
        }
        String tableName = BaseSemanticAnalyzer.unescapeIdentifier(tabNameNode.getChild(0).getText());
        if (tableName.contains(".")) {
            throw new SemanticException(ErrorMsg.OBJECTNAME_CONTAINS_DOT.getMsg(tabNameNode));
        }
        return HiveTableName.ofNullable(tableName);
    }

    public static String getUnescapedUnqualifiedTableName(ASTNode node) throws SemanticException {
        assert (node.getChildCount() <= 2);
        assert (node.getType() == 1133);
        if (node.getChildCount() == 2) {
            node = (ASTNode)node.getChild(1);
        }
        return BaseSemanticAnalyzer.getUnescapedName(node);
    }

    public static String getTableAlias(ASTNode node) throws SemanticException {
        if (node.getToken().getType() == 1020) {
            return BaseSemanticAnalyzer.unescapeIdentifier(node.getChild(1).getText().toLowerCase());
        }
        if (node.getChildCount() == 1) {
            return BaseSemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)node.getChild(0)).toLowerCase();
        }
        return BaseSemanticAnalyzer.unescapeIdentifier(node.getChild(node.getChildCount() - 1).getText().toLowerCase());
    }

    public static String unescapeIdentifier(String val) {
        if (val == null) {
            return null;
        }
        if (val.charAt(0) == '`' && val.charAt(val.length() - 1) == '`') {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static Map<String, String> getProps(ASTNode prop) {
        LinkedHashMap<String, String> mapProp = new LinkedHashMap<String, String>();
        BaseSemanticAnalyzer.readProps(prop, mapProp);
        return mapProp;
    }

    public static void readProps(ASTNode prop, Map<String, String> mapProp) {
        for (int propChild = 0; propChild < prop.getChildCount(); ++propChild) {
            String key = BaseSemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(0).getText());
            String value = null;
            if (prop.getChild(propChild).getChild(1) != null) {
                value = BaseSemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(1).getText());
            }
            mapProp.put(key, value);
        }
    }

    public static String unescapeSQLString(String b) {
        Character enclosure = null;
        StringBuilder sb = new StringBuilder(b.length());
        for (int i = 0; i < b.length(); ++i) {
            char currentChar = b.charAt(i);
            if (enclosure == null) {
                if (currentChar != '\'' && b.charAt(i) != '\"') continue;
                enclosure = Character.valueOf(currentChar);
                continue;
            }
            if (enclosure.equals(Character.valueOf(currentChar))) {
                enclosure = null;
                continue;
            }
            if (currentChar == '\\' && i + 6 < b.length() && b.charAt(i + 1) == 'u') {
                int code = 0;
                int base = i + 2;
                for (int j = 0; j < 4; ++j) {
                    int digit = Character.digit(b.charAt(j + base), 16);
                    code = (code << 4) + digit;
                }
                sb.append((char)code);
                i += 5;
                continue;
            }
            if (currentChar == '\\' && i + 4 < b.length()) {
                char i1 = b.charAt(i + 1);
                char i2 = b.charAt(i + 2);
                char i3 = b.charAt(i + 3);
                if (i1 >= '0' && i1 <= '1' && i2 >= '0' && i2 <= '7' && i3 >= '0' && i3 <= '7') {
                    byte bVal = (byte)(i3 - 48 + (i2 - 48) * 8 + (i1 - 48) * 8 * 8);
                    byte[] bValArr = new byte[]{bVal};
                    String tmp = new String(bValArr);
                    sb.append(tmp);
                    i += 3;
                    continue;
                }
            }
            if (currentChar == '\\' && i + 2 < b.length()) {
                char n = b.charAt(i + 1);
                switch (n) {
                    case '0': {
                        sb.append("\u0000");
                        break;
                    }
                    case '\'': {
                        sb.append("'");
                        break;
                    }
                    case '\"': {
                        sb.append("\"");
                        break;
                    }
                    case 'b': {
                        sb.append("\b");
                        break;
                    }
                    case 'n': {
                        sb.append("\n");
                        break;
                    }
                    case 'r': {
                        sb.append("\r");
                        break;
                    }
                    case 't': {
                        sb.append("\t");
                        break;
                    }
                    case 'Z': {
                        sb.append("\u001a");
                        break;
                    }
                    case '\\': {
                        sb.append("\\");
                        break;
                    }
                    case '%': {
                        sb.append("\\%");
                        break;
                    }
                    case '_': {
                        sb.append("\\_");
                        break;
                    }
                    default: {
                        sb.append(n);
                    }
                }
                ++i;
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static String escapeSQLString(String b) {
        String result = b;
        block11: for (int i = 0; i < result.length(); ++i) {
            char nextChar;
            char currentChar = result.charAt(i);
            if (currentChar == '\\' && i + 1 < result.length() && ((nextChar = result.charAt(i + 1)) == '%' || nextChar == '_')) {
                ++i;
                continue;
            }
            switch (currentChar) {
                case '\u0000': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\0");
                    ++i;
                    continue block11;
                }
                case '\'': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\'");
                    ++i;
                    continue block11;
                }
                case '\"': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\\"");
                    ++i;
                    continue block11;
                }
                case '\b': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\b");
                    ++i;
                    continue block11;
                }
                case '\n': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\n");
                    ++i;
                    continue block11;
                }
                case '\r': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\r");
                    ++i;
                    continue block11;
                }
                case '\t': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\t");
                    ++i;
                    continue block11;
                }
                case '\\': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\\\");
                    ++i;
                    continue block11;
                }
                case '\u001a': {
                    result = BaseSemanticAnalyzer.spliceString(result, i, "\\Z");
                    ++i;
                    continue block11;
                }
                default: {
                    if (currentChar >= ' ') continue block11;
                    String hex = Integer.toHexString(currentChar);
                    String unicode = "\\u";
                    for (int j = 4; j > hex.length(); --j) {
                        unicode = unicode + '0';
                    }
                    unicode = unicode + hex;
                    result = BaseSemanticAnalyzer.spliceString(result, i, unicode);
                    i += unicode.length() - 1;
                }
            }
        }
        return result;
    }

    private static String spliceString(String str, int i, String replacement) {
        return BaseSemanticAnalyzer.spliceString(str, i, 1, replacement);
    }

    private static String spliceString(String str, int i, int length, String replacement) {
        return str.substring(0, i) + replacement + str.substring(i + length);
    }

    public Set<ReadEntity> getInputs() {
        return this.inputs;
    }

    public Set<WriteEntity> getOutputs() {
        return this.outputs;
    }

    public List<FieldSchema> getResultSchema() {
        return null;
    }

    protected List<FieldSchema> getColumns(ASTNode ast) throws SemanticException {
        return BaseSemanticAnalyzer.getColumns(ast, true, this.conf);
    }

    public static List<FieldSchema> getColumns(ASTNode ast, boolean lowerCase, Configuration conf) throws SemanticException {
        return BaseSemanticAnalyzer.getColumns(ast, lowerCase, null, new ArrayList<SQLPrimaryKey>(), new ArrayList<SQLForeignKey>(), new ArrayList<SQLUniqueConstraint>(), new ArrayList<SQLNotNullConstraint>(), new ArrayList<SQLDefaultConstraint>(), new ArrayList<SQLCheckConstraint>(), conf);
    }

    public static void checkColumnName(String columnName) throws SemanticException {
        if (VirtualColumn.VIRTUAL_COLUMN_NAMES.contains(columnName.toUpperCase())) {
            throw new SemanticException(ErrorMsg.INVALID_COLUMN_NAME.getMsg(columnName));
        }
    }

    public static List<FieldSchema> getColumns(ASTNode ast, boolean lowerCase, TokenRewriteStream tokenRewriteStream, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints, Configuration conf) throws SemanticException {
        ArrayList<FieldSchema> colList = new ArrayList<FieldSchema>();
        Tree parent = ast.getParent();
        block14: for (int i = 0; i < ast.getChildCount(); ++i) {
            FieldSchema col = new FieldSchema();
            ASTNode child = (ASTNode)ast.getChild(i);
            switch (child.getToken().getType()) {
                case 1157: {
                    TableName tName = BaseSemanticAnalyzer.getQualifiedTableName((ASTNode)parent.getChild(0), MetaStoreUtils.getDefaultCatalog(conf));
                    ConstraintsUtils.processUniqueConstraints(tName, child, uniqueConstraints);
                    continue block14;
                }
                case 1004: {
                    if (!primaryKeys.isEmpty()) {
                        throw new SemanticException(ErrorMsg.INVALID_CONSTRAINT.getMsg("Cannot exist more than one primary key definition for the same table"));
                    }
                    TableName tName = BaseSemanticAnalyzer.getQualifiedTableName((ASTNode)parent.getChild(0));
                    ConstraintsUtils.processPrimaryKeys(tName, child, primaryKeys);
                    continue block14;
                }
                case 906: {
                    TableName tName = BaseSemanticAnalyzer.getQualifiedTableName((ASTNode)parent.getChild(0));
                    ConstraintsUtils.processForeignKeys(tName, child, foreignKeys);
                    continue block14;
                }
                case 831: {
                    TableName tName = BaseSemanticAnalyzer.getQualifiedTableName((ASTNode)parent.getChild(0), MetaStoreUtils.getDefaultCatalog(conf));
                    ConstraintsUtils.processCheckConstraints(tName, child, null, checkConstraints, null, tokenRewriteStream);
                    continue block14;
                }
                default: {
                    Tree grandChild = child.getChild(0);
                    if (grandChild != null) {
                        String name = grandChild.getText();
                        if (lowerCase) {
                            name = name.toLowerCase();
                        }
                        BaseSemanticAnalyzer.checkColumnName(name);
                        col.setName(BaseSemanticAnalyzer.unescapeIdentifier(name));
                        ASTNode typeChild = (ASTNode)child.getChild(1);
                        col.setType(BaseSemanticAnalyzer.getTypeStringFromAST(typeChild));
                        ASTNode constraintChild = null;
                        if (child.getChildCount() == 4) {
                            col.setComment(BaseSemanticAnalyzer.unescapeSQLString(child.getChild(2).getText()));
                            constraintChild = (ASTNode)child.getChild(3);
                        } else if (child.getChildCount() == 3 && ((ASTNode)child.getChild(2)).getToken().getType() == 395) {
                            col.setComment(BaseSemanticAnalyzer.unescapeSQLString(child.getChild(2).getText()));
                        } else if (child.getChildCount() == 3) {
                            constraintChild = (ASTNode)child.getChild(2);
                        }
                        if (constraintChild != null) {
                            TableName tName = BaseSemanticAnalyzer.getQualifiedTableName((ASTNode)parent.getChild(0), MetaStoreUtils.getDefaultCatalog(conf));
                            switch (constraintChild.getToken().getType()) {
                                case 831: {
                                    ConstraintsUtils.processCheckConstraints(tName, constraintChild, ImmutableList.of(col.getName()), checkConstraints, typeChild, tokenRewriteStream);
                                    break;
                                }
                                case 866: {
                                    ConstraintsUtils.processDefaultConstraints(tName, constraintChild, ImmutableList.of(col.getName()), defaultConstraints, typeChild, tokenRewriteStream);
                                    break;
                                }
                                case 966: {
                                    ConstraintsUtils.processNotNullConstraints(tName, constraintChild, ImmutableList.of(col.getName()), notNullConstraints);
                                    break;
                                }
                                case 1157: {
                                    ConstraintsUtils.processUniqueConstraints(tName, constraintChild, ImmutableList.of(col.getName()), uniqueConstraints);
                                    break;
                                }
                                case 1004: {
                                    if (!primaryKeys.isEmpty()) {
                                        throw new SemanticException(ErrorMsg.INVALID_CONSTRAINT.getMsg("Cannot exist more than one primary key definition for the same table"));
                                    }
                                    ConstraintsUtils.processPrimaryKeys(tName, constraintChild, ImmutableList.of(col.getName()), primaryKeys);
                                    break;
                                }
                                case 906: {
                                    ConstraintsUtils.processForeignKeys(tName, constraintChild, foreignKeys);
                                    break;
                                }
                                default: {
                                    throw new SemanticException(ErrorMsg.NOT_RECOGNIZED_CONSTRAINT.getMsg(constraintChild.getToken().getText()));
                                }
                            }
                        }
                    }
                    colList.add(col);
                }
            }
        }
        return colList;
    }

    public static List<String> getColumnNames(ASTNode ast) {
        ArrayList<String> colList = new ArrayList<String>();
        int numCh = ast.getChildCount();
        for (int i = 0; i < numCh; ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            colList.add(BaseSemanticAnalyzer.unescapeIdentifier(child.getText()).toLowerCase());
        }
        return colList;
    }

    protected List<Order> getColumnNamesOrder(ASTNode ast) throws SemanticException {
        ArrayList<Order> colList = new ArrayList<Order>();
        int numCh = ast.getChildCount();
        for (int i = 0; i < numCh; ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            int directionCode = DirectionUtils.tokenToCode(child.getToken().getType());
            if ((child = (ASTNode)child.getChild(0)).getToken().getType() != 971 && directionCode == 1) {
                throw new SemanticException("create/alter bucketed table: not supported NULLS LAST for SORTED BY in ASC order");
            }
            if (child.getToken().getType() != 972 && directionCode == 0) {
                throw new SemanticException("create/alter bucketed table: not supported NULLS FIRST for SORTED BY in DESC order");
            }
            colList.add(new Order(BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText()).toLowerCase(), directionCode));
        }
        return colList;
    }

    public static String getTypeStringFromAST(ASTNode typeNode) throws SemanticException {
        switch (typeNode.getType()) {
            case 954: {
                return "array<" + BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)typeNode.getChild(0)) + ">";
            }
            case 958: {
                return "map<" + BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)typeNode.getChild(0)) + "," + BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)typeNode.getChild(1)) + ">";
            }
            case 1096: {
                return BaseSemanticAnalyzer.getStructTypeStringFromAST(typeNode);
            }
            case 1156: {
                return BaseSemanticAnalyzer.getUnionTypeStringFromAST(typeNode);
            }
        }
        return BaseSemanticAnalyzer.getTypeName(typeNode);
    }

    private static String getTypeName(ASTNode node) throws SemanticException {
        String typeName;
        int token = node.getType();
        if (token == 859) {
            throw new SemanticException(ErrorMsg.UNSUPPORTED_TYPE.getMsg());
        }
        switch (token) {
            case 829: {
                CharTypeInfo charTypeInfo = ParseUtils.getCharTypeInfo(node);
                typeName = charTypeInfo.getQualifiedName();
                break;
            }
            case 1169: {
                VarcharTypeInfo varcharTypeInfo = ParseUtils.getVarcharTypeInfo(node);
                typeName = varcharTypeInfo.getQualifiedName();
                break;
            }
            case 1142: {
                HiveConf conf;
                try {
                    conf = Hive.get().getConf();
                }
                catch (HiveException e) {
                    throw new SemanticException(e);
                }
                TimestampLocalTZTypeInfo timestampLocalTZTypeInfo = TypeInfoFactory.getTimestampTZTypeInfo(conf.getLocalTimeZone());
                typeName = timestampLocalTZTypeInfo.getQualifiedName();
                break;
            }
            case 864: {
                DecimalTypeInfo decTypeInfo = ParseUtils.getDecimalTypeTypeInfo(node);
                typeName = decTypeInfo.getQualifiedName();
                break;
            }
            default: {
                typeName = TOKEN_TO_TYPE.get(token);
            }
        }
        return typeName;
    }

    private static String getStructTypeStringFromAST(ASTNode typeNode) throws SemanticException {
        String typeStr = "struct<";
        int children = (typeNode = (ASTNode)typeNode.getChild(0)).getChildCount();
        if (children <= 0) {
            throw new SemanticException("empty struct not allowed.");
        }
        StringBuilder buffer = new StringBuilder(typeStr);
        for (int i = 0; i < children; ++i) {
            ASTNode child = (ASTNode)typeNode.getChild(i);
            buffer.append(BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText())).append(":");
            buffer.append(BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)child.getChild(1)));
            if (i >= children - 1) continue;
            buffer.append(",");
        }
        buffer.append(">");
        return buffer.toString();
    }

    private static String getUnionTypeStringFromAST(ASTNode typeNode) throws SemanticException {
        String typeStr = "uniontype<";
        int children = (typeNode = (ASTNode)typeNode.getChild(0)).getChildCount();
        if (children <= 0) {
            throw new SemanticException("empty union not allowed.");
        }
        StringBuilder buffer = new StringBuilder(typeStr);
        for (int i = 0; i < children; ++i) {
            buffer.append(BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)typeNode.getChild(i)));
            if (i >= children - 1) continue;
            buffer.append(",");
        }
        buffer.append(">");
        typeStr = buffer.toString();
        return typeStr;
    }

    public LineageInfo getLineageInfo() {
        return this.linfo;
    }

    public void setLineageInfo(LineageInfo linfo) {
        this.linfo = linfo;
    }

    public TableAccessInfo getTableAccessInfo() {
        return this.tableAccessInfo;
    }

    public void setTableAccessInfo(TableAccessInfo tableAccessInfo) {
        this.tableAccessInfo = tableAccessInfo;
    }

    public ColumnAccessInfo getColumnAccessInfo() {
        return this.columnAccessInfo;
    }

    public void setColumnAccessInfo(ColumnAccessInfo columnAccessInfo) {
        this.columnAccessInfo = columnAccessInfo;
    }

    public ColumnAccessInfo getUpdateColumnAccessInfo() {
        return this.updateColumnAccessInfo;
    }

    public void setUpdateColumnAccessInfo(ColumnAccessInfo updateColumnAccessInfo) {
        this.updateColumnAccessInfo = updateColumnAccessInfo;
    }

    public Set<String> getUserSuppliedFunctions() {
        return this.userSuppliedFunctions;
    }

    public final boolean isValidPrefixSpec(Table tTable, Map<String, String> spec) throws HiveException {
        List<FieldSchema> partCols = tTable.getPartitionKeys();
        if (partCols == null || partCols.size() == 0) {
            if (spec != null) {
                throw new HiveException("table is not partitioned but partition spec exists: " + spec);
            }
            return true;
        }
        if (spec == null) {
            throw new HiveException("partition spec is not specified");
        }
        Iterator<String> itrPsKeys = spec.keySet().iterator();
        for (FieldSchema fs : partCols) {
            if (!itrPsKeys.hasNext()) break;
            if (itrPsKeys.next().toLowerCase().equals(fs.getName().toLowerCase())) continue;
            BaseSemanticAnalyzer.ErrorPartSpec(spec, partCols);
        }
        if (itrPsKeys.hasNext()) {
            BaseSemanticAnalyzer.ErrorPartSpec(spec, partCols);
        }
        return true;
    }

    private static void ErrorPartSpec(Map<String, String> partSpec, List<FieldSchema> parts) throws SemanticException {
        StringBuilder sb = new StringBuilder("Partition columns in the table schema are: (");
        for (FieldSchema fs : parts) {
            sb.append(fs.getName()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("), while the partitions specified in the query are: (");
        Iterator<String> itrPsKeys = partSpec.keySet().iterator();
        while (itrPsKeys.hasNext()) {
            sb.append(itrPsKeys.next()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(").");
        throw new SemanticException(ErrorMsg.PARTSPEC_DIFFER_FROM_SCHEMA.getMsg(sb.toString()));
    }

    public Hive getDb() {
        return this.db;
    }

    public QueryProperties getQueryProperties() {
        return this.queryProperties;
    }

    public Set<FileSinkDesc> getAcidFileSinks() {
        return this.acidFileSinks;
    }

    public boolean hasTransactionalInQuery() {
        return this.transactionalInQuery;
    }

    protected ListBucketingCtx constructListBucketingCtx(List<String> skewedColNames, List<List<String>> skewedValues, Map<List<String>, String> skewedColValueLocationMaps, boolean isStoredAsSubDirectories) {
        ListBucketingCtx lbCtx = new ListBucketingCtx();
        lbCtx.setSkewedColNames(skewedColNames);
        lbCtx.setSkewedColValues(skewedValues);
        lbCtx.setLbLocationMap(skewedColValueLocationMaps);
        lbCtx.setStoredAsSubDirectories(isStoredAsSubDirectories);
        lbCtx.setDefaultKey("HIVE_DEFAULT_LIST_BUCKETING_KEY");
        lbCtx.setDefaultDirName("HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME");
        return lbCtx;
    }

    protected boolean analyzeStoredAdDirs(ASTNode child) {
        boolean storedAsDirs = false;
        if (child.getChildCount() == 3 && ((ASTNode)child.getChild(2)).getToken().getType() == 1093) {
            storedAsDirs = true;
        }
        return storedAsDirs;
    }

    private static boolean getPartExprNodeDesc(ASTNode astNode, HiveConf conf, Map<ASTNode, ExprNodeDesc> astExprNodeMap) throws SemanticException {
        if (astNode == null) {
            return true;
        }
        if (astNode.getChildren() == null || astNode.getChildren().size() == 0) {
            return astNode.getType() != 1001;
        }
        TypeCheckCtx typeCheckCtx = new TypeCheckCtx(null);
        String defaultPartitionName = HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        boolean result = true;
        for (Node childNode : astNode.getChildren()) {
            ASTNode partVal;
            ASTNode childASTNode = (ASTNode)childNode;
            if (childASTNode.getType() != 1001) {
                result = BaseSemanticAnalyzer.getPartExprNodeDesc(childASTNode, conf, astExprNodeMap) && result;
                continue;
            }
            boolean isDynamicPart = childASTNode.getChildren().size() <= 1;
            boolean bl = result = !isDynamicPart && result;
            if (isDynamicPart || defaultPartitionName.equalsIgnoreCase(BaseSemanticAnalyzer.unescapeSQLString((partVal = (ASTNode)childASTNode.getChildren().get(1)).getText()))) continue;
            astExprNodeMap.put((ASTNode)childASTNode.getChildren().get(0), TypeCheckProcFactory.genExprNode(partVal, typeCheckCtx).get(partVal));
        }
        return result;
    }

    public List<Map<String, String>> getPartitionSpecs(Table tbl, CommonTree ast) throws SemanticException {
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        int childIndex = 0;
        for (childIndex = 0; childIndex < ast.getChildCount(); ++childIndex) {
            ASTNode partSpecNode = (ASTNode)ast.getChild(childIndex);
            if (partSpecNode.getType() != 1000) continue;
            Map<String, String> partSpec = BaseSemanticAnalyzer.getValidatedPartSpec(tbl, partSpecNode, this.conf, false);
            partSpecs.add(partSpec);
        }
        return partSpecs;
    }

    public static Map<String, String> getValidatedPartSpec(Table table, ASTNode astNode, HiveConf conf, boolean shouldBeFull) throws SemanticException {
        Map<String, String> partSpec = BaseSemanticAnalyzer.getPartSpec(astNode);
        if (partSpec != null && !partSpec.isEmpty()) {
            BaseSemanticAnalyzer.validatePartSpec(table, partSpec, astNode, conf, shouldBeFull);
        }
        return partSpec;
    }

    public static Map<String, String> getPartSpec(ASTNode node) throws SemanticException {
        if (node == null) {
            return null;
        }
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTNode child = (ASTNode)node.getChild(i);
            String key = child.getChild(0).getText();
            String val = null;
            if (child.getChildCount() > 1) {
                val = BaseSemanticAnalyzer.stripQuotes(child.getChild(1).getText());
            }
            partSpec.put(key.toLowerCase(), val);
        }
        return partSpec;
    }

    public static void validatePartSpec(Table tbl, Map<String, String> partSpec, ASTNode astNode, HiveConf conf, boolean shouldBeFull) throws SemanticException {
        tbl.validatePartColumnNames(partSpec, shouldBeFull);
        BaseSemanticAnalyzer.validatePartColumnType(tbl, partSpec, astNode, conf);
    }

    public static void validatePartColumnType(Table tbl, Map<String, String> partSpec, ASTNode astNode, HiveConf conf) throws SemanticException {
        if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_TYPE_CHECK_ON_INSERT)) {
            return;
        }
        HashMap<ASTNode, ExprNodeDesc> astExprNodeMap = new HashMap<ASTNode, ExprNodeDesc>();
        if (!BaseSemanticAnalyzer.getPartExprNodeDesc(astNode, conf, astExprNodeMap)) {
            STATIC_LOG.warn("Dynamic partitioning is used; only validating " + astExprNodeMap.size() + " columns");
        }
        if (astExprNodeMap.isEmpty()) {
            return;
        }
        List<FieldSchema> parts = tbl.getPartitionKeys();
        HashMap<String, String> partCols = new HashMap<String, String>(parts.size());
        for (FieldSchema fieldSchema : parts) {
            partCols.put(fieldSchema.getName(), fieldSchema.getType().toLowerCase());
        }
        for (Map.Entry entry : astExprNodeMap.entrySet()) {
            Object value;
            String astKeyName = ((ASTNode)entry.getKey()).toString().toLowerCase();
            if (((ASTNode)entry.getKey()).getType() == 24) {
                astKeyName = ParseUtils.stripIdentifierQuotes(astKeyName);
            }
            String colType = (String)partCols.get(astKeyName);
            ObjectInspector inputOI = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(((ExprNodeDesc)entry.getValue()).getTypeInfo());
            TypeInfo expectedType = TypeInfoUtils.getTypeInfoFromTypeString(colType);
            ObjectInspector outputOI = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(expectedType);
            Object convertedValue = value = ((ExprNodeConstantDesc)entry.getValue()).getValue();
            if (!inputOI.getTypeName().equals(outputOI.getTypeName())) {
                convertedValue = ObjectInspectorConverters.getConverter(inputOI, outputOI).convert(value);
                if (convertedValue == null) {
                    throw new SemanticException(ErrorMsg.PARTITION_SPEC_TYPE_MISMATCH, astKeyName, inputOI.getTypeName(), outputOI.getTypeName());
                }
                if (!convertedValue.toString().equals(value.toString())) {
                    STATIC_LOG.warn("Partition " + astKeyName + " expects type " + outputOI.getTypeName() + " but input value is in type " + inputOI.getTypeName() + ". Convert " + value.toString() + " to " + convertedValue.toString());
                }
            }
            if (!convertedValue.toString().equals(partSpec.get(astKeyName))) {
                STATIC_LOG.warn("Partition Spec " + astKeyName + "=" + partSpec.get(astKeyName) + " has been changed to " + astKeyName + "=" + convertedValue.toString());
            }
            partSpec.put(astKeyName, convertedValue.toString());
        }
    }

    @VisibleForTesting
    static void normalizeColSpec(Map<String, String> partSpec, String colName, String colType, String originalColSpec, Object colValue) throws SemanticException {
        if (colValue == null) {
            return;
        }
        String normalizedColSpec = originalColSpec;
        if (colType.equals("date")) {
            normalizedColSpec = BaseSemanticAnalyzer.normalizeDateCol(colValue);
        }
        if (!normalizedColSpec.equals(originalColSpec)) {
            STATIC_LOG.warn("Normalizing partition spec - " + colName + " from " + originalColSpec + " to " + normalizedColSpec);
            partSpec.put(colName, normalizedColSpec);
        }
    }

    private static String normalizeDateCol(Object colValue) throws SemanticException {
        Date value;
        if (colValue instanceof DateWritableV2) {
            value = ((DateWritableV2)colValue).get();
        } else if (colValue instanceof Date) {
            value = (Date)colValue;
        } else {
            throw new SemanticException("Unexpected date type " + colValue.getClass());
        }
        try {
            return MetaStoreUtils.PARTITION_DATE_FORMAT.get().format(MetaStoreUtils.PARTITION_DATE_FORMAT.get().parse(value.toString()));
        }
        catch (ParseException e) {
            throw new SemanticException(e);
        }
    }

    protected WriteEntity toWriteEntity(String location) throws SemanticException {
        return this.toWriteEntity(new Path(location));
    }

    protected WriteEntity toWriteEntity(Path location) throws SemanticException {
        return BaseSemanticAnalyzer.toWriteEntity(location, this.conf);
    }

    public static WriteEntity toWriteEntity(Path location, HiveConf conf) throws SemanticException {
        try {
            Path path = BaseSemanticAnalyzer.tryQualifyPath(location, conf);
            return new WriteEntity(path, FileUtils.isLocalFile(conf, path.toUri()));
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    protected ReadEntity toReadEntity(String location) throws SemanticException {
        return this.toReadEntity(new Path(location));
    }

    protected ReadEntity toReadEntity(Path location) throws SemanticException {
        return BaseSemanticAnalyzer.toReadEntity(location, this.conf);
    }

    public static ReadEntity toReadEntity(Path location, HiveConf conf) throws SemanticException {
        try {
            Path path = BaseSemanticAnalyzer.tryQualifyPath(location, conf);
            return new ReadEntity(path, FileUtils.isLocalFile(conf, path.toUri()));
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    public static Path tryQualifyPath(Path path, HiveConf conf) throws IOException {
        try {
            return path.getFileSystem((Configuration)conf).makeQualified(path);
        }
        catch (IOException e) {
            return path;
        }
    }

    protected Database getDatabase(String dbName) throws SemanticException {
        return this.getDatabase(dbName, true);
    }

    protected Database getDatabase(String dbName, boolean throwException) throws SemanticException {
        Database database;
        try {
            database = this.db.getDatabase(dbName);
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage(), e);
        }
        if (database == null && throwException) {
            throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(dbName));
        }
        return database;
    }

    protected Table getTable(TableName tn) throws SemanticException {
        return this.getTable(tn, true);
    }

    protected Table getTable(TableName tn, boolean throwException) throws SemanticException {
        return this.getTable(tn.getDb(), tn.getTable(), throwException);
    }

    protected Table getTable(String tblName) throws SemanticException {
        return this.getTable(null, tblName, true);
    }

    protected Table getTable(String tblName, boolean throwException) throws SemanticException {
        return this.getTable(null, tblName, throwException);
    }

    protected Table getTable(String database, String tblName, boolean throwException) throws SemanticException {
        Table tab;
        try {
            tab = database == null ? this.db.getTable(tblName, false) : this.db.getTable(database, tblName, false);
        }
        catch (InvalidTableException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(TableName.fromString(tblName, null, database).getNotEmptyDbTable()), e);
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage(), e);
        }
        if (tab == null && throwException) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(TableName.fromString(tblName, null, database).getNotEmptyDbTable()));
        }
        return tab;
    }

    public List<Task<?>> getAllRootTasks() {
        return this.rootTasks;
    }

    public Set<ReadEntity> getAllInputs() {
        return this.inputs;
    }

    public Set<WriteEntity> getAllOutputs() {
        return this.outputs;
    }

    public QueryState getQueryState() {
        return this.queryState;
    }

    protected FetchTask createFetchTask(String tableSchema) {
        String schema = "json".equals(this.conf.get(HiveConf.ConfVars.HIVE_DDL_OUTPUT_FORMAT.varname, "text")) ? "json#string" : tableSchema;
        Properties prop = new Properties();
        prop.setProperty("serialization.format", Integer.toString(9));
        prop.setProperty("serialization.null.format", " ");
        String[] colTypes = schema.split("#");
        prop.setProperty("columns", colTypes[0]);
        prop.setProperty("columns.types", colTypes[1]);
        prop.setProperty("serialization.lib", LazySimpleSerDe.class.getName());
        prop.setProperty("bucketing_version", "-1");
        FetchWork fetch = new FetchWork(this.ctx.getResFile(), new TableDesc(TextInputFormat.class, IgnoreKeyTextOutputFormat.class, prop), -1);
        fetch.setSerializationNullFormat(" ");
        return (FetchTask)TaskFactory.get(fetch);
    }

    protected HiveTxnManager getTxnMgr() {
        if (this.txnManager != null) {
            return this.txnManager;
        }
        return SessionState.get().getTxnMgr();
    }

    public CacheUsage getCacheUsage() {
        return this.cacheUsage;
    }

    public void setCacheUsage(CacheUsage cacheUsage) {
        this.cacheUsage = cacheUsage;
    }

    public DDLDesc.DDLDescWithWriteId getAcidDdlDesc() {
        return null;
    }

    public WriteEntity getAcidAnalyzeTable() {
        return null;
    }

    public void addPropertyReadEntry(Map<String, String> tblProps, Set<ReadEntity> inputs) throws SemanticException {
        if (tblProps.containsKey("hive.sql.dbcp.password.keystore")) {
            try {
                String keystore = tblProps.get("hive.sql.dbcp.password.keystore");
                Configuration conf = new Configuration();
                conf.set("hadoop.security.credential.provider.path", keystore);
                boolean found = false;
                for (CredentialProvider provider : CredentialProviderFactory.getProviders((Configuration)conf)) {
                    if (!(provider instanceof AbstractJavaKeyStoreProvider)) continue;
                    Path path = ((AbstractJavaKeyStoreProvider)provider).getPath();
                    inputs.add(this.toReadEntity(path));
                    found = true;
                }
                if (!found) {
                    throw new SemanticException("Cannot recognize keystore " + keystore + ", only JavaKeyStoreProvider is supported");
                }
            }
            catch (IOException e) {
                throw new SemanticException(e);
            }
        }
    }

    protected void executeUnparseTranlations() {
        UnparseTranslator unparseTranslator = new UnparseTranslator(this.conf);
        unparseTranslator.applyTranslations(this.ctx.getTokenRewriteStream());
    }

    public ParseContext getParseContext() {
        return this.pCtx;
    }

    static {
        TOKEN_TO_TYPE.put(826, "boolean");
        TOKEN_TO_TYPE.put(1144, "tinyint");
        TOKEN_TO_TYPE.put(1089, "smallint");
        TOKEN_TO_TYPE.put(928, "int");
        TOKEN_TO_TYPE.put(823, "bigint");
        TOKEN_TO_TYPE.put(904, "float");
        TOKEN_TO_TYPE.put(877, "double");
        TOKEN_TO_TYPE.put(1094, "string");
        TOKEN_TO_TYPE.put(829, "char");
        TOKEN_TO_TYPE.put(1169, "varchar");
        TOKEN_TO_TYPE.put(824, "binary");
        TOKEN_TO_TYPE.put(857, "date");
        TOKEN_TO_TYPE.put(859, "datetime");
        TOKEN_TO_TYPE.put(1140, "timestamp");
        TOKEN_TO_TYPE.put(1142, "timestamp with local time zone");
        TOKEN_TO_TYPE.put(939, "interval_year_month");
        TOKEN_TO_TYPE.put(932, "interval_day_time");
        TOKEN_TO_TYPE.put(864, "decimal");
    }

    public static class AnalyzeRewriteContext {
        private String tableName;
        private List<String> colName;
        private List<String> colType;
        private boolean tblLvl;

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public List<String> getColName() {
            return this.colName;
        }

        public void setColName(List<String> colName) {
            this.colName = colName;
        }

        public boolean isTblLvl() {
            return this.tblLvl;
        }

        public void setTblLvl(boolean isTblLvl) {
            this.tblLvl = isTblLvl;
        }

        public List<String> getColType() {
            return this.colType;
        }

        public void setColType(List<String> colType) {
            this.colType = colType;
        }
    }

    public static class TableSpec {
        private TableName tableName;
        public Table tableHandle;
        public Map<String, String> partSpec;
        public Partition partHandle;
        public int numDynParts;
        public List<Partition> partitions;
        public SpecType specType;

        public TableSpec(Hive db, HiveConf conf, ASTNode ast) throws SemanticException {
            this(db, conf, ast, true, false);
        }

        public TableSpec(Table table) {
            this.tableHandle = table;
            this.tableName = TableName.fromString(table.getTableName(), SessionState.get().getCurrentCatalog(), table.getDbName());
            this.specType = SpecType.TABLE_ONLY;
        }

        public TableSpec(Hive db, TableName tableName, Map<String, String> partSpec) throws HiveException {
            this(db, tableName.getNotEmptyDbTable(), partSpec, false);
        }

        public TableSpec(Hive db, String tableName, Map<String, String> partSpec, boolean allowPartialPartitionsSpec) throws HiveException {
            Table table;
            this.tableHandle = table = db.getTable(tableName);
            this.tableName = TableName.fromString(table.getTableName(), SessionState.get().getCurrentCatalog(), table.getDbName());
            if (partSpec == null) {
                this.specType = SpecType.TABLE_ONLY;
            } else if (allowPartialPartitionsSpec) {
                this.partitions = db.getPartitions(table, partSpec);
                this.specType = SpecType.STATIC_PARTITION;
            } else {
                Partition partition = db.getPartition(table, partSpec, false);
                if (partition == null) {
                    throw new SemanticException("partition is unknown: " + table + "/" + partSpec);
                }
                this.partHandle = partition;
                this.partitions = Collections.singletonList(this.partHandle);
                this.specType = SpecType.STATIC_PARTITION;
            }
        }

        public TableSpec(Table tableHandle, List<Partition> partitions) throws HiveException {
            this.tableHandle = tableHandle;
            this.tableName = TableName.fromString(tableHandle.getTableName(), tableHandle.getCatalogName(), tableHandle.getDbName());
            if (partitions != null && !partitions.isEmpty()) {
                this.specType = SpecType.STATIC_PARTITION;
                this.partitions = partitions;
                List<FieldSchema> partCols = this.tableHandle.getPartCols();
                this.partSpec = new LinkedHashMap<String, String>();
                for (FieldSchema partCol : partCols) {
                    this.partSpec.put(partCol.getName(), null);
                }
            } else {
                this.specType = SpecType.TABLE_ONLY;
            }
        }

        private boolean createDynPartSpec(ASTNode ast) {
            return ast.getToken().getType() != 841 && ast.getToken().getType() != 844 && ast.getToken().getType() != 806 && this.tableHandle.getPartitionKeys().size() > 0 && (ast.getParent() != null && (ast.getParent().getType() == 927 || ast.getParent().getType() == 926) || ast.getParent().getType() == 872 || ast.getParent().getType() == 821);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public TableSpec(Hive db, HiveConf conf, ASTNode ast, boolean allowDynamicPartitionsSpec, boolean allowPartialPartitionsSpec) throws SemanticException {
            assert (ast.getToken().getType() == 1104 || ast.getToken().getType() == 1131 || ast.getToken().getType() == 1138 || ast.getToken().getType() == 841 || ast.getToken().getType() == 844);
            int childIndex = 0;
            this.numDynParts = 0;
            try {
                this.tableName = HiveTableName.withNoDefault(BaseSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0)));
                boolean testMode = conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE);
                if (testMode) {
                    this.tableName = TableName.fromString(String.join((CharSequence)"", conf.getVar(HiveConf.ConfVars.HIVETESTMODEPREFIX), this.tableName.getTable()), this.tableName.getCat(), this.tableName.getDb());
                }
                if (ast.getToken().getType() != 841 && ast.getToken().getType() != 844 && ast.getToken().getType() != 806) {
                    this.tableHandle = db.getTable(this.tableName);
                }
            }
            catch (InvalidTableException ite) {
                throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(ast.getChild(0)), ite);
            }
            catch (HiveException e) {
                throw new SemanticException(ErrorMsg.CANNOT_RETRIEVE_TABLE_METADATA.getMsg(ast.getChild(childIndex), e.getMessage()), e);
            }
            if (ast.getChildCount() == 2 && ast.getToken().getType() != 841 && ast.getToken().getType() != 844 && ast.getToken().getType() != 806) {
                childIndex = 1;
                ASTNode partspec = (ASTNode)ast.getChild(1);
                this.partitions = new ArrayList<Partition>();
                HashMap<String, String> tmpPartSpec = new HashMap<String, String>(partspec.getChildCount());
                for (int i = 0; i < partspec.getChildCount(); ++i) {
                    ASTNode partspec_val = (ASTNode)partspec.getChild(i);
                    String val = null;
                    String colName = BaseSemanticAnalyzer.unescapeIdentifier(partspec_val.getChild(0).getText().toLowerCase());
                    if (partspec_val.getChildCount() < 2) {
                        if (!allowDynamicPartitionsSpec) throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(" - Dynamic partitions not allowed"));
                        ++this.numDynParts;
                    } else {
                        val = BaseSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
                    }
                    tmpPartSpec.put(colName, val);
                }
                BaseSemanticAnalyzer.validatePartSpec(this.tableHandle, tmpPartSpec, ast, conf, false);
                List<FieldSchema> parts = this.tableHandle.getPartitionKeys();
                this.partSpec = new LinkedHashMap<String, String>(partspec.getChildCount());
                for (FieldSchema fs : parts) {
                    String partKey = fs.getName();
                    this.partSpec.put(partKey, (String)tmpPartSpec.get(partKey));
                }
                if (this.numDynParts > 0) {
                    int numStaPart = parts.size() - this.numDynParts;
                    if (numStaPart == 0 && conf.getVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE).equalsIgnoreCase("strict")) {
                        throw new SemanticException(ErrorMsg.DYNAMIC_PARTITION_STRICT_MODE.getMsg());
                    }
                    if (this.partSpec.keySet().size() != parts.size()) {
                        BaseSemanticAnalyzer.ErrorPartSpec(this.partSpec, parts);
                    }
                    Iterator<String> itrPsKeys = this.partSpec.keySet().iterator();
                    for (FieldSchema fs : parts) {
                        if (itrPsKeys.next().toLowerCase().equals(fs.getName().toLowerCase())) continue;
                        BaseSemanticAnalyzer.ErrorPartSpec(this.partSpec, parts);
                    }
                    for (FieldSchema fs : parts) {
                        if (this.partSpec.get(fs.getName().toLowerCase()) == null) {
                            if (numStaPart <= 0) break;
                            throw new SemanticException(ErrorMsg.PARTITION_DYN_STA_ORDER.getMsg(ast.getChild(childIndex)));
                        }
                        --numStaPart;
                    }
                    this.partHandle = null;
                    this.specType = SpecType.DYNAMIC_PARTITION;
                    return;
                }
                try {
                    if (allowPartialPartitionsSpec) {
                        this.partitions = db.getPartitions(this.tableHandle, this.partSpec);
                    } else {
                        this.partHandle = db.getPartition(this.tableHandle, this.partSpec, false);
                        if (this.partHandle == null) {
                            this.partHandle = new Partition(this.tableHandle, this.partSpec, null);
                        } else {
                            this.partitions.add(this.partHandle);
                        }
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(ast.getChild(childIndex)), e);
                }
                this.specType = SpecType.STATIC_PARTITION;
                return;
            }
            if (this.createDynPartSpec(ast) && allowDynamicPartitionsSpec) {
                List<FieldSchema> parts = this.tableHandle.getPartitionKeys();
                this.partSpec = new LinkedHashMap<String, String>(parts.size());
                for (FieldSchema fs : parts) {
                    String partKey = fs.getName();
                    this.partSpec.put(partKey, null);
                }
                this.partHandle = null;
                this.specType = SpecType.DYNAMIC_PARTITION;
                return;
            } else {
                this.specType = SpecType.TABLE_ONLY;
            }
        }

        public TableName getTableName() {
            return this.tableName;
        }

        public void setTableName(TableName tableName) {
            this.tableName = tableName;
        }

        public Map<String, String> getPartSpec() {
            return this.partSpec;
        }

        public void setPartSpec(Map<String, String> partSpec) {
            this.partSpec = partSpec;
        }

        public String toString() {
            if (this.partHandle != null) {
                return this.partHandle.toString();
            }
            return this.tableHandle.toString();
        }

        public static enum SpecType {
            TABLE_ONLY,
            STATIC_PARTITION,
            DYNAMIC_PARTITION;

        }
    }

    class RowFormatParams {
        String fieldDelim = null;
        String fieldEscape = null;
        String collItemDelim = null;
        String mapKeyDelim = null;
        String lineDelim = null;
        String nullFormat = null;

        RowFormatParams() {
        }

        protected void analyzeRowFormat(ASTNode child) throws SemanticException {
            child = (ASTNode)child.getChild(0);
            int numChildRowFormat = child.getChildCount();
            block7: for (int numC = 0; numC < numChildRowFormat; ++numC) {
                ASTNode rowChild = (ASTNode)child.getChild(numC);
                switch (rowChild.getToken().getType()) {
                    case 1123: {
                        this.fieldDelim = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        if (rowChild.getChildCount() < 2) continue block7;
                        this.fieldEscape = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(1).getText());
                        continue block7;
                    }
                    case 1122: {
                        this.collItemDelim = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        continue block7;
                    }
                    case 1125: {
                        this.mapKeyDelim = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        continue block7;
                    }
                    case 1124: {
                        this.lineDelim = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        if (this.lineDelim.equals("\n") || this.lineDelim.equals("10")) continue block7;
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(rowChild, ErrorMsg.LINES_TERMINATED_BY_NON_NEWLINE.getMsg()));
                    }
                    case 1126: {
                        this.nullFormat = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        continue block7;
                    }
                    default: {
                        throw new AssertionError((Object)("Unkown Token: " + rowChild));
                    }
                }
            }
        }
    }
}

