/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.repl.util.StringConvertibleObject;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.DBSerializer;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.JsonWriter;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.ReplicationSpecSerializer;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.TableSerializer;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.MetadataJson;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.thrift.TException;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EximUtil {
    public static final String METADATA_NAME = "_metadata";
    public static final String FILES_NAME = "_files";
    public static final String FILE_LIST = "_file_list";
    public static final String FILE_LIST_EXTERNAL = "_file_list_external";
    public static final String DATA_PATH_NAME = "data";
    public static final String METADATA_PATH_NAME = "metadata";
    private static final Logger LOG = LoggerFactory.getLogger(EximUtil.class);
    private static final String DATABASE_PATH_SUFFIX = ".db";
    public static final String METADATA_FORMAT_VERSION = "0.2";
    public static final String METADATA_FORMAT_FORWARD_COMPATIBLE_VERSION = null;

    private EximUtil() {
    }

    public static URI getValidatedURI(HiveConf conf, String dcPath) throws SemanticException {
        try {
            boolean testMode = conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE) || conf.getBoolVar(HiveConf.ConfVars.HIVEEXIMTESTMODE);
            URI uri = new Path(dcPath).toUri();
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
            String scheme = fs.getScheme();
            String authority = uri.getAuthority();
            String path = uri.getPath();
            LOG.info("Path before norm :" + path);
            if (!path.startsWith("/")) {
                path = testMode ? new Path(System.getProperty("test.tmp.dir"), path).toUri().getPath() : new Path(new Path("/user/" + System.getProperty("user.name")), path).toUri().getPath();
            }
            if (StringUtils.isEmpty(authority)) {
                URI defaultURI = FileSystem.get((Configuration)conf).getUri();
                authority = defaultURI.getAuthority();
            }
            LOG.info("Scheme:" + scheme + ", authority:" + authority + ", path:" + path);
            Collection eximSchemes = conf.getStringCollection(HiveConf.ConfVars.HIVE_EXIM_URI_SCHEME_WL.varname);
            if (!eximSchemes.contains(scheme)) {
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg("only the following file systems accepted for export/import : " + conf.get(HiveConf.ConfVars.HIVE_EXIM_URI_SCHEME_WL.varname)));
            }
            try {
                return new URI(scheme, authority, path, null, null);
            }
            catch (URISyntaxException e) {
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
            }
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.IO_ERROR.getMsg() + ": " + e.getMessage(), e);
        }
    }

    static void validateTable(Table table) throws SemanticException {
        if (table.isNonNative()) {
            throw new SemanticException(ErrorMsg.EXIM_FOR_NON_NATIVE.getMsg());
        }
    }

    public static String relativeToAbsolutePath(HiveConf conf, String location) throws SemanticException {
        try {
            boolean testMode;
            boolean bl = testMode = conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE) || conf.getBoolVar(HiveConf.ConfVars.HIVEEXIMTESTMODE);
            if (testMode) {
                URI uri = new Path(location).toUri();
                FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
                String scheme = fs.getScheme();
                String authority = uri.getAuthority();
                String path = uri.getPath();
                if (!path.startsWith("/")) {
                    path = new Path(System.getProperty("test.tmp.dir"), path).toUri().getPath();
                }
                if (StringUtils.isEmpty(scheme)) {
                    scheme = "pfile";
                }
                try {
                    uri = new URI(scheme, authority, path, null, null);
                }
                catch (URISyntaxException e) {
                    throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
                }
                return uri.toString();
            }
            return location;
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.IO_ERROR.getMsg() + ": " + e.getMessage(), e);
        }
    }

    public static void createDbExportDump(FileSystem fs, Path metadataPath, Database dbObj, ReplicationSpec replicationSpec, Configuration conf) throws IOException, SemanticException {
        EximUtil.updateIfCustomDbLocations(dbObj, conf);
        Map<String, String> parameters = dbObj.getParameters();
        if (parameters != null) {
            HashMap<String, String> tmpParameters = new HashMap<String, String>(parameters);
            tmpParameters.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("bootstrap.dump.state.") || ((String)e.getKey()).equals("hive.repl.ckpt.key") || ((String)e.getKey()).equals("repl.source.for") || ((String)e.getKey()).equals("hive.repl.first.inc.pending"));
            dbObj.setParameters(tmpParameters);
        }
        try (JsonWriter jsonWriter = new JsonWriter(fs, metadataPath);){
            new DBSerializer(dbObj).writeTo(jsonWriter, replicationSpec);
        }
        if (parameters != null) {
            dbObj.setParameters(parameters);
        }
    }

    private static void updateIfCustomDbLocations(Database database, Configuration conf) throws SemanticException {
        try {
            String whLocatoion = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.WAREHOUSE_EXTERNAL, MetastoreConf.getVar(conf, MetastoreConf.ConfVars.WAREHOUSE));
            Path dbDerivedLoc = new Path(whLocatoion, database.getName().toLowerCase() + DATABASE_PATH_SUFFIX);
            String defaultDbLoc = Utilities.getQualifiedPath((HiveConf)conf, dbDerivedLoc);
            database.putToParameters("hive.repl.is.custom.db.loc", Boolean.toString(!defaultDbLoc.equals(database.getLocationUri())));
            String whManagedLocatoion = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.WAREHOUSE);
            Path dbDerivedManagedLoc = new Path(whManagedLocatoion, database.getName().toLowerCase() + DATABASE_PATH_SUFFIX);
            String defaultDbManagedLoc = Utilities.getQualifiedPath((HiveConf)conf, dbDerivedManagedLoc);
            database.getParameters().put("hive.repl.is.custom.db.managedloc", Boolean.toString(database.getManagedLocationUri() != null && !defaultDbManagedLoc.equals(database.getManagedLocationUri())));
        }
        catch (HiveException ex) {
            throw new SemanticException(ex);
        }
    }

    public static void createExportDump(FileSystem fs, Path metadataPath, Table tableHandle, Iterable<Partition> partitions, ReplicationSpec replicationSpec, HiveConf hiveConf) throws SemanticException, IOException {
        if (replicationSpec == null) {
            replicationSpec = new ReplicationSpec();
        }
        if (tableHandle == null) {
            replicationSpec.setNoop(true);
        }
        try (JsonWriter writer = new JsonWriter(fs, metadataPath);){
            if (replicationSpec.isInReplicationScope()) {
                new ReplicationSpecSerializer().writeTo(writer, replicationSpec);
            }
            new TableSerializer(tableHandle, partitions, hiveConf).writeTo(writer, replicationSpec);
        }
    }

    public static MetaData getMetaDataFromLocation(String fromLocn, HiveConf conf) throws SemanticException, IOException {
        URI fromURI = EximUtil.getValidatedURI(conf, PlanUtils.stripQuotes(fromLocn));
        Path fromPath = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
        FileSystem fs = FileSystem.get((URI)fromURI, (Configuration)conf);
        try {
            return EximUtil.readMetaData(fs, new Path(fromPath, METADATA_NAME));
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
        }
    }

    public static MetaData readMetaData(FileSystem fs, Path metadataPath) throws IOException, SemanticException {
        String message = EximUtil.readAsString(fs, metadataPath);
        try {
            return new MetadataJson(message).getMetaData();
        }
        catch (TException | JSONException e) {
            throw new SemanticException(ErrorMsg.ERROR_SERIALIZE_METADATA.getMsg(), e);
        }
    }

    public static String readAsString(FileSystem fs, Path fromMetadataPath) throws IOException {
        try (FSDataInputStream stream = fs.open(fromMetadataPath);){
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream sb = new ByteArrayOutputStream();
            int read = stream.read(buffer);
            while (read != -1) {
                sb.write(buffer, 0, read);
                read = stream.read(buffer);
            }
            String string = new String(sb.toByteArray(), "UTF-8");
            return string;
        }
    }

    public static void doCheckCompatibility(String currVersion, String version, String fcVersion) throws SemanticException {
        if (version == null) {
            throw new SemanticException(ErrorMsg.INVALID_METADATA.getMsg("Version number missing"));
        }
        StringTokenizer st = new StringTokenizer(version, ".");
        int data_major = Integer.parseInt(st.nextToken());
        StringTokenizer st2 = new StringTokenizer(currVersion, ".");
        int code_major = Integer.parseInt(st2.nextToken());
        int code_minor = Integer.parseInt(st2.nextToken());
        if (code_major > data_major) {
            throw new SemanticException(ErrorMsg.INVALID_METADATA.getMsg("Not backward compatible. Producer version " + version + ", Consumer version " + currVersion));
        }
        if (fcVersion == null || fcVersion.isEmpty()) {
            if (code_major < data_major) {
                throw new SemanticException(ErrorMsg.INVALID_METADATA.getMsg("Not forward compatible.Producer version " + version + ", Consumer version " + currVersion));
            }
        } else {
            StringTokenizer st3 = new StringTokenizer(fcVersion, ".");
            int fc_major = Integer.parseInt(st3.nextToken());
            int fc_minor = Integer.parseInt(st3.nextToken());
            if (fc_major > code_major || fc_major == code_major && fc_minor > code_minor) {
                throw new SemanticException(ErrorMsg.INVALID_METADATA.getMsg("Not forward compatible.Minimum version " + fcVersion + ", Consumer version " + currVersion));
            }
        }
    }

    public static Map<String, String> makePartSpec(List<FieldSchema> partCols, List<String> partVals) {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < partCols.size(); ++i) {
            partSpec.put(partCols.get(i).getName(), partVals.get(i));
        }
        return partSpec;
    }

    public static boolean schemaCompare(List<FieldSchema> newSchema, List<FieldSchema> oldSchema) {
        Iterator<FieldSchema> newColIter = newSchema.iterator();
        for (FieldSchema oldCol : oldSchema) {
            FieldSchema newCol = null;
            if (!newColIter.hasNext()) {
                return false;
            }
            newCol = newColIter.next();
            if (oldCol.getName().equals(newCol.getName()) && oldCol.getType().equals(newCol.getType())) continue;
            return false;
        }
        return !newColIter.hasNext();
    }

    public static PathFilter getDirectoryFilter(final FileSystem fs) {
        return new PathFilter(){

            public boolean accept(Path p) {
                try {
                    return fs.isDirectory(p);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static class DataCopyPath
    implements StringConvertibleObject {
        private static final String URI_SEPARATOR = "#";
        private ReplicationSpec replicationSpec;
        private static boolean nullSrcPathForTest = false;
        private Path srcPath;
        private Path tgtPath;

        public DataCopyPath(ReplicationSpec replicationSpec) {
            this.replicationSpec = replicationSpec;
        }

        public DataCopyPath(ReplicationSpec replicationSpec, Path srcPath, Path tgtPath) {
            this.replicationSpec = replicationSpec;
            if (srcPath == null) {
                throw new IllegalArgumentException("Source path can not be null.");
            }
            this.srcPath = srcPath;
            if (tgtPath == null) {
                throw new IllegalArgumentException("Target path can not be null.");
            }
            this.tgtPath = tgtPath;
        }

        public Path getSrcPath() {
            if (nullSrcPathForTest) {
                return null;
            }
            return this.srcPath;
        }

        public Path getTargetPath() {
            return this.tgtPath;
        }

        public String toString() {
            return "DataCopyPath{fullyQualifiedSourcePath=" + this.srcPath + ", fullyQualifiedTargetPath=" + this.tgtPath + '}';
        }

        public ReplicationSpec getReplicationSpec() {
            return this.replicationSpec;
        }

        public void setReplicationSpec(ReplicationSpec replicationSpec) {
            this.replicationSpec = replicationSpec;
        }

        public static void setNullSrcPath(HiveConf conf, boolean aNullSrcPath) {
            if (conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
                nullSrcPathForTest = aNullSrcPath;
            }
        }

        @Override
        public String convertToString() {
            StringBuilder objInStr = new StringBuilder();
            objInStr.append(this.srcPath).append(URI_SEPARATOR).append(this.tgtPath);
            return objInStr.toString();
        }

        @Override
        public void loadFromString(String objectInStr) {
            String[] paths = objectInStr.split(URI_SEPARATOR);
            this.srcPath = new Path(paths[0]);
            this.tgtPath = new Path(paths[1]);
        }

        private String getEmptyOrString(String str) {
            return str == null ? "" : str;
        }
    }

    public static class SemanticAnalyzerWrapperContext {
        private HiveConf conf;
        private Hive db;
        private Set<ReadEntity> inputs;
        private Set<WriteEntity> outputs;
        private List<Task<? extends Serializable>> tasks;
        private Logger LOG;
        private Context ctx;
        private DumpType eventType = DumpType.EVENT_UNKNOWN;
        private Task<? extends Serializable> openTxnTask = null;

        public HiveConf getConf() {
            return this.conf;
        }

        public Hive getHive() {
            return this.db;
        }

        public Set<ReadEntity> getInputs() {
            return this.inputs;
        }

        public Set<WriteEntity> getOutputs() {
            return this.outputs;
        }

        public List<Task<? extends Serializable>> getTasks() {
            return this.tasks;
        }

        public Logger getLOG() {
            return this.LOG;
        }

        public Context getCtx() {
            return this.ctx;
        }

        public void setEventType(DumpType eventType) {
            this.eventType = eventType;
        }

        public DumpType getEventType() {
            return this.eventType;
        }

        public SemanticAnalyzerWrapperContext(HiveConf conf, Hive db, Set<ReadEntity> inputs, Set<WriteEntity> outputs, List<Task<? extends Serializable>> tasks, Logger LOG, Context ctx) {
            this.conf = conf;
            this.db = db;
            this.inputs = inputs;
            this.outputs = outputs;
            this.tasks = tasks;
            this.LOG = LOG;
            this.ctx = ctx;
        }

        public Task<? extends Serializable> getOpenTxnTask() {
            return this.openTxnTask;
        }

        public void setOpenTxnTask(Task<? extends Serializable> openTxnTask) {
            this.openTxnTask = openTxnTask;
        }
    }
}

