/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplAck;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.BootstrapLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.IncrementalLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

public class ReplicationSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private ReplScope replScope = new ReplScope();
    private String sourceDbNameOrPattern;
    private HiveConf conf;
    private Hive db;
    private static final String dumpSchema = "dump_dir,last_repl_id#string,string";

    ReplicationSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
        this.db = ((BaseSemanticAnalyzer)this).db;
        this.conf = new HiveConf(((BaseSemanticAnalyzer)this).conf);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        this.LOG.debug("ReplicationSemanticAanalyzer: analyzeInternal");
        this.LOG.debug(ast.getName() + ":" + ast.getToken().getText() + "=" + ast.getText());
        this.setTxnConfigs();
        switch (ast.getToken().getType()) {
            case 1033: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: dump");
                this.analyzeReplDump(ast);
                break;
            }
            case 1034: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: load");
                this.analyzeReplLoad(ast);
                break;
            }
            case 1035: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: status");
                this.analyzeReplStatus(ast);
                break;
            }
            default: {
                throw new SemanticException("Unexpected root token");
            }
        }
    }

    private void setTxnConfigs() {
        String validTxnList = this.queryState.getConf().get("hive.txn.valid.txns");
        if (validTxnList != null) {
            this.conf.set("hive.txn.valid.txns", validTxnList);
        }
    }

    private void setReplDumpTablesList(Tree replTablesNode, ReplScope replScope) throws HiveException {
        int childCount = replTablesNode.getChildCount();
        assert (childCount <= 2);
        String replScopeType = replScope == this.replScope ? "Current" : "Old";
        for (int listIdx = 0; listIdx < childCount; ++listIdx) {
            String tableList = ReplicationSemanticAnalyzer.unescapeSQLString(replTablesNode.getChild(listIdx).getText());
            if (tableList == null || tableList.isEmpty()) {
                throw new SemanticException(ErrorMsg.REPL_INVALID_DB_OR_TABLE_PATTERN, new String[0]);
            }
            if (listIdx == 0) {
                this.LOG.info("{} ReplScope: Set Included Tables List: {}", (Object)replScopeType, (Object)tableList);
                replScope.setIncludedTablePatterns(tableList);
                continue;
            }
            this.LOG.info("{} ReplScope: Set Excluded Tables List: {}", (Object)replScopeType, (Object)tableList);
            replScope.setExcludedTablePatterns(tableList);
        }
    }

    private void initReplDump(ASTNode ast) throws HiveException {
        int numChildren = ast.getChildCount();
        boolean isMetaDataOnly = false;
        String dbNameOrPattern = PlanUtils.stripQuotes(ast.getChild(0).getText());
        this.LOG.info("Current ReplScope: Set DB Name: {}", (Object)dbNameOrPattern);
        this.replScope.setDbName(dbNameOrPattern);
        block4: for (int childIdx = 1; childIdx < numChildren; ++childIdx) {
            Tree currNode = ast.getChild(childIdx);
            switch (currNode.getType()) {
                case 1031: {
                    Map<String, String> replConfigs = ReplicationSemanticAnalyzer.getProps((ASTNode)currNode.getChild(0));
                    if (null == replConfigs) continue block4;
                    for (Map.Entry<String, String> config : replConfigs.entrySet()) {
                        this.conf.set(config.getKey(), config.getValue());
                    }
                    isMetaDataOnly = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY);
                    continue block4;
                }
                case 1036: {
                    this.setReplDumpTablesList(currNode, this.replScope);
                    continue block4;
                }
                default: {
                    throw new SemanticException("Unrecognized token " + currNode.getType() + " in REPL DUMP statement.");
                }
            }
        }
        for (String dbName : Utils.matchesDb(this.db, dbNameOrPattern)) {
            Database database = this.db.getDatabase(dbName);
            if (database != null) {
                if (!ReplUtils.isTargetOfReplication(database)) continue;
                this.LOG.error("Cannot dump database " + dbNameOrPattern + " as it is a target of replication (repl.target.for)");
                throw new SemanticException(ErrorMsg.REPL_DATABASE_IS_TARGET_OF_REPLICATION.getMsg());
            }
            throw new SemanticException("Cannot dump database " + dbNameOrPattern + " as it does not exist");
        }
    }

    private void analyzeReplDump(ASTNode ast) throws SemanticException {
        try {
            this.initReplDump(ast);
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), e);
        }
        try {
            this.ctx.setResFile(this.ctx.getLocalTmpPath());
            Task<ReplDumpWork> replDumpWorkTask = TaskFactory.get(new ReplDumpWork(this.replScope, ErrorMsg.INVALID_PATH.getMsg(ast), this.ctx.getResFile().toUri().toString()), this.conf);
            this.rootTasks.add(replDumpWorkTask);
            for (String dbName : Utils.matchesDb(this.db, this.replScope.getDbName())) {
                if (!this.replScope.includeAllTables()) {
                    for (String tblName : Utils.matchesTbl(this.db, dbName, this.replScope)) {
                        this.inputs.add(new ReadEntity(this.db.getTable(dbName, tblName)));
                    }
                    continue;
                }
                this.inputs.add(new ReadEntity(this.db.getDatabase(dbName)));
            }
            this.setFetchTask(this.createFetchTask(dumpSchema));
        }
        catch (Exception e) {
            this.LOG.warn("Error during analyzeReplDump", (Throwable)e);
            throw new SemanticException(e);
        }
    }

    private void initReplLoad(ASTNode ast) throws HiveException {
        this.sourceDbNameOrPattern = PlanUtils.stripQuotes(ast.getChild(0).getText());
        int numChildren = ast.getChildCount();
        block5: for (int i = 1; i < numChildren; ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 860: {
                    this.replScope.setDbName(PlanUtils.stripQuotes(childNode.getChild(0).getText()));
                    continue block5;
                }
                case 1031: {
                    this.setConfigs((ASTNode)childNode.getChild(0));
                    continue block5;
                }
                case 1036: {
                    continue block5;
                }
                default: {
                    throw new SemanticException("Unrecognized token in REPL LOAD statement.");
                }
            }
        }
    }

    private void analyzeReplLoad(ASTNode ast) throws SemanticException {
        try {
            this.initReplLoad(ast);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        try {
            assert (this.sourceDbNameOrPattern != null);
            Path loadPath = this.getCurrentLoadPath();
            if (ReplUtils.failedWithNonRecoverableError(ReplUtils.getLatestDumpPath(ReplUtils.getEncodedDumpRootPath(this.conf, this.sourceDbNameOrPattern.toLowerCase()), this.conf), this.conf)) {
                throw new Exception(ErrorMsg.REPL_FAILED_WITH_NON_RECOVERABLE_ERROR.getMsg());
            }
            if (loadPath != null) {
                DumpMetaData dmd = new DumpMetaData(loadPath, this.conf);
                boolean evDump = false;
                if (dmd.isIncrementalDump()) {
                    this.LOG.debug("{} contains an incremental dump", (Object)loadPath);
                    evDump = true;
                } else {
                    this.LOG.debug("{} contains an bootstrap dump", (Object)loadPath);
                }
                ReplLoadWork replLoadWork = new ReplLoadWork(this.conf, loadPath.toString(), this.sourceDbNameOrPattern, this.replScope.getDbName(), dmd.getReplScope(), this.queryState.getLineageState(), evDump, dmd.getEventTo(), dmd.getDumpExecutionId(), this.initMetricCollection(!evDump, loadPath.toString(), this.replScope.getDbName(), dmd.getDumpExecutionId()), dmd.isReplScopeModified());
                this.rootTasks.add(TaskFactory.get(replLoadWork, this.conf));
            } else {
                this.LOG.warn("Previous Dump Already Loaded");
            }
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage(), e);
        }
    }

    private ReplicationMetricCollector initMetricCollection(boolean isBootstrap, String dumpDirectory, String dbNameToLoadIn, long dumpExecutionId) {
        ReplicationMetricCollector collector = isBootstrap ? new BootstrapLoadMetricCollector(dbNameToLoadIn, dumpDirectory, dumpExecutionId, this.conf) : new IncrementalLoadMetricCollector(dbNameToLoadIn, dumpDirectory, dumpExecutionId, this.conf);
        return collector;
    }

    private Path getCurrentLoadPath() throws IOException, SemanticException {
        FileStatus[] statuses;
        Path loadPathBase = ReplUtils.getEncodedDumpRootPath(this.conf, this.sourceDbNameOrPattern.toLowerCase());
        FileSystem fs = loadPathBase.getFileSystem((Configuration)this.conf);
        if (fs.exists(loadPathBase = fs.makeQualified(loadPathBase)) && (statuses = loadPathBase.getFileSystem((Configuration)this.conf).listStatus(loadPathBase)).length > 0) {
            FileStatus latestUpdatedStatus = statuses[0];
            for (FileStatus status : statuses) {
                if (status.getModificationTime() <= latestUpdatedStatus.getModificationTime()) continue;
                latestUpdatedStatus = status;
            }
            Path hiveDumpPath = new Path(latestUpdatedStatus.getPath(), "hive");
            if (loadPathBase.getFileSystem((Configuration)this.conf).exists(new Path(hiveDumpPath, ReplAck.DUMP_ACKNOWLEDGEMENT.toString())) && !loadPathBase.getFileSystem((Configuration)this.conf).exists(new Path(hiveDumpPath, ReplAck.LOAD_ACKNOWLEDGEMENT.toString()))) {
                return hiveDumpPath;
            }
        }
        return null;
    }

    private void setConfigs(ASTNode node) throws SemanticException {
        Map<String, String> replConfigs = ReplicationSemanticAnalyzer.getProps(node);
        if (null != replConfigs) {
            for (Map.Entry<String, String> config : replConfigs.entrySet()) {
                String key = config.getKey();
                if (key.equalsIgnoreCase(HiveConf.ConfVars.HIVEQUERYID.varname)) {
                    String queryTag = config.getValue();
                    if (!StringUtils.isEmpty(queryTag)) {
                        QueryState.setApplicationTag(this.conf, queryTag);
                    }
                    this.queryState.setQueryTag(queryTag);
                    continue;
                }
                this.conf.set(key, config.getValue());
            }
            try {
                this.db = Hive.get(this.conf);
            }
            catch (HiveException e) {
                throw new SemanticException(e);
            }
        }
    }

    private void initReplStatus(ASTNode ast) throws SemanticException {
        this.replScope.setDbName(PlanUtils.stripQuotes(ast.getChild(0).getText()));
        int numChildren = ast.getChildCount();
        for (int i = 1; i < numChildren; ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            if (childNode.getToken().getType() != 1031) {
                throw new SemanticException("Unrecognized token in REPL STATUS statement.");
            }
            this.setConfigs((ASTNode)childNode.getChild(0));
        }
    }

    private void analyzeReplStatus(ASTNode ast) throws SemanticException {
        this.initReplStatus(ast);
        String dbNameOrPattern = this.replScope.getDbName();
        String replLastId = this.getReplStatus(dbNameOrPattern);
        this.prepareReturnValues(Collections.singletonList(replLastId), "last_repl_id#string");
        this.setFetchTask(this.createFetchTask("last_repl_id#string"));
        this.LOG.debug("ReplicationSemanticAnalyzer.analyzeReplStatus: writing repl.last.id={} out to {} using configuration {}", new Object[]{replLastId, this.ctx.getResFile(), this.conf});
    }

    private String getReplStatus(String dbNameOrPattern) throws SemanticException {
        try {
            Database database = this.db.getDatabase(dbNameOrPattern);
            if (database != null) {
                this.inputs.add(new ReadEntity(database));
                Map<String, String> params = database.getParameters();
                if (params != null && params.containsKey(ReplicationSpec.KEY.CURR_STATE_ID.toString())) {
                    return params.get(ReplicationSpec.KEY.CURR_STATE_ID.toString());
                }
            }
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        return null;
    }

    private void prepareReturnValues(List<String> values, String schema) throws SemanticException {
        this.LOG.debug("prepareReturnValues : " + schema);
        for (String s : values) {
            this.LOG.debug("    > " + s);
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        Utils.writeOutput(Collections.singletonList(values), this.ctx.getResFile(), this.conf);
    }
}

