/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.lib.CostLessRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SubqueryExpressionWalker;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSubquerySemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactoryUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeSubQueryDesc;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.NullWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCheckProcFactory {
    protected static final Logger LOG = LoggerFactory.getLogger((String)TypeCheckProcFactory.class.getName());

    protected TypeCheckProcFactory() {
    }

    public static ExprNodeDesc processGByExpr(Node nd, Object procCtx) throws SemanticException {
        ASTNode expr = (ASTNode)nd;
        TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
        if (!ctx.isUseCaching() && ctx.getOuterRR() == null) {
            return null;
        }
        RowResolver input = ctx.getInputRR();
        ExprNodeColumnDesc desc = null;
        if (ctx == null || input == null || !ctx.getAllowGBExprElimination()) {
            return null;
        }
        ColumnInfo colInfo = input.getExpression(expr);
        RowResolver outerRR = ctx.getOuterRR();
        if (colInfo == null && outerRR != null) {
            colInfo = outerRR.getExpression(expr);
        }
        if (colInfo != null) {
            desc = new ExprNodeColumnDesc(colInfo);
            ASTNode source = input.getExpressionSource(expr);
            if (source != null && ctx.getUnparseTranslator() != null) {
                ctx.getUnparseTranslator().addCopyTranslation(expr, source);
            }
            return desc;
        }
        return desc;
    }

    public static Map<ASTNode, ExprNodeDesc> genExprNode(ASTNode expr, TypeCheckCtx tcCtx) throws SemanticException {
        return TypeCheckProcFactory.genExprNode(expr, tcCtx, new TypeCheckProcFactory());
    }

    protected static Map<ASTNode, ExprNodeDesc> genExprNode(ASTNode expr, TypeCheckCtx tcCtx, TypeCheckProcFactory tf) throws SemanticException {
        HashMultimap<Integer, NodeProcessor> astNodeToProcessor = HashMultimap.create();
        astNodeToProcessor.put(970, tf.getNullExprProcessor());
        astNodeToProcessor.put(383, tf.getNumExprProcessor());
        astNodeToProcessor.put(25, tf.getNumExprProcessor());
        astNodeToProcessor.put(384, tf.getNumExprProcessor());
        astNodeToProcessor.put(24, tf.getStrExprProcessor());
        astNodeToProcessor.put(395, tf.getStrExprProcessor());
        astNodeToProcessor.put(830, tf.getStrExprProcessor());
        astNodeToProcessor.put(1095, tf.getStrExprProcessor());
        astNodeToProcessor.put(160, tf.getStrExprProcessor());
        astNodeToProcessor.put(57, tf.getStrExprProcessor());
        astNodeToProcessor.put(363, tf.getStrExprProcessor());
        astNodeToProcessor.put(162, tf.getStrExprProcessor());
        astNodeToProcessor.put(40, tf.getStrExprProcessor());
        astNodeToProcessor.put(203, tf.getStrExprProcessor());
        astNodeToProcessor.put(313, tf.getStrExprProcessor());
        astNodeToProcessor.put(129, tf.getStrExprProcessor());
        astNodeToProcessor.put(1101, tf.getStrExprProcessor());
        astNodeToProcessor.put(334, tf.getBoolExprProcessor());
        astNodeToProcessor.put(136, tf.getBoolExprProcessor());
        astNodeToProcessor.put(858, tf.getDateTimeExprProcessor());
        astNodeToProcessor.put(1141, tf.getDateTimeExprProcessor());
        astNodeToProcessor.put(1143, tf.getDateTimeExprProcessor());
        astNodeToProcessor.put(940, tf.getIntervalExprProcessor());
        astNodeToProcessor.put(933, tf.getIntervalExprProcessor());
        astNodeToProcessor.put(938, tf.getIntervalExprProcessor());
        astNodeToProcessor.put(936, tf.getIntervalExprProcessor());
        astNodeToProcessor.put(931, tf.getIntervalExprProcessor());
        astNodeToProcessor.put(934, tf.getIntervalExprProcessor());
        astNodeToProcessor.put(935, tf.getIntervalExprProcessor());
        astNodeToProcessor.put(937, tf.getIntervalExprProcessor());
        astNodeToProcessor.put(1130, tf.getColumnExprProcessor());
        astNodeToProcessor.put(1098, tf.getSubQueryExprProcessor());
        CostLessRuleDispatcher disp = new CostLessRuleDispatcher(tf.getDefaultExprProcessor(), astNodeToProcessor, tcCtx);
        SubqueryExpressionWalker ogw = new SubqueryExpressionWalker(disp);
        ArrayList<Node> topNodes = Lists.newArrayList(expr);
        LinkedHashMap<Node, Object> nodeOutputs = new LinkedHashMap<Node, Object>();
        ogw.startWalking(topNodes, nodeOutputs);
        return TypeCheckProcFactory.convert(nodeOutputs);
    }

    private static Map<ASTNode, ExprNodeDesc> convert(Map<Node, Object> outputs) {
        LinkedHashMap<ASTNode, ExprNodeDesc> converted = new LinkedHashMap<ASTNode, ExprNodeDesc>();
        for (Map.Entry<Node, Object> entry : outputs.entrySet()) {
            if (entry.getKey() instanceof ASTNode && (entry.getValue() == null || entry.getValue() instanceof ExprNodeDesc)) {
                converted.put((ASTNode)entry.getKey(), (ExprNodeDesc)entry.getValue());
                continue;
            }
            LOG.warn("Invalid type entry " + entry);
        }
        return converted;
    }

    public NullExprProcessor getNullExprProcessor() {
        return new NullExprProcessor();
    }

    public NumExprProcessor getNumExprProcessor() {
        return new NumExprProcessor();
    }

    public StrExprProcessor getStrExprProcessor() {
        return new StrExprProcessor();
    }

    public BoolExprProcessor getBoolExprProcessor() {
        return new BoolExprProcessor();
    }

    public IntervalExprProcessor getIntervalExprProcessor() {
        return new IntervalExprProcessor();
    }

    public DateTimeExprProcessor getDateTimeExprProcessor() {
        return new DateTimeExprProcessor();
    }

    static ExprNodeDesc toExprNodeDesc(ColumnInfo colInfo) {
        ObjectInspector listElementOI;
        ObjectInspector inspector = colInfo.getObjectInspector();
        if (inspector instanceof ConstantObjectInspector && inspector instanceof PrimitiveObjectInspector) {
            return TypeCheckProcFactory.toPrimitiveConstDesc(colInfo, inspector);
        }
        if (inspector instanceof ConstantObjectInspector && inspector instanceof ListObjectInspector && (listElementOI = ((ListObjectInspector)inspector).getListElementObjectInspector()) instanceof PrimitiveObjectInspector) {
            return TypeCheckProcFactory.toListConstDesc(colInfo, inspector, listElementOI);
        }
        if (inspector instanceof ConstantObjectInspector && inspector instanceof MapObjectInspector) {
            ObjectInspector keyOI = ((MapObjectInspector)inspector).getMapKeyObjectInspector();
            ObjectInspector valueOI = ((MapObjectInspector)inspector).getMapValueObjectInspector();
            if (keyOI instanceof PrimitiveObjectInspector && valueOI instanceof PrimitiveObjectInspector) {
                return TypeCheckProcFactory.toMapConstDesc(colInfo, inspector, keyOI, valueOI);
            }
        }
        if (inspector instanceof ConstantObjectInspector && inspector instanceof StructObjectInspector) {
            boolean allPrimitive = true;
            List<? extends StructField> fields = ((StructObjectInspector)inspector).getAllStructFieldRefs();
            for (StructField structField : fields) {
                allPrimitive &= structField.getFieldObjectInspector() instanceof PrimitiveObjectInspector;
            }
            if (allPrimitive) {
                return TypeCheckProcFactory.toStructConstDesc(colInfo, inspector, fields);
            }
        }
        ExprNodeColumnDesc column = new ExprNodeColumnDesc(colInfo);
        column.setSkewedCol(colInfo.isSkewedCol());
        return column;
    }

    private static ExprNodeConstantDesc toPrimitiveConstDesc(ColumnInfo colInfo, ObjectInspector inspector) {
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)inspector;
        Object constant = ((ConstantObjectInspector)inspector).getWritableConstantValue();
        ExprNodeConstantDesc constantExpr = new ExprNodeConstantDesc(colInfo.getType(), poi.getPrimitiveJavaObject(constant));
        constantExpr.setFoldedFromCol(colInfo.getInternalName());
        constantExpr.setFoldedFromTab(colInfo.getTabAlias());
        return constantExpr;
    }

    private static ExprNodeConstantDesc toListConstDesc(ColumnInfo colInfo, ObjectInspector inspector, ObjectInspector listElementOI) {
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)listElementOI;
        List values = (List)((ConstantObjectInspector)inspector).getWritableConstantValue();
        ArrayList<Object> constant = new ArrayList<Object>();
        for (Object o : values) {
            constant.add(poi.getPrimitiveJavaObject(o));
        }
        ExprNodeConstantDesc constantExpr = new ExprNodeConstantDesc(colInfo.getType(), constant);
        constantExpr.setFoldedFromCol(colInfo.getInternalName());
        constantExpr.setFoldedFromTab(colInfo.getTabAlias());
        return constantExpr;
    }

    private static ExprNodeConstantDesc toMapConstDesc(ColumnInfo colInfo, ObjectInspector inspector, ObjectInspector keyOI, ObjectInspector valueOI) {
        PrimitiveObjectInspector keyPoi = (PrimitiveObjectInspector)keyOI;
        PrimitiveObjectInspector valuePoi = (PrimitiveObjectInspector)valueOI;
        Map values = (Map)((ConstantObjectInspector)inspector).getWritableConstantValue();
        LinkedHashMap<Object, Object> constant = new LinkedHashMap<Object, Object>();
        for (Map.Entry e : values.entrySet()) {
            constant.put(keyPoi.getPrimitiveJavaObject(e.getKey()), valuePoi.getPrimitiveJavaObject(e.getValue()));
        }
        ExprNodeConstantDesc constantExpr = new ExprNodeConstantDesc(colInfo.getType(), constant);
        constantExpr.setFoldedFromCol(colInfo.getInternalName());
        constantExpr.setFoldedFromTab(colInfo.getTabAlias());
        return constantExpr;
    }

    private static ExprNodeConstantDesc toStructConstDesc(ColumnInfo colInfo, ObjectInspector inspector, List<? extends StructField> fields) {
        List values = (List)((ConstantObjectInspector)inspector).getWritableConstantValue();
        ArrayList<Object> constant = new ArrayList<Object>();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            PrimitiveObjectInspector fieldPoi = (PrimitiveObjectInspector)fields.get(i).getFieldObjectInspector();
            constant.add(fieldPoi.getPrimitiveJavaObject(value));
        }
        ExprNodeConstantDesc constantExpr = new ExprNodeConstantDesc(colInfo.getType(), constant);
        constantExpr.setFoldedFromCol(colInfo.getInternalName());
        constantExpr.setFoldedFromTab(colInfo.getTabAlias());
        return constantExpr;
    }

    public ColumnExprProcessor getColumnExprProcessor() {
        return new ColumnExprProcessor();
    }

    public DefaultExprProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    public SubQueryExprProcessor getSubQueryExprProcessor() {
        return new SubQueryExprProcessor();
    }

    public static class SubQueryExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ASTNode expr = (ASTNode)nd;
            ASTNode sqNode = (ASTNode)expr.getParent().getChild(1);
            if (!ctx.getallowSubQueryExpr()) {
                throw new CalciteSubquerySemanticException(SemanticAnalyzer.generateErrorMessage(sqNode, ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg("Currently SubQuery expressions are only allowed as Where and Having Clause predicates")));
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            assert (expr.getChildren().size() == 3 || expr.getChildren().size() == 2);
            assert (expr.getChild(0).getType() == 1099);
            ASTNode subqueryOp = (ASTNode)expr.getChild(0);
            boolean isIN = subqueryOp.getChildCount() > 0 && (subqueryOp.getChild(0).getType() == 162 || subqueryOp.getChild(0).getType() == 1101);
            boolean isEXISTS = subqueryOp.getChildCount() > 0 && (subqueryOp.getChild(0).getType() == 129 || subqueryOp.getChild(0).getType() == 1100);
            boolean isScalar = subqueryOp.getChildCount() == 0;
            Map<ASTNode, RelNode> subqueryToRelNode = ctx.getSubqueryToRelNode();
            if (subqueryToRelNode == null) {
                throw new CalciteSubquerySemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(" Currently SubQuery expressions are only allowed as Where and Having Clause predicates"));
            }
            RelNode subqueryRel = subqueryToRelNode.get(expr);
            if (isEXISTS) {
                return new ExprNodeSubQueryDesc(TypeInfoFactory.booleanTypeInfo, subqueryRel, ExprNodeSubQueryDesc.SubqueryType.EXISTS);
            }
            if (isIN) {
                assert (nodeOutputs[2] != null);
                ExprNodeDesc lhs = (ExprNodeDesc)nodeOutputs[2];
                return new ExprNodeSubQueryDesc(TypeInfoFactory.booleanTypeInfo, subqueryRel, ExprNodeSubQueryDesc.SubqueryType.IN, lhs);
            }
            if (isScalar) {
                if (subqueryRel.getRowType().getFieldCount() != 1) {
                    throw new CalciteSubquerySemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg("More than one column expression in subquery"));
                }
                TypeInfo subExprType = TypeConverter.convert(((RelDataTypeField)subqueryRel.getRowType().getFieldList().get(0)).getType());
                return new ExprNodeSubQueryDesc(subExprType, subqueryRel, ExprNodeSubQueryDesc.SubqueryType.SCALAR);
            }
            ctx.setError(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(sqNode, "Currently only IN & EXISTS SubQuery expressions are allowed"), sqNode);
            return null;
        }
    }

    public static class DefaultExprProcessor
    implements NodeProcessor {
        static HashMap<Integer, String> specialUnaryOperatorTextHashMap = new HashMap();
        static HashMap<Integer, String> conversionFunctionTextHashMap;
        static HashSet<Integer> windowingTokens;

        protected static boolean isRedundantConversionFunction(ASTNode expr, boolean isFunction, ArrayList<ExprNodeDesc> children) {
            if (!isFunction) {
                return false;
            }
            if (children.size() != 1) {
                return false;
            }
            String funcText = conversionFunctionTextHashMap.get(((ASTNode)expr.getChild(0)).getType());
            if (funcText == null) {
                return false;
            }
            return ((PrimitiveTypeInfo)children.get(0).getTypeInfo()).getTypeName().equalsIgnoreCase(funcText);
        }

        public static String getFunctionText(ASTNode expr, boolean isFunction) {
            String funcText = null;
            if (!isFunction) {
                if (expr.getChildCount() == 1) {
                    funcText = specialUnaryOperatorTextHashMap.get(expr.getType());
                }
                if (funcText == null) {
                    funcText = expr.getText();
                }
            } else {
                assert (expr.getChildCount() >= 1);
                int funcType = ((ASTNode)expr.getChild(0)).getType();
                if (funcText == null) {
                    funcText = conversionFunctionTextHashMap.get(funcType);
                }
                if (funcText == null) {
                    funcText = ((ASTNode)expr.getChild(0)).getText();
                }
            }
            return BaseSemanticAnalyzer.unescapeIdentifier(funcText);
        }

        static ExprNodeDesc getFuncExprNodeDescWithUdfData(String udfName, TypeInfo typeInfo, ExprNodeDesc ... children) throws UDFArgumentException {
            FunctionInfo fi;
            try {
                fi = FunctionRegistry.getFunctionInfo(udfName);
            }
            catch (SemanticException e) {
                throw new UDFArgumentException(e);
            }
            if (fi == null) {
                throw new UDFArgumentException(udfName + " not found.");
            }
            GenericUDF genericUDF = fi.getGenericUDF();
            if (genericUDF == null) {
                throw new UDFArgumentException(udfName + " is an aggregation function or a table function.");
            }
            if (typeInfo != null && genericUDF instanceof SettableUDF) {
                ((SettableUDF)((Object)genericUDF)).setTypeInfo(typeInfo);
            }
            ArrayList<ExprNodeDesc> childrenList = new ArrayList<ExprNodeDesc>(children.length);
            childrenList.addAll(Arrays.asList(children));
            return ExprNodeGenericFuncDesc.newInstance(genericUDF, childrenList);
        }

        public static ExprNodeDesc getFuncExprNodeDesc(String udfName, ExprNodeDesc ... children) throws UDFArgumentException {
            return DefaultExprProcessor.getFuncExprNodeDescWithUdfData(udfName, null, children);
        }

        protected void validateUDF(ASTNode expr, boolean isFunction, TypeCheckCtx ctx, FunctionInfo fi, List<ExprNodeDesc> children, GenericUDF genericUDF) throws SemanticException {
            if (fi.getGenericUDTF() != null) {
                throw new SemanticException(ErrorMsg.UDTF_INVALID_LOCATION.getMsg());
            }
            if (fi.getGenericUDAFResolver() != null) {
                if (isFunction) {
                    throw new SemanticException(ErrorMsg.UDAF_INVALID_LOCATION.getMsg((ASTNode)expr.getChild(0)));
                }
                throw new SemanticException(ErrorMsg.UDAF_INVALID_LOCATION.getMsg(expr));
            }
            if (!ctx.getAllowStatefulFunctions() && genericUDF != null && FunctionRegistry.isStateful(genericUDF)) {
                throw new SemanticException(ErrorMsg.UDF_STATEFUL_INVALID_LOCATION.getMsg());
            }
        }

        protected void insertCast(String funcText, ArrayList<ExprNodeDesc> children) throws SemanticException {
            if ((funcText.equals("substring") || funcText.equals("concat")) && children.size() > 0 && !ExprNodeDescUtils.isStringType(children.get(0))) {
                ExprNodeDesc newColumn = ParseUtils.createConversionCast(children.get(0), TypeInfoFactory.stringTypeInfo);
                children.set(0, newColumn);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected ExprNodeDesc getXpathOrFuncExprNodeDesc(ASTNode expr, boolean isFunction, ArrayList<ExprNodeDesc> children, TypeCheckCtx ctx) throws SemanticException, UDFArgumentException {
            void var6_41;
            void var6_39;
            if (DefaultExprProcessor.isRedundantConversionFunction(expr, isFunction, children)) {
                assert (children.size() == 1);
                assert (children.get(0) != null);
                return children.get(0);
            }
            String funcText = DefaultExprProcessor.getFunctionText(expr, isFunction);
            if (funcText.equals(".")) {
                boolean isList;
                assert (children.size() == 2);
                assert (children.get(1) instanceof ExprNodeConstantDesc);
                ExprNodeDesc object = children.get(0);
                ExprNodeConstantDesc fieldName = (ExprNodeConstantDesc)children.get(1);
                assert (fieldName.getValue() instanceof String);
                String fieldNameString = (String)fieldName.getValue();
                TypeInfo objectTypeInfo = object.getTypeInfo();
                boolean bl = isList = object.getTypeInfo().getCategory() == ObjectInspector.Category.LIST;
                if (isList) {
                    objectTypeInfo = ((ListTypeInfo)objectTypeInfo).getListElementTypeInfo();
                }
                if (objectTypeInfo.getCategory() != ObjectInspector.Category.STRUCT) {
                    throw new SemanticException(ErrorMsg.INVALID_DOT.getMsg(expr));
                }
                TypeInfo t = ((StructTypeInfo)objectTypeInfo).getStructFieldTypeInfo(fieldNameString);
                if (isList) {
                    t = TypeInfoFactory.getListTypeInfo(t);
                }
                ExprNodeFieldDesc exprNodeFieldDesc = new ExprNodeFieldDesc(t, children.get(0), fieldNameString, isList);
            } else if (funcText.equals("[")) {
                if (!ctx.getallowIndexExpr()) {
                    throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(expr));
                }
                assert (children.size() == 2);
                TypeInfo myt = children.get(0).getTypeInfo();
                if (myt.getCategory() == ObjectInspector.Category.LIST) {
                    if (!TypeInfoUtils.implicitConvertible(children.get(1).getTypeInfo(), TypeInfoFactory.intTypeInfo)) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_ARRAYINDEX_TYPE.getMsg()));
                    }
                    TypeInfo t = ((ListTypeInfo)myt).getListElementTypeInfo();
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = new ExprNodeGenericFuncDesc(t, FunctionRegistry.getGenericUDFForIndex(), children);
                } else {
                    if (myt.getCategory() != ObjectInspector.Category.MAP) throw new SemanticException(ErrorMsg.NON_COLLECTION_TYPE.getMsg(expr, myt.getTypeName()));
                    if (!TypeInfoUtils.implicitConvertible(children.get(1).getTypeInfo(), ((MapTypeInfo)myt).getMapKeyTypeInfo())) {
                        throw new SemanticException(ErrorMsg.INVALID_MAPINDEX_TYPE.getMsg(expr));
                    }
                    TypeInfo t = ((MapTypeInfo)myt).getMapValueTypeInfo();
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = new ExprNodeGenericFuncDesc(t, FunctionRegistry.getGenericUDFForIndex(), children);
                }
            } else {
                ExprNodeDesc constantExpr;
                void var6_37;
                FunctionInfo fi = FunctionRegistry.getFunctionInfo(funcText);
                if (fi == null) {
                    if (!isFunction) throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(expr));
                    throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg((ASTNode)expr.getChild(0)));
                }
                GenericUDF genericUDF = fi.getGenericUDF();
                if (!fi.isNative()) {
                    ctx.getUnparseTranslator().addIdentifierTranslation((ASTNode)expr.getChild(0));
                }
                if (isFunction) {
                    ASTNode funcNameNode = (ASTNode)expr.getChild(0);
                    switch (funcNameNode.getType()) {
                        case 829: {
                            CharTypeInfo charTypeInfo = ParseUtils.getCharTypeInfo(funcNameNode);
                            if (genericUDF == null) break;
                            ((SettableUDF)((Object)genericUDF)).setTypeInfo(charTypeInfo);
                            break;
                        }
                        case 1169: {
                            VarcharTypeInfo varcharTypeInfo = ParseUtils.getVarcharTypeInfo(funcNameNode);
                            if (genericUDF == null) break;
                            ((SettableUDF)((Object)genericUDF)).setTypeInfo(varcharTypeInfo);
                            break;
                        }
                        case 1142: {
                            HiveConf conf;
                            TimestampLocalTZTypeInfo timestampLocalTZTypeInfo = new TimestampLocalTZTypeInfo();
                            try {
                                conf = Hive.get().getConf();
                            }
                            catch (HiveException e) {
                                throw new SemanticException(e);
                            }
                            timestampLocalTZTypeInfo.setTimeZone(conf.getLocalTimeZone());
                            if (genericUDF == null) break;
                            ((SettableUDF)((Object)genericUDF)).setTypeInfo(timestampLocalTZTypeInfo);
                            break;
                        }
                        case 864: {
                            DecimalTypeInfo decTypeInfo = ParseUtils.getDecimalTypeTypeInfo(funcNameNode);
                            if (genericUDF == null) break;
                            ((SettableUDF)((Object)genericUDF)).setTypeInfo(decTypeInfo);
                            break;
                        }
                    }
                }
                this.insertCast(funcText, children);
                this.validateUDF(expr, isFunction, ctx, fi, children, genericUDF);
                if (genericUDF instanceof GenericUDFBaseCompare && children.size() == 2 && (children.get(0) instanceof ExprNodeConstantDesc && children.get(1) instanceof ExprNodeColumnDesc || children.get(0) instanceof ExprNodeColumnDesc && children.get(1) instanceof ExprNodeConstantDesc)) {
                    int constIdx = children.get(0) instanceof ExprNodeConstantDesc ? 0 : 1;
                    ExprNodeDesc constChild = children.get(constIdx);
                    ExprNodeDesc columnChild = children.get(1 - constIdx);
                    PrimitiveTypeInfo colTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo(columnChild.getTypeString().toLowerCase());
                    ExprNodeDesc newChild = DefaultExprProcessor.interpretNodeAs(colTypeInfo, constChild);
                    if (newChild == null) {
                        if (genericUDF instanceof GenericUDFOPEqual && !(genericUDF instanceof GenericUDFOPEqualNS)) {
                            return new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, null);
                        }
                    } else {
                        children.set(constIdx, newChild);
                    }
                }
                if (genericUDF instanceof GenericUDFIn) {
                    ArrayList<ExprNodeDesc> orOperands;
                    ExprNodeDesc columnDesc = children.get(0);
                    List<ExprNodeDesc> outputOpList = children.subList(1, children.size());
                    ArrayList<ExprNodeDesc> inOperands = new ArrayList<ExprNodeDesc>(outputOpList);
                    outputOpList.clear();
                    boolean hasNullValue = false;
                    for (ExprNodeDesc oldChild : inOperands) {
                        if (oldChild == null) {
                            hasNullValue = true;
                            continue;
                        }
                        ExprNodeDesc newChild = DefaultExprProcessor.interpretNodeAsStruct(columnDesc, oldChild);
                        if (newChild == null) {
                            hasNullValue = true;
                            continue;
                        }
                        outputOpList.add(newChild);
                    }
                    if (hasNullValue) {
                        ExprNodeConstantDesc nullConst = new ExprNodeConstantDesc(columnDesc.getTypeInfo(), null);
                        if (outputOpList.size() == 0) {
                            return nullConst;
                        }
                        outputOpList.add(nullConst);
                    }
                    if (!ctx.isCBOExecuted() && (orOperands = TypeCheckProcFactoryUtils.rewriteInToOR(children)) != null) {
                        if (orOperands.size() == 1) {
                            orOperands.add(new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, false));
                        }
                        funcText = "or";
                        genericUDF = new GenericUDFOPOr();
                        children.clear();
                        children.addAll(orOperands);
                    }
                }
                if (genericUDF instanceof GenericUDFOPOr) {
                    ArrayList<ExprNodeDesc> childrenList = new ArrayList<ExprNodeDesc>(children.size());
                    for (ExprNodeDesc child : children) {
                        if (FunctionRegistry.isOpOr(child)) {
                            childrenList.addAll(child.getChildren());
                            continue;
                        }
                        childrenList.add(child);
                    }
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = ExprNodeGenericFuncDesc.newInstance(genericUDF, funcText, childrenList);
                } else if (genericUDF instanceof GenericUDFOPAnd) {
                    ArrayList<ExprNodeDesc> childrenList = new ArrayList<ExprNodeDesc>(children.size());
                    for (ExprNodeDesc child : children) {
                        if (FunctionRegistry.isOpAnd(child)) {
                            childrenList.addAll(child.getChildren());
                            continue;
                        }
                        childrenList.add(child);
                    }
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = ExprNodeGenericFuncDesc.newInstance(genericUDF, funcText, childrenList);
                } else if (ctx.isFoldExpr() && this.canConvertIntoCoalesce(genericUDF, children)) {
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = ExprNodeGenericFuncDesc.newInstance(new GenericUDFCoalesce(), Lists.newArrayList(children.get(0), new ExprNodeConstantDesc(false)));
                    if (Boolean.FALSE.equals(((ExprNodeConstantDesc)children.get(1)).getValue())) {
                        ExprNodeGenericFuncDesc exprNodeGenericFuncDesc2 = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPNot(), Lists.newArrayList(exprNodeGenericFuncDesc));
                    }
                } else if (ctx.isFoldExpr() && this.canConvertCaseIntoIf(genericUDF, children)) {
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = ExprNodeGenericFuncDesc.newInstance(new GenericUDFIf(), children);
                } else {
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = ExprNodeGenericFuncDesc.newInstance(genericUDF, funcText, children, expr);
                }
                if (ctx.isFoldExpr() && var6_37 instanceof ExprNodeGenericFuncDesc && FunctionRegistry.isConsistentWithinQuery(genericUDF) && ExprNodeDescUtils.isAllConstants(children) && (constantExpr = ConstantPropagateProcFactory.foldExpr((ExprNodeGenericFuncDesc)var6_37)) != null) {
                    ExprNodeDesc exprNodeDesc = constantExpr;
                }
            }
            if (FunctionRegistry.isOpPositive((ExprNodeDesc)var6_39)) {
                assert (var6_39.getChildren().size() == 1);
                ExprNodeDesc exprNodeDesc = var6_39.getChildren().get(0);
            }
            assert (var6_41 != null);
            return var6_41;
        }

        private static ExprNodeDesc interpretNodeAsStruct(ExprNodeDesc columnDesc, ExprNodeDesc valueDesc) throws SemanticException {
            List<ExprNodeDesc> columnChilds;
            if (columnDesc instanceof ExprNodeColumnDesc) {
                TypeInfo info = columnDesc.getTypeInfo();
                switch (info.getCategory()) {
                    case MAP: 
                    case LIST: 
                    case UNION: 
                    case STRUCT: {
                        return valueDesc;
                    }
                    case PRIMITIVE: {
                        PrimitiveTypeInfo primitiveInfo = TypeInfoFactory.getPrimitiveTypeInfo(info.getTypeName().toLowerCase());
                        return DefaultExprProcessor.interpretNodeAs(primitiveInfo, valueDesc);
                    }
                }
            }
            if (ExprNodeDescUtils.isStructUDF(columnDesc) && ExprNodeDescUtils.isConstantStruct(valueDesc)) {
                columnChilds = ((ExprNodeGenericFuncDesc)columnDesc).getChildren();
                ExprNodeConstantDesc valueConstDesc = (ExprNodeConstantDesc)valueDesc;
                StructTypeInfo structTypeInfo = (StructTypeInfo)valueConstDesc.getTypeInfo();
                ArrayList<TypeInfo> structFieldInfos = structTypeInfo.getAllStructFieldTypeInfos();
                ArrayList<TypeInfo> newStructFieldInfos = new ArrayList<TypeInfo>();
                if (columnChilds.size() != structFieldInfos.size()) {
                    throw new SemanticException(ErrorMsg.INCOMPATIBLE_STRUCT.getMsg(columnChilds + " and " + structFieldInfos));
                }
                List oldValues = (List)valueConstDesc.getValue();
                ArrayList<Object> newValues = new ArrayList<Object>();
                for (int i = 0; i < columnChilds.size(); ++i) {
                    newStructFieldInfos.add(columnChilds.get(i).getTypeInfo());
                    Object newValue = DefaultExprProcessor.interpretConstantAsPrimitive((PrimitiveTypeInfo)columnChilds.get(i).getTypeInfo(), oldValues.get(i), structFieldInfos.get(i));
                    newValues.add(newValue);
                }
                StructTypeInfo sti = new StructTypeInfo();
                sti.setAllStructFieldTypeInfos(newStructFieldInfos);
                sti.setAllStructFieldNames(structTypeInfo.getAllStructFieldNames());
                return new ExprNodeConstantDesc(sti, newValues);
            }
            if (ExprNodeDescUtils.isStructUDF(columnDesc) && ExprNodeDescUtils.isStructUDF(valueDesc)) {
                columnChilds = ((ExprNodeGenericFuncDesc)columnDesc).getChildren();
                List<ExprNodeDesc> valueChilds = ((ExprNodeGenericFuncDesc)valueDesc).getChildren();
                if (columnChilds.size() != valueChilds.size()) {
                    throw new SemanticException(ErrorMsg.INCOMPATIBLE_STRUCT.getMsg(columnChilds + " and " + valueChilds));
                }
                ArrayList<ExprNodeDesc> oldValueChilds = new ArrayList<ExprNodeDesc>(valueChilds);
                valueChilds.clear();
                for (int i = 0; i < oldValueChilds.size(); ++i) {
                    ExprNodeDesc newValue = DefaultExprProcessor.interpretNodeAsStruct(columnChilds.get(i), (ExprNodeDesc)oldValueChilds.get(i));
                    valueChilds.add(newValue);
                }
            }
            return valueDesc;
        }

        private static ExprNodeDesc interpretNodeAs(PrimitiveTypeInfo colTypeInfo, ExprNodeDesc constChild) {
            if (constChild instanceof ExprNodeConstantDesc) {
                Object constVal = ((ExprNodeConstantDesc)constChild).getValue();
                if (constVal == null) {
                    return new ExprNodeConstantDesc(colTypeInfo, null);
                }
                Object newConst = DefaultExprProcessor.interpretConstantAsPrimitive(colTypeInfo, constVal, constChild.getTypeInfo());
                if (newConst == null) {
                    return null;
                }
                if (newConst == constVal) {
                    return constChild;
                }
                return new ExprNodeConstantDesc(DefaultExprProcessor.adjustType(colTypeInfo, newConst), newConst);
            }
            return constChild;
        }

        private static TypeInfo adjustType(PrimitiveTypeInfo colTypeInfo, Object newConst) {
            if (newConst instanceof HiveDecimal) {
                return NumExprProcessor.adjustType((HiveDecimal)newConst);
            }
            return colTypeInfo;
        }

        private static Object interpretConstantAsPrimitive(PrimitiveTypeInfo colTypeInfo, Object constVal, TypeInfo constTypeInfo) {
            String constTypeInfoName;
            block15: {
                constTypeInfoName = constTypeInfo.getTypeName();
                if (constVal instanceof Number || constVal instanceof String) {
                    try {
                        PrimitiveObjectInspectorUtils.PrimitiveTypeEntry primitiveTypeEntry = colTypeInfo.getPrimitiveTypeEntry();
                        if (PrimitiveObjectInspectorUtils.intTypeEntry.equals(primitiveTypeEntry)) {
                            return new Integer(constVal.toString());
                        }
                        if (PrimitiveObjectInspectorUtils.longTypeEntry.equals(primitiveTypeEntry)) {
                            return new Long(constVal.toString());
                        }
                        if (PrimitiveObjectInspectorUtils.doubleTypeEntry.equals(primitiveTypeEntry)) {
                            return new Double(constVal.toString());
                        }
                        if (PrimitiveObjectInspectorUtils.floatTypeEntry.equals(primitiveTypeEntry)) {
                            return new Float(constVal.toString());
                        }
                        if (PrimitiveObjectInspectorUtils.byteTypeEntry.equals(primitiveTypeEntry)) {
                            return new Byte(constVal.toString());
                        }
                        if (PrimitiveObjectInspectorUtils.shortTypeEntry.equals(primitiveTypeEntry)) {
                            return new Short(constVal.toString());
                        }
                        if (PrimitiveObjectInspectorUtils.decimalTypeEntry.equals(primitiveTypeEntry)) {
                            return HiveDecimal.create(constVal.toString());
                        }
                    }
                    catch (NumberFormatException nfe) {
                        LOG.trace("Failed to narrow type of constant", (Throwable)nfe);
                        if (NumberUtils.isNumber(constVal.toString())) break block15;
                        return null;
                    }
                }
            }
            if (constVal instanceof HiveDecimal) {
                HiveDecimal hiveDecimal = (HiveDecimal)constVal;
                PrimitiveObjectInspectorUtils.PrimitiveTypeEntry primitiveTypeEntry = colTypeInfo.getPrimitiveTypeEntry();
                if (PrimitiveObjectInspectorUtils.doubleTypeEntry.equals(primitiveTypeEntry)) {
                    return hiveDecimal.doubleValue();
                }
                if (PrimitiveObjectInspectorUtils.floatTypeEntry.equals(primitiveTypeEntry)) {
                    return Float.valueOf(hiveDecimal.floatValue());
                }
                return hiveDecimal;
            }
            if (constTypeInfoName.equalsIgnoreCase("string") && colTypeInfo instanceof CharTypeInfo) {
                int length;
                HiveChar newValue;
                String constValue = constVal.toString();
                HiveChar maxCharConst = new HiveChar(constValue, 255);
                if (maxCharConst.equals(newValue = new HiveChar(constValue, length = TypeInfoUtils.getCharacterLengthForType(colTypeInfo)))) {
                    return newValue;
                }
                return null;
            }
            return constVal;
        }

        private boolean canConvertIntoCoalesce(GenericUDF genericUDF, ArrayList<ExprNodeDesc> children) {
            if (genericUDF instanceof GenericUDFWhen && children.size() == 3 && children.get(1) instanceof ExprNodeConstantDesc && children.get(2) instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc constThen = (ExprNodeConstantDesc)children.get(1);
                ExprNodeConstantDesc constElse = (ExprNodeConstantDesc)children.get(2);
                Object thenVal = constThen.getValue();
                Object elseVal = constElse.getValue();
                if (thenVal instanceof Boolean && elseVal instanceof Boolean) {
                    return true;
                }
            }
            return false;
        }

        private boolean canConvertCaseIntoIf(GenericUDF genericUDF, List<ExprNodeDesc> inputs) {
            return genericUDF instanceof GenericUDFWhen && inputs.size() == 3 && TypeInfoFactory.booleanTypeInfo.equals(inputs.get(0).getTypeInfo());
        }

        private boolean isDescendant(Node ans, Node des) {
            if (ans.getChildren() == null) {
                return false;
            }
            for (Node node : ans.getChildren()) {
                if (node == des) {
                    return true;
                }
                if (!this.isDescendant(node, des)) continue;
                return true;
            }
            return false;
        }

        protected ExprNodeDesc processQualifiedColRef(TypeCheckCtx ctx, ASTNode expr, Object ... nodeOutputs) throws SemanticException {
            String colName;
            RowResolver input = ctx.getInputRR();
            String tableAlias = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText());
            if (nodeOutputs[1] instanceof ExprNodeConstantDesc) {
                colName = ((ExprNodeConstantDesc)nodeOutputs[1]).getValue().toString();
            } else if (nodeOutputs[1] instanceof ExprNodeColumnDesc) {
                colName = ((ExprNodeColumnDesc)nodeOutputs[1]).getColumn();
            } else {
                throw new SemanticException("Unexpected ExprNode : " + nodeOutputs[1]);
            }
            ColumnInfo colInfo = input.get(tableAlias, colName);
            if (colInfo == null && ctx.getOuterRR() != null) {
                RowResolver outerRR = ctx.getOuterRR();
                colInfo = outerRR.get(tableAlias, colName);
            }
            if (colInfo == null) {
                ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr.getChild(1)), expr);
                return null;
            }
            return TypeCheckProcFactory.toExprNodeDesc(colInfo);
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            boolean isFunction;
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                if (this.isDescendant(nd, ctx.getErrorSrcNode())) {
                    ctx.setError(null, null);
                }
                return desc;
            }
            if (ctx.getError() != null) {
                return null;
            }
            ASTNode expr = (ASTNode)nd;
            if (windowingTokens.contains(expr.getType())) {
                if (!ctx.getallowWindowing()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_FUNCTION.getMsg("Windowing is not supported in the context")));
                }
                return null;
            }
            if (expr.getType() == 1099 || expr.getType() == 1021) {
                return null;
            }
            if (expr.getType() == 1133) {
                return null;
            }
            if (expr.getType() == 753) {
                if (!ctx.getallowAllColRef()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_COLUMN.getMsg("All column reference is not supported in the context")));
                }
                RowResolver input = ctx.getInputRR();
                ExprNodeColumnListDesc columnList = new ExprNodeColumnListDesc();
                assert (expr.getChildCount() <= 1);
                if (expr.getChildCount() == 1) {
                    ASTNode child = (ASTNode)expr.getChild(0);
                    assert (child.getType() == 1133);
                    assert (child.getChildCount() == 1);
                    String tableAlias = BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    Map<String, ColumnInfo> columns = input.getFieldMap(tableAlias);
                    if (columns == null) {
                        throw new SemanticException(ErrorMsg.INVALID_TABLE_ALIAS.getMsg(child));
                    }
                    for (Map.Entry<String, ColumnInfo> colMap : columns.entrySet()) {
                        ColumnInfo colInfo = colMap.getValue();
                        if (colInfo.getIsVirtualCol()) continue;
                        columnList.addColumn(TypeCheckProcFactory.toExprNodeDesc(colInfo));
                    }
                } else {
                    for (ColumnInfo colInfo : input.getColumnInfos()) {
                        if (colInfo.getIsVirtualCol()) continue;
                        columnList.addColumn(TypeCheckProcFactory.toExprNodeDesc(colInfo));
                    }
                }
                return columnList;
            }
            if (expr.getType() == 16 && expr.getChild(0).getType() == 1130 && nodeOutputs[0] == null) {
                return this.processQualifiedColRef(ctx, expr, nodeOutputs);
            }
            if (conversionFunctionTextHashMap.keySet().contains(expr.getType()) || expr.getToken().getType() == 12 || expr.getToken().getType() == 11) {
                return null;
            }
            boolean bl = isFunction = expr.getType() == 909 || expr.getType() == 911 || expr.getType() == 910;
            if (!ctx.getAllowDistinctFunctions() && expr.getType() == 910) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.DISTINCT_NOT_SUPPORTED.getMsg()));
            }
            int childrenBegin = isFunction ? 1 : 0;
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>(expr.getChildCount() - childrenBegin);
            for (int ci = childrenBegin; ci < expr.getChildCount(); ++ci) {
                if (nodeOutputs[ci] instanceof ExprNodeColumnListDesc) {
                    children.addAll(((ExprNodeColumnListDesc)nodeOutputs[ci]).getChildren());
                    continue;
                }
                children.add((ExprNodeDesc)nodeOutputs[ci]);
            }
            if (expr.getType() == 911) {
                if (!ctx.getallowFunctionStar()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_COLUMN.getMsg(".* reference is not supported in the context")));
                }
                RowResolver input = ctx.getInputRR();
                for (ColumnInfo colInfo : input.getColumnInfos()) {
                    if (colInfo.getIsVirtualCol()) continue;
                    children.add(TypeCheckProcFactory.toExprNodeDesc(colInfo));
                }
            }
            if (children.contains(null)) {
                List<String> possibleColumnNames = this.getReferenceableColumnAliases(ctx);
                String reason = String.format("(possible column names are: %s)", StringUtils.join(possibleColumnNames, ", "));
                ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr.getChild(0), reason), expr);
                return null;
            }
            try {
                return this.getXpathOrFuncExprNodeDesc(expr, isFunction, children, ctx);
            }
            catch (UDFArgumentTypeException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT_TYPE.getMsg(expr.getChild(childrenBegin + e.getArgumentId()), e.getMessage()), e);
            }
            catch (UDFArgumentLengthException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT_LENGTH.getMsg(expr, e.getMessage()), e);
            }
            catch (UDFArgumentException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT.getMsg(expr, e.getMessage()), e);
            }
        }

        protected List<String> getReferenceableColumnAliases(TypeCheckCtx ctx) {
            return ctx.getInputRR().getReferenceableColumnAliases(null, -1);
        }

        static {
            specialUnaryOperatorTextHashMap.put(385, "positive");
            specialUnaryOperatorTextHashMap.put(380, "negative");
            conversionFunctionTextHashMap = new HashMap();
            conversionFunctionTextHashMap.put(826, "boolean");
            conversionFunctionTextHashMap.put(1144, "tinyint");
            conversionFunctionTextHashMap.put(1089, "smallint");
            conversionFunctionTextHashMap.put(928, "int");
            conversionFunctionTextHashMap.put(823, "bigint");
            conversionFunctionTextHashMap.put(904, "float");
            conversionFunctionTextHashMap.put(877, "double");
            conversionFunctionTextHashMap.put(1094, "string");
            conversionFunctionTextHashMap.put(829, "char");
            conversionFunctionTextHashMap.put(1169, "varchar");
            conversionFunctionTextHashMap.put(824, "binary");
            conversionFunctionTextHashMap.put(857, "date");
            conversionFunctionTextHashMap.put(1140, "timestamp");
            conversionFunctionTextHashMap.put(1142, "timestamp with local time zone");
            conversionFunctionTextHashMap.put(939, "interval_year_month");
            conversionFunctionTextHashMap.put(932, "interval_day_time");
            conversionFunctionTextHashMap.put(864, "decimal");
            windowingTokens = new HashSet();
            windowingTokens.add(235);
            windowingTokens.add(998);
            windowingTokens.add(876);
            windowingTokens.add(1090);
            windowingTokens.add(832);
            windowingTokens.add(1177);
            windowingTokens.add(1176);
            windowingTokens.add(1178);
            windowingTokens.add(337);
            windowingTokens.add(247);
            windowingTokens.add(144);
            windowingTokens.add(83);
            windowingTokens.add(1135);
            windowingTokens.add(1136);
            windowingTokens.add(971);
            windowingTokens.add(972);
        }
    }

    public static class ColumnExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ColumnInfo colInfo;
            boolean isTableAlias;
            String tableOrCol;
            RowResolver input;
            ASTNode parent;
            ASTNode expr;
            TypeCheckCtx ctx;
            block15: {
                ctx = (TypeCheckCtx)procCtx;
                if (ctx.getError() != null) {
                    return null;
                }
                ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
                if (desc != null) {
                    return desc;
                }
                expr = (ASTNode)nd;
                parent = stack.size() > 1 ? (ASTNode)stack.get(stack.size() - 2) : null;
                input = ctx.getInputRR();
                if (input == null) {
                    ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr), expr);
                    return null;
                }
                if (expr.getType() != 1130) {
                    ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr), expr);
                    return null;
                }
                assert (expr.getChildCount() == 1);
                tableOrCol = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText());
                isTableAlias = input.hasTableAlias(tableOrCol);
                colInfo = null;
                try {
                    colInfo = input.get(null, tableOrCol);
                }
                catch (SemanticException semanticException) {
                    if (isTableAlias && parent != null && parent.getType() == 16) break block15;
                    throw semanticException;
                }
            }
            if (ctx.getOuterRR() != null && colInfo == null && !isTableAlias) {
                RowResolver outerRR = ctx.getOuterRR();
                isTableAlias = outerRR.hasTableAlias(tableOrCol);
                colInfo = outerRR.get(null, tableOrCol);
            }
            if (isTableAlias) {
                if (colInfo != null) {
                    if (parent != null && parent.getType() == 16) {
                        return null;
                    }
                    return TypeCheckProcFactory.toExprNodeDesc(colInfo);
                }
                return null;
            }
            if (colInfo == null) {
                if (input.getIsExprResolver()) {
                    ASTNode exprNode = expr;
                    if (!stack.empty()) {
                        ASTNode tmp = (ASTNode)stack.pop();
                        if (!stack.empty()) {
                            exprNode = (ASTNode)stack.peek();
                        }
                        stack.push(tmp);
                    }
                    ctx.setError(ErrorMsg.NON_KEY_EXPR_IN_GROUPBY.getMsg(exprNode), expr);
                    return null;
                }
                List<String> possibleColumnNames = input.getReferenceableColumnAliases(tableOrCol, -1);
                String reason = String.format("(possible column names are: %s)", StringUtils.join(possibleColumnNames, ", "));
                ctx.setError(ErrorMsg.INVALID_TABLE_OR_COLUMN.getMsg(expr.getChild(0), reason), expr);
                LOG.debug(ErrorMsg.INVALID_TABLE_OR_COLUMN.toString() + ":" + input.toString());
                return null;
            }
            return TypeCheckProcFactory.toExprNodeDesc(colInfo);
        }
    }

    public static class IntervalExprProcessor
    implements NodeProcessor {
        private static final BigDecimal NANOS_PER_SEC_BD = new BigDecimal(1000000000);

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String intervalString = BaseSemanticAnalyzer.stripQuotes(expr.getText());
            try {
                switch (expr.getType()) {
                    case 940: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, HiveIntervalYearMonth.valueOf(intervalString));
                    }
                    case 933: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, HiveIntervalDayTime.valueOf(intervalString));
                    }
                    case 938: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, new HiveIntervalYearMonth(Integer.parseInt(intervalString), 0));
                    }
                    case 936: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, new HiveIntervalYearMonth(0, Integer.parseInt(intervalString)));
                    }
                    case 931: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(Integer.parseInt(intervalString), 0, 0, 0, 0));
                    }
                    case 934: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(0, Integer.parseInt(intervalString), 0, 0, 0));
                    }
                    case 935: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(0, 0, Integer.parseInt(intervalString), 0, 0));
                    }
                    case 937: {
                        BigDecimal bd = new BigDecimal(intervalString);
                        BigDecimal bdSeconds = new BigDecimal(bd.toBigInteger());
                        BigDecimal bdNanos = bd.subtract(bdSeconds);
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(0, 0, 0, bdSeconds.intValueExact(), bdNanos.multiply(NANOS_PER_SEC_BD).intValue()));
                    }
                }
                throw new IllegalArgumentException("Invalid time literal type " + expr.getType());
            }
            catch (Exception err) {
                throw new SemanticException("Unable to convert interval literal '" + intervalString + "' to interval value.", err);
            }
        }
    }

    public static class DateTimeExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String timeString = BaseSemanticAnalyzer.stripQuotes(expr.getText());
            try {
                if (expr.getType() == 858) {
                    PrimitiveTypeInfo typeInfo = TypeInfoFactory.dateTypeInfo;
                    return new ExprNodeConstantDesc(typeInfo, Date.valueOf(timeString));
                }
                if (expr.getType() == 1141) {
                    return new ExprNodeConstantDesc(TypeInfoFactory.timestampTypeInfo, Timestamp.valueOf(timeString));
                }
                if (expr.getType() == 1143) {
                    HiveConf conf;
                    try {
                        conf = Hive.get().getConf();
                    }
                    catch (HiveException e) {
                        throw new SemanticException(e);
                    }
                    return new ExprNodeConstantDesc(TypeInfoFactory.getTimestampTZTypeInfo(conf.getLocalTimeZone()), TimestampTZUtil.parse(timeString));
                }
                throw new IllegalArgumentException("Invalid time literal type " + expr.getType());
            }
            catch (Exception err) {
                throw new SemanticException("Unable to convert time literal '" + timeString + "' to time value.", err);
            }
        }
    }

    public static class BoolExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            Boolean bool = null;
            switch (expr.getToken().getType()) {
                case 334: {
                    bool = Boolean.TRUE;
                    break;
                }
                case 136: {
                    bool = Boolean.FALSE;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, bool);
        }
    }

    public static class StrExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String str = null;
            switch (expr.getToken().getType()) {
                case 395: {
                    str = BaseSemanticAnalyzer.unescapeSQLString(expr.getText());
                    break;
                }
                case 1095: {
                    StringBuilder sb = new StringBuilder();
                    for (Node n : expr.getChildren()) {
                        sb.append(BaseSemanticAnalyzer.unescapeSQLString(((ASTNode)n).getText()));
                    }
                    str = sb.toString();
                    break;
                }
                case 830: {
                    str = BaseSemanticAnalyzer.charSetString(expr.getChild(0).getText(), expr.getChild(1).getText());
                    break;
                }
                default: {
                    str = BaseSemanticAnalyzer.unescapeIdentifier(expr.getText().toLowerCase());
                }
            }
            return new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, str);
        }
    }

    public static class NumExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            Number v = null;
            ExprNodeConstantDesc decimalNode = null;
            ASTNode expr = (ASTNode)nd;
            try {
                if (expr.getText().endsWith("L")) {
                    v = Long.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else if (expr.getText().endsWith("S")) {
                    v = Short.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else if (expr.getText().endsWith("Y")) {
                    v = Byte.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else {
                    if (expr.getText().endsWith("BD")) {
                        String strVal = expr.getText().substring(0, expr.getText().length() - 2);
                        return NumExprProcessor.createDecimal(strVal, false);
                    }
                    if (expr.getText().endsWith("F")) {
                        v = Float.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                    } else if (expr.getText().endsWith("D")) {
                        v = Double.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                    } else {
                        v = Double.valueOf(expr.getText());
                        if (expr.getText() != null && !expr.getText().toLowerCase().contains("e") && (decimalNode = NumExprProcessor.createDecimal(expr.getText(), true)) != null) {
                            v = null;
                        }
                        v = Long.valueOf(expr.getText());
                        v = Integer.valueOf(expr.getText());
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (v == null && decimalNode == null) {
                throw new SemanticException(ErrorMsg.INVALID_NUMERICAL_CONSTANT.getMsg(expr));
            }
            return v != null ? new ExprNodeConstantDesc(v) : decimalNode;
        }

        public static ExprNodeConstantDesc createDecimal(String strVal, boolean notNull) {
            HiveDecimal hd = HiveDecimal.create(strVal);
            if (notNull && hd == null) {
                return null;
            }
            return new ExprNodeConstantDesc(NumExprProcessor.adjustType(hd), hd);
        }

        private static DecimalTypeInfo adjustType(HiveDecimal hd) {
            int prec = 1;
            int scale = 0;
            if (hd != null) {
                prec = hd.precision();
                scale = hd.scale();
            }
            DecimalTypeInfo typeInfo = TypeInfoFactory.getDecimalTypeInfo(prec, scale);
            return typeInfo;
        }
    }

    public static class NullExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            return new ExprNodeConstantDesc(TypeInfoFactory.getPrimitiveTypeInfoFromPrimitiveWritable(NullWritable.class), null);
        }
    }
}

