/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;

class CreateTableHandler
extends AbstractEventHandler<CreateTableMessage> {
    CreateTableHandler(NotificationEvent event) {
        super(event);
    }

    @Override
    CreateTableMessage eventMessage(String stringRepresentation) {
        return this.deserializer.getCreateTableMessage(stringRepresentation);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        LOG.info("Processing#{} CREATE_TABLE message : {}", (Object)this.fromEventId(), (Object)this.eventMessageAsJSON);
        org.apache.hadoop.hive.metastore.api.Table tobj = ((CreateTableMessage)this.eventMessage).getTableObj();
        if (tobj == null) {
            LOG.debug("Event#{} was a CREATE_TABLE_EVENT with no table listed", (Object)this.fromEventId());
            return;
        }
        Table qlMdTable = new Table(tobj);
        if (!Utils.shouldReplicate(withinContext.replicationSpec, qlMdTable, true, withinContext.getTablesForBootstrap(), withinContext.oldReplScope, withinContext.hiveConf)) {
            return;
        }
        if (qlMdTable.isView()) {
            withinContext.replicationSpec.setIsMetadataOnly(true);
        }
        if (Utils.shouldDumpMetaDataOnly(withinContext.hiveConf) || Utils.shouldDumpMetaDataOnlyForExternalTables(qlMdTable, withinContext.hiveConf)) {
            qlMdTable.setStatsStateLikeNewTable();
        }
        Path metaDataPath = new Path(withinContext.eventRoot, "_metadata");
        EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)withinContext.hiveConf), metaDataPath, qlMdTable, null, withinContext.replicationSpec, withinContext.hiveConf);
        boolean copyAtLoad = withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET);
        Iterable<String> files = ((CreateTableMessage)this.eventMessage).getFiles();
        if (files != null) {
            if (copyAtLoad) {
                Path dataPath = new Path(withinContext.eventRoot, "data");
                this.writeEncodedDumpFiles(withinContext, files, dataPath);
            } else {
                for (String file : files) {
                    this.writeFileEntry(qlMdTable, null, file, withinContext);
                }
            }
        }
        withinContext.createDmd(this).write();
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_CREATE_TABLE;
    }
}

