/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbortTxnHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AddForeignKeyHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AddNotNullConstraintHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AddPartitionHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AddPrimaryKeyHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AddUniqueConstraintHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AllocWriteIdHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AlterDatabaseHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AlterPartitionHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AlterTableHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.CommitTxnHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.CreateDatabaseHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.CreateFunctionHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.CreateTableHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.DefaultHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.DeletePartColStatHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.DeleteTableColStatHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.DropConstraintHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.DropDatabaseHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.DropFunctionHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.DropPartitionHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.DropTableHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.InsertHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.OpenTxnHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.UpdatePartColStatHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.UpdateTableColStatHandler;

public class EventHandlerFactory {
    private static Map<String, Class<? extends EventHandler>> registeredHandlers = new HashMap<String, Class<? extends EventHandler>>();

    private EventHandlerFactory() {
    }

    static void register(String event, Class<? extends EventHandler> handlerClazz) {
        try {
            Constructor<? extends EventHandler> constructor = handlerClazz.getDeclaredConstructor(NotificationEvent.class);
            assert (constructor != null);
            assert (!Modifier.isPrivate(constructor.getModifiers()));
            registeredHandlers.put(event, handlerClazz);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("handler class: " + handlerClazz.getCanonicalName() + " does not have the a constructor with only parameter of type:" + NotificationEvent.class.getCanonicalName(), e);
        }
    }

    public static EventHandler handlerFor(NotificationEvent event) {
        if (registeredHandlers.containsKey(event.getEventType())) {
            Class<? extends EventHandler> handlerClazz = registeredHandlers.get(event.getEventType());
            try {
                Constructor<? extends EventHandler> constructor = handlerClazz.getDeclaredConstructor(NotificationEvent.class);
                return constructor.newInstance(event);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("failed when creating handler for " + event.getEventType() + " with the responsible class being " + handlerClazz.getCanonicalName(), e);
            }
        }
        return new DefaultHandler(event);
    }

    static {
        EventHandlerFactory.register("ADD_PARTITION", AddPartitionHandler.class);
        EventHandlerFactory.register("ALTER_DATABASE", AlterDatabaseHandler.class);
        EventHandlerFactory.register("ALTER_PARTITION", AlterPartitionHandler.class);
        EventHandlerFactory.register("ALTER_TABLE", AlterTableHandler.class);
        EventHandlerFactory.register("CREATE_FUNCTION", CreateFunctionHandler.class);
        EventHandlerFactory.register("CREATE_TABLE", CreateTableHandler.class);
        EventHandlerFactory.register("DROP_PARTITION", DropPartitionHandler.class);
        EventHandlerFactory.register("DROP_TABLE", DropTableHandler.class);
        EventHandlerFactory.register("INSERT", InsertHandler.class);
        EventHandlerFactory.register("DROP_FUNCTION", DropFunctionHandler.class);
        EventHandlerFactory.register("ADD_PRIMARYKEY", AddPrimaryKeyHandler.class);
        EventHandlerFactory.register("ADD_FOREIGNKEY", AddForeignKeyHandler.class);
        EventHandlerFactory.register("ADD_UNIQUECONSTRAINT", AddUniqueConstraintHandler.class);
        EventHandlerFactory.register("ADD_NOTNULLCONSTRAINT", AddNotNullConstraintHandler.class);
        EventHandlerFactory.register("DROP_CONSTRAINT", DropConstraintHandler.class);
        EventHandlerFactory.register("CREATE_DATABASE", CreateDatabaseHandler.class);
        EventHandlerFactory.register("DROP_DATABASE", DropDatabaseHandler.class);
        EventHandlerFactory.register("OPEN_TXN", OpenTxnHandler.class);
        EventHandlerFactory.register("COMMIT_TXN", CommitTxnHandler.class);
        EventHandlerFactory.register("ABORT_TXN", AbortTxnHandler.class);
        EventHandlerFactory.register("ALLOC_WRITE_ID_EVENT", AllocWriteIdHandler.class);
        EventHandlerFactory.register("UPDATE_TBL_COL_STAT_EVENT", UpdateTableColStatHandler.class);
        EventHandlerFactory.register("DELETE_TBL_COL_STAT_EVENT", DeleteTableColStatHandler.class);
        EventHandlerFactory.register("UPDATE_PART_COL_STAT_EVENT", UpdatePartColStatHandler.class);
        EventHandlerFactory.register("DELETE_PART_COL_STAT_EVENT", DeletePartColStatHandler.class);
    }
}

