/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.io;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.JsonWriter;

public class ConstraintsSerializer
implements JsonWriter.Serializer {
    private HiveConf hiveConf;
    private List<SQLPrimaryKey> pks;
    private List<SQLForeignKey> fks;
    private List<SQLUniqueConstraint> uks;
    private List<SQLNotNullConstraint> nns;

    public ConstraintsSerializer(List<SQLPrimaryKey> pks, List<SQLForeignKey> fks, List<SQLUniqueConstraint> uks, List<SQLNotNullConstraint> nns, HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.pks = pks;
        this.fks = fks;
        this.uks = uks;
        this.nns = nns;
    }

    @Override
    public void writeTo(JsonWriter writer, ReplicationSpec additionalPropertiesProvider) throws SemanticException, IOException {
        String nnsString = "";
        String uksString = "";
        String fksString = "";
        String pksString = "";
        if (this.pks != null) {
            pksString = MessageBuilder.getInstance().buildAddPrimaryKeyMessage(this.pks).toString();
        }
        if (this.fks != null) {
            fksString = MessageBuilder.getInstance().buildAddForeignKeyMessage(this.fks).toString();
        }
        if (this.uks != null) {
            uksString = MessageBuilder.getInstance().buildAddUniqueConstraintMessage(this.uks).toString();
        }
        if (this.nns != null) {
            nnsString = MessageBuilder.getInstance().buildAddNotNullConstraintMessage(this.nns).toString();
        }
        writer.jsonGenerator.writeStringField("pks", pksString);
        writer.jsonGenerator.writeStringField("uks", uksString);
        writer.jsonGenerator.writeStringField("nns", nnsString);
        writer.jsonGenerator.writeStringField("fks", fksString);
    }
}

