/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.partition.drop.AlterTableDropPartitionDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;

public class DropPartitionHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        try {
            DropPartitionMessage msg = this.deserializer.getDropPartitionMessage(context.dmd.getPayload());
            String actualDbName = context.isDbNameEmpty() ? msg.getDB() : context.dbName;
            String actualTblName = msg.getTable();
            Map<Integer, List<ExprNodeGenericFuncDesc>> partSpecs = ReplUtils.genPartSpecs(new Table(msg.getTableObj()), msg.getPartitions());
            if (partSpecs.size() > 0) {
                AlterTableDropPartitionDesc dropPtnDesc = new AlterTableDropPartitionDesc(HiveTableName.ofNullable(actualTblName, actualDbName), partSpecs, true, context.eventOnlyReplicationSpec());
                Task<DDLWork> dropPtnTask = TaskFactory.get(new DDLWork(this.readEntitySet, this.writeEntitySet, dropPtnDesc, true, context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
                context.log.debug("Added drop ptn task : {}:{},{}", new Object[]{dropPtnTask.getId(), dropPtnDesc.getTableName(), msg.getPartitions()});
                this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, actualTblName, null);
                return Collections.singletonList(dropPtnTask);
            }
            throw new SemanticException("DROP PARTITION EVENT does not return any part descs for event message :" + context.dmd.getPayload());
        }
        catch (Exception e) {
            throw e instanceof SemanticException ? (SemanticException)e : new SemanticException("Error reading message members", e);
        }
    }
}

